/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import paysim.AggregateTransactionRecord;
import paysim.Client;
import paysim.Transaction;

public class AggregateParamFileCreator {
    public ArrayList<AggregateTransactionRecord> generateAggregateParamFile(ArrayList<Transaction> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<AggregateTransactionRecord> arrayList3 = new ArrayList<AggregateTransactionRecord>();
        arrayList2.add("CASH_IN");
        arrayList2.add("CASH_OUT");
        arrayList2.add("DEBIT");
        arrayList2.add("DEPOSIT");
        arrayList2.add("PAYMENT");
        arrayList2.add("TRANSFER");
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 31; ++j) {
                for (int k = 0; k < 24; ++k) {
                    int n = j;
                    int n2 = k;
                    AggregateTransactionRecord aggregateTransactionRecord = this.getAggregateRecord((short)(i + 1), n, n2, arrayList);
                    if (aggregateTransactionRecord == null) continue;
                    arrayList3.add(aggregateTransactionRecord);
                }
            }
        }
        Collections.sort(arrayList3);
        return arrayList3;
    }

    public ArrayList<AggregateTransactionRecord> reformat(ArrayList<AggregateTransactionRecord> arrayList) {
        ArrayList<AggregateTransactionRecord> arrayList2 = new ArrayList<AggregateTransactionRecord>();
        ArrayList<AggregateTransactionRecord> arrayList3 = new ArrayList<AggregateTransactionRecord>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AggregateTransactionRecord aggregateTransactionRecord;
            int n;
            arrayList3 = new ArrayList();
            AggregateTransactionRecord aggregateTransactionRecord2 = arrayList.get(i);
            arrayList3.add(aggregateTransactionRecord2);
            for (n = i + 1; n < arrayList.size() && aggregateTransactionRecord2.equals(aggregateTransactionRecord = arrayList.get(n)); ++n) {
                arrayList3.add(aggregateTransactionRecord);
            }
            i = n - 1;
            if (arrayList3.size() > 1) {
                aggregateTransactionRecord = this.compactAggrRecord(arrayList3);
                arrayList2.add(aggregateTransactionRecord);
                continue;
            }
            arrayList2.add(aggregateTransactionRecord2);
        }
        return arrayList2;
    }

    private AggregateTransactionRecord compactAggrRecord(ArrayList<AggregateTransactionRecord> arrayList) {
        int n;
        AggregateTransactionRecord aggregateTransactionRecord = new AggregateTransactionRecord();
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        l = Long.parseLong(arrayList.get(0).gettHour());
        l2 = Long.parseLong(arrayList.get(0).getMonth());
        l3 = Long.parseLong(arrayList.get(0).gettDay());
        d5 = Double.parseDouble(arrayList.get(0).getType());
        for (n = 0; n < arrayList.size(); ++n) {
            d += Double.parseDouble(arrayList.get(n).gettCount());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            d2 += Double.parseDouble(arrayList.get(n).gettSum());
        }
        for (n = 0; n < arrayList.size(); ++n) {
            d4 += Double.parseDouble(arrayList.get(n).gettStd());
        }
        d3 = d2 / d;
        d4 /= (double)arrayList.size();
        aggregateTransactionRecord.setType(String.valueOf(d5));
        aggregateTransactionRecord.setMonth(String.valueOf(l2));
        aggregateTransactionRecord.settDay(String.valueOf(l3));
        aggregateTransactionRecord.settHour(String.valueOf(l));
        aggregateTransactionRecord.settCount(String.valueOf(d));
        aggregateTransactionRecord.settSum(String.valueOf(d2));
        aggregateTransactionRecord.settAvg(String.valueOf(d3));
        aggregateTransactionRecord.settStd(String.valueOf(d4));
        return aggregateTransactionRecord;
    }

    public static ArrayList<Transaction> getRandomTransaction() {
        Client client = new Client();
        ArrayList<Transaction> arrayList = new ArrayList<Transaction>();
        Transaction transaction = new Transaction((Long)1L, client, 1, 1348.0, "CASH_IN");
        transaction.setDay(1);
        transaction.setHour(3);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 1, 1848.0, "CASH_IN");
        transaction.setDay(2);
        transaction.setHour(5);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 1, 1248.0, "CASH_IN");
        transaction.setDay(2);
        transaction.setHour(5);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 1, 7848.0, "CASH_IN");
        transaction.setDay(1);
        transaction.setHour(3);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 1, 2348.0, "CASH_IN");
        transaction.setDay(1);
        transaction.setHour(3);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 1, 6348.0, "CASH_IN");
        transaction.setDay(1);
        transaction.setHour(3);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 3912.0, "CASH_OUT");
        transaction.setDay(1);
        transaction.setHour(3);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 13431.0, "CASH_OUT");
        transaction.setDay(1);
        transaction.setHour(3);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 3731.0, "CASH_OUT");
        transaction.setDay(1);
        transaction.setHour(3);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 9731.0, "CASH_OUT");
        transaction.setDay(2);
        transaction.setHour(7);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 13731.0, "CASH_OUT");
        transaction.setDay(2);
        transaction.setHour(7);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 6731.0, "CASH_OUT");
        transaction.setDay(2);
        transaction.setHour(7);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 11731.0, "CASH_OUT");
        transaction.setDay(2);
        transaction.setHour(6);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 3731.0, "CASH_OUT");
        transaction.setDay(2);
        transaction.setHour(6);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 2, 1731.0, "CASH_OUT");
        transaction.setDay(2);
        transaction.setHour(6);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 4, 2348.0, "DEPOSIT");
        transaction.setDay(6);
        transaction.setHour(4);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 4, 5731.0, "DEPOSIT");
        transaction.setDay(6);
        transaction.setHour(4);
        arrayList.add(transaction);
        transaction = new Transaction((Long)1L, client, 4, 15731.0, "DEPOSIT");
        transaction.setDay(6);
        transaction.setHour(4);
        arrayList.add(transaction);
        return arrayList;
    }

    public AggregateTransactionRecord getAggregateRecord(short s, int n, int n2, ArrayList<Transaction> arrayList) {
        ArrayList<Transaction> arrayList2 = new ArrayList<Transaction>();
        AggregateTransactionRecord aggregateTransactionRecord = new AggregateTransactionRecord();
        for (int i = 0; i < arrayList.size(); ++i) {
            Transaction transaction = arrayList.get(i);
            if (transaction.getDay() != n || transaction.getHour() != n2 || transaction.getType() != s) continue;
            arrayList2.add(transaction);
        }
        if (arrayList2.size() > 0) {
            double d = this.getTotalAmount(arrayList2);
            int n3 = arrayList2.size();
            double d2 = this.getDoublePrecision(2, d / (double)n3);
            double d3 = AggregateParamFileCreator.getStdv(arrayList2, d2);
            aggregateTransactionRecord.setType(String.valueOf(s));
            aggregateTransactionRecord.settSum(String.valueOf(d));
            aggregateTransactionRecord.settCount(String.valueOf(n3));
            aggregateTransactionRecord.settAvg(String.valueOf(this.getDoublePrecision(2, d2)));
            aggregateTransactionRecord.settStd(String.valueOf(this.getDoublePrecision(2, d3)));
            aggregateTransactionRecord.setMonth(String.valueOf(10));
            aggregateTransactionRecord.settDay(String.valueOf(n));
            aggregateTransactionRecord.settHour(String.valueOf(n2));
            return aggregateTransactionRecord;
        }
        return null;
    }

    private double getDoublePrecision(int n, double d) {
        try {
            Double d2 = new Double(d);
            Double d3 = new BigDecimal(d2).setScale(n, 4).doubleValue();
            return d3;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static double getStdv(ArrayList<Transaction> arrayList, double d) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            double d4 = arrayList.get(i).getAmount() - d;
            d4 *= d4;
            d3 += d4;
        }
        return Math.sqrt(d3 /= (double)arrayList.size() - 1.0);
    }

    private double getTotalAmount(ArrayList<Transaction> arrayList) {
        double d = 0.0;
        for (Transaction transaction : arrayList) {
            d += transaction.getAmount();
        }
        return d;
    }
}

