/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.util.ArrayList;
import paysim.AggregateTransactionRecord;
import paysim.CurrentStepContainer;
import paysim.PaySim;

public class CurrentStepHandler {
    private ArrayList<CurrentStepContainer> stepHandler = new ArrayList();
    private ArrayList<CurrentStepContainer> stepCountCombination = new ArrayList();
    private ArrayList<String> fileContents = new ArrayList();
    private ArrayList<Integer> stepsThatAreNotAllowed = new ArrayList();
    private ArrayList<AggregateTransactionRecord> aggrRecordList = new ArrayList();
    private double multiplier = 0.0;

    public CurrentStepHandler(ArrayList<String> arrayList, double d) {
        this.setFileContents(arrayList);
        for (int i = 0; i < 744; ++i) {
            CurrentStepContainer currentStepContainer = new CurrentStepContainer();
            currentStepContainer.setCounter(0L);
            currentStepContainer.setCurrentStep(i);
            this.stepHandler.add(currentStepContainer);
        }
        this.initStepCountCombination();
        this.modifyWithMultiplier(d);
        this.initAggregateRecordList();
    }

    private void initAggregateRecordList() {
        for (String string : this.fileContents) {
            String[] stringArray = string.split(",");
            AggregateTransactionRecord aggregateTransactionRecord = new AggregateTransactionRecord();
            aggregateTransactionRecord.setType(stringArray[0]);
            aggregateTransactionRecord.setMonth(stringArray[1]);
            aggregateTransactionRecord.settDay(stringArray[2]);
            aggregateTransactionRecord.settHour(stringArray[3]);
            aggregateTransactionRecord.settCount(stringArray[4]);
            aggregateTransactionRecord.settSum(stringArray[5]);
            aggregateTransactionRecord.settAvg(stringArray[6]);
            aggregateTransactionRecord.settStd(stringArray[7]);
            this.aggrRecordList.add(aggregateTransactionRecord);
        }
    }

    public AggregateTransactionRecord getRecord(String string, int n, int n2) {
        for (AggregateTransactionRecord aggregateTransactionRecord : this.aggrRecordList) {
            if (!aggregateTransactionRecord.getType().equals(string) || !aggregateTransactionRecord.gettDay().equals(String.valueOf(n)) || !aggregateTransactionRecord.gettHour().equals(String.valueOf(n2))) continue;
            return aggregateTransactionRecord;
        }
        return null;
    }

    private void modifyWithMultiplier(double d) {
        for (int i = 0; i < this.stepHandler.size(); ++i) {
            long l = this.stepHandler.get(i).getCounter();
            l = (long)((double)l * d);
            this.stepHandler.get(i).setCounter(l);
        }
    }

    private void initStepCountCombination() {
        int n;
        for (n = 0; n < this.stepHandler.size(); ++n) {
            long l = 0L;
            long l2 = n / 24 + 1;
            long l3 = (int)((long)n - (l2 - 1L) * 24L);
            CurrentStepContainer currentStepContainer = this.stepHandler.get(n);
            boolean bl = this.isInParamFile(l2, l3);
            if (!bl) continue;
            int n2 = 0;
            for (n2 = 1; n2 < this.fileContents.size(); ++n2) {
                String[] stringArray = this.fileContents.get(n2).split(",");
                try {
                    if (Long.parseLong(stringArray[2]) != l2 || Long.parseLong(stringArray[3]) != l3 || !this.isAction(stringArray[0])) continue;
                    l += Long.parseLong(stringArray[4]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            currentStepContainer.setCounter(l);
            n2 = 0;
        }
        for (n = 0; n < this.stepHandler.size(); ++n) {
            if (this.stepHandler.get(n).getCounter() != 0L) continue;
            this.stepHandler.remove(n);
            --n;
        }
        for (CurrentStepContainer currentStepContainer : this.stepHandler) {
        }
    }

    private void initStepsNotAllowed() {
        boolean bl = false;
        for (int i = 0; i < 744; ++i) {
            long l = i / 24 + 1;
            long l2 = (int)((long)i - (l - 1L) * 24L);
            boolean bl2 = this.isInParamFile(l, l2);
            if (bl2) continue;
            this.stepsThatAreNotAllowed.add(i);
        }
    }

    public long getNrOfTimesToReduce(long l) {
        for (int i = 0; i < this.stepHandler.size(); ++i) {
            if (this.stepHandler.get(i).getCurrentStep() != l) continue;
            return this.stepHandler.get(i).getNrReduced();
        }
        return -1L;
    }

    public void increaseReduction(long l) {
        for (int i = 0; i < 744; ++i) {
            if (this.stepHandler.get(i).getCurrentStep() != l) continue;
            this.stepHandler.get(i).increment();
        }
    }

    public void printInfo() {
        long l = 0L;
        for (int i = 0; i < this.stepHandler.size(); ++i) {
            CurrentStepContainer currentStepContainer = this.stepHandler.get(i);
            l += currentStepContainer.getCounter();
        }
    }

    public boolean isTransactionsAtStep(long l, PaySim paySim) {
        for (int i = 0; i < this.stepsThatAreNotAllowed.size(); ++i) {
            if (l != (long)this.stepsThatAreNotAllowed.get(i).intValue()) continue;
            return false;
        }
        return true;
    }

    public boolean nrOfRepGreaterThanCount(long l, PaySim paySim) {
        int n;
        long l2 = 0L;
        long l3 = 0L;
        for (n = 0; n < this.stepCountCombination.size(); ++n) {
            if (this.stepCountCombination.get(n).getCurrentStep() != l) continue;
            l2 = this.stepCountCombination.get(n).getCounter();
            break;
        }
        for (n = 0; n < this.stepHandler.size(); ++n) {
            if (this.stepHandler.get(n).getCurrentStep() != l) continue;
            l3 = this.stepHandler.get(n).getCounter();
            break;
        }
        if (l3 > (l2 = (long)((double)l2 * paySim.getMultiplier()))) {
            this.stepsThatAreNotAllowed.add((int)l);
            return true;
        }
        return false;
    }

    public void setFileContents(ArrayList<String> arrayList) {
        this.fileContents = arrayList;
    }

    private boolean isInParamFile(long l, long l2) {
        for (int i = 1; i < this.fileContents.size(); ++i) {
            String string = this.fileContents.get(i);
            String[] stringArray = string.split(",");
            if (Long.parseLong(stringArray[2]) != l || Long.parseLong(stringArray[3]) != l2) continue;
            return true;
        }
        return false;
    }

    public boolean isAction(String string) {
        return string.equals("CASH_IN") || string.equals("CASH_OUT") || string.equals("TRANSFER") || string.equals("PAYMENT") || string.equals("DEBIT") || string.equals("DEPOSIT");
    }

    public ArrayList<Long> getSteps(long l, long l2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = 0;
        long l3 = 0L;
        while ((long)n < l2) {
            if ((l3 %= (long)this.stepHandler.size()) == 0L && this.isFull(l)) {
                return null;
            }
            CurrentStepContainer currentStepContainer = this.stepHandler.get((int)l3);
            if (currentStepContainer.canBeReduced() && currentStepContainer.getCurrentStep() >= l) {
                this.stepHandler.get((int)l3).increment();
                arrayList.add(currentStepContainer.getCurrentStep());
                ++n;
            }
            ++l3;
        }
        return arrayList;
    }

    public boolean isFull(long l) {
        for (int i = 0; i < this.stepHandler.size(); ++i) {
            if (this.stepHandler.get(i).getCurrentStep() < l || !this.stepHandler.get(i).canBeReduced()) continue;
            return false;
        }
        return true;
    }

    public void printInfo2() {
        long l = 0L;
        for (int i = 0; i < this.stepHandler.size(); ++i) {
            l += this.stepHandler.get(i).getCounter();
        }
    }

    public void convertDeconvert() {
        int n = 50;
        for (CurrentStepContainer currentStepContainer : this.stepHandler) {
            int n2 = (int)(currentStepContainer.getCurrentStep() / 24L) + 1;
            int n3 = (int)(currentStepContainer.getCurrentStep() - (long)((n2 - 1) * 24));
        }
    }
}

