/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import paysim.ParameterizedPaySim;
import paysim.Transaction;

public class DatabaseHandler {
    private Connection con = null;
    private String url = "";
    private String user = "";
    private String password = "";

    public DatabaseHandler(String string, String string2, String string3) {
        this.url = string;
        this.user = string2;
        this.password = string3;
        try {
            this.con = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void insert(Transaction transaction) {
        try {
            String string = "INSERT INTO paysim.paysimLog (logName, pType, pAmount, cliFrom,pOldBalanceFrom,pNewBalanceFrom,cliTo,pOldBalanceTo,pNewBalanceTo,isFraud,isFlaggedFraud,step) VALUES (?,?,?,?,?,?,?,?,?,?,?,?);";
            PreparedStatement preparedStatement = this.con.prepareStatement(string);
            preparedStatement.setString(1, ParameterizedPaySim.simulatorName);
            preparedStatement.setString(2, "" + transaction.getType());
            preparedStatement.setDouble(3, transaction.getAmount());
            preparedStatement.setString(4, transaction.getClientOrigBefore().getName());
            preparedStatement.setDouble(5, transaction.getClientOrigBefore().getBalance());
            preparedStatement.setDouble(6, transaction.getClientOrigAfter().getBalance());
            preparedStatement.setString(7, transaction.getClientDestBefore().getName());
            preparedStatement.setDouble(8, transaction.getClientDestBefore().getBalance());
            preparedStatement.setDouble(9, transaction.getClientDestAfter().getBalance());
            preparedStatement.setBoolean(10, transaction.isFraud());
            preparedStatement.setBoolean(11, transaction.isFlaggedFraud());
            preparedStatement.setLong(12, transaction.getStep());
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void copyDirectory(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.copyDirectory(new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public void close() {
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

