/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import paysim.RepetitionContainer;

public class RepetitionFreqContainer
implements Comparable<RepetitionFreqContainer> {
    RepetitionContainer cont = new RepetitionContainer();
    double typeNr = 0.0;
    int freq = 0;

    public String toString() {
        return this.cont.getType() + "," + (int)this.cont.getLow() + "," + (int)this.cont.getHigh() + "," + this.freq;
    }

    public RepetitionContainer getCont() {
        return this.cont;
    }

    public void setCont(RepetitionContainer repetitionContainer) {
        this.cont = repetitionContainer;
        switch (repetitionContainer.getType()) {
            case "CASH_IN": {
                this.typeNr = 1.0E9;
                break;
            }
            case "CASH_OUT": {
                this.typeNr = 9000000.0;
                break;
            }
            case "DEBIT": {
                this.typeNr = 300000.0;
                break;
            }
            case "PAYMENT": {
                this.typeNr = 100.0;
                break;
            }
            case "TRANSFER": {
                this.typeNr = -1.0;
            }
        }
    }

    public int getFreq() {
        return this.freq;
    }

    public void setFreq(int n) {
        this.freq = n;
    }

    public void incrementFrequency() {
        ++this.freq;
    }

    @Override
    public int compareTo(RepetitionFreqContainer repetitionFreqContainer) {
        if (this.typeNr > repetitionFreqContainer.typeNr) {
            return -1;
        }
        if (this.typeNr < repetitionFreqContainer.typeNr) {
            return 1;
        }
        return 0;
    }
}

