/*
 * Decompiled with CFR 0.152.
 */
package paysim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import paysim.PaySim;

public class TransferMaxHandler {
    ArrayList<String> fileContents = new ArrayList();
    PaySim paysim;
    int transferCounter = 0;
    int paymentCounter = 0;
    int cashInCounter = 0;
    int cashOutCounter = 0;
    int debitCounter = 0;
    int depositCounter = 0;
    int transferMax = 0;
    int paymentMax = 0;
    int cashInMax = 0;
    int cashOutMax = 0;
    int debitMax = 0;
    int depositMax = 0;
    double multiplier = 1.0;

    private void initMax(ArrayList<String> arrayList) {
        this.transferMax = Integer.parseInt(arrayList.get(6).split(",")[1]);
        this.paymentMax = Integer.parseInt(arrayList.get(4).split(",")[1]);
        this.cashInMax = Integer.parseInt(arrayList.get(0).split(",")[1]);
        this.cashOutMax = Integer.parseInt(arrayList.get(1).split(",")[1]);
        this.debitMax = Integer.parseInt(arrayList.get(2).split(",")[1]);
        this.depositMax = Integer.parseInt(arrayList.get(7).split(",")[1]);
    }

    public String toString() {
        return "TransferMaxHandler [transferMax=" + this.transferMax + ", paymentMax=" + this.paymentMax + ", cashInMax=" + this.cashInMax + ", cashOutMax=" + this.cashOutMax + ", debitMax=" + this.debitMax + ", depositMax=" + this.depositMax + "]";
    }

    public boolean repetitionFinished() {
        return this.transferCounter >= this.transferMax && this.paymentCounter >= this.paymentMax && this.cashInCounter >= this.cashInMax && this.cashOutCounter >= this.cashOutMax && this.depositCounter >= this.depositMax;
    }

    public boolean canRepeat(String string) {
        switch (string) {
            case "CASH_IN": {
                ++this.cashInCounter;
                return !((double)this.cashInCounter > this.multiplier * (double)this.cashInMax);
            }
            case "TRANSFER": {
                ++this.transferCounter;
                return !((double)this.transferCounter > this.multiplier * (double)this.transferMax);
            }
            case "CASH_OUT": {
                ++this.cashOutCounter;
                return !((double)this.cashOutCounter > this.multiplier * (double)this.cashOutMax);
            }
            case "DEBIT": {
                ++this.debitCounter;
                return !((double)this.debitCounter > this.multiplier * (double)this.debitMax);
            }
            case "DEPOSIT": {
                ++this.depositCounter;
                return !((double)this.depositCounter > this.multiplier * (double)this.depositMax);
            }
            case "PAYMENT": {
                ++this.paymentCounter;
                return !((double)this.paymentCounter > this.multiplier * (double)this.paymentMax);
            }
        }
        return false;
    }

    private int getMax(String string) {
        for (String string2 : this.fileContents) {
            String[] stringArray = string2.split(",");
            if (!string.equals(stringArray[0])) continue;
            return Integer.parseInt(stringArray[1]);
        }
        return -1;
    }

    public TransferMaxHandler(PaySim paySim) {
        this.init(paySim);
    }

    public TransferMaxHandler(String string) {
        this.init(string);
    }

    private void init(String string) {
        try {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = "";
            bufferedReader.readLine();
            while ((string2 = bufferedReader.readLine()) != null) {
                this.fileContents.add(string2);
            }
            bufferedReader.close();
            for (String string3 : this.fileContents) {
            }
            this.initMax(this.fileContents);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init(PaySim paySim) {
        this.paysim = paySim;
        try {
            File file = new File(this.paysim.getTransferMaxPath());
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.fileContents.add(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initMax(this.fileContents);
        this.multiplier = this.paysim.getMultiplier();
    }

    public double getMaxGivenType(String string) {
        switch (string) {
            case "TRANSFER": {
                return this.transferMax;
            }
            case "CASH_IN": {
                return this.cashInMax;
            }
            case "CASH_OUT": {
                return this.cashOutMax;
            }
            case "DEBIT": {
                return this.debitMax;
            }
            case "DEPOSIT": {
                return this.depositMax;
            }
            case "PAYMENT": {
                return this.paymentMax;
            }
        }
        return -1.0;
    }
}

