/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.sux4j.bits.Rank9;
import it.unimi.dsi.sux4j.bits.Select;
import java.io.IOException;
import java.io.ObjectInputStream;

public class HintedBsearchSelect
implements Select {
    private static final boolean ASSERTS = false;
    private static final long serialVersionUID = 1L;
    private static final long ONES_STEP_9 = 18049651735527937L;
    private static final long MSBS_STEP_9 = 4620710844295151872L;
    private final int[] inventory;
    private final int onesPerInventory;
    private final int log2OnesPerInventory;
    private final long numOnes;
    private final int numWords;
    private transient long[] bits;
    private final long[] count;
    private final Rank9 rank9;

    public HintedBsearchSelect(Rank9 rank9) {
        this.rank9 = rank9;
        this.numOnes = rank9.numOnes;
        this.numWords = rank9.numWords;
        this.bits = rank9.bits;
        this.count = rank9.count;
        this.log2OnesPerInventory = rank9.bitVector.length() == 0L ? 0 : Fast.mostSignificantBit((long)((this.numOnes * 16L * 64L + rank9.bitVector.length() - 1L) / rank9.bitVector.length()));
        this.onesPerInventory = 1 << this.log2OnesPerInventory;
        int inventorySize = (int)((this.numOnes + (long)this.onesPerInventory - 1L) / (long)this.onesPerInventory);
        this.inventory = new int[inventorySize + 1];
        long d = 0L;
        long mask = this.onesPerInventory - 1;
        for (int i = 0; i < this.numWords; ++i) {
            for (int j = 0; j < 64; ++j) {
                if ((this.bits[i] & 1L << j) == 0L) continue;
                if ((d & mask) == 0L) {
                    this.inventory[(int)(d >> this.log2OnesPerInventory)] = i / 8 * 2;
                }
                ++d;
            }
        }
        this.inventory[inventorySize] = this.numWords / 8 * 2;
    }

    @Override
    public long select(long rank) {
        if (rank >= this.numOnes) {
            return -1L;
        }
        long[] count = this.count;
        int[] inventory = this.inventory;
        int inventoryIndexLeft = (int)(rank >>> this.log2OnesPerInventory);
        int blockLeft = inventory[inventoryIndexLeft];
        int blockRight = inventory[inventoryIndexLeft + 1];
        if (rank >= count[blockRight]) {
            blockLeft = blockRight;
            blockRight = blockLeft + 2;
        } else {
            while (blockRight - blockLeft > 2) {
                int blockMiddle = (blockRight + blockLeft) / 2 & 0xFFFFFFFE;
                if (rank >= count[blockMiddle]) {
                    blockLeft = blockMiddle;
                    continue;
                }
                blockRight = blockMiddle;
            }
        }
        long rankInBlock = rank - count[blockLeft];
        long rankInBlockStep9 = rankInBlock * 18049651735527937L;
        long subcounts = count[blockLeft + 1];
        long offsetInBlock = (((((rankInBlockStep9 | 0x4020100804020100L) - (subcounts & 0xBFDFEFF7FBFDFEFFL) | subcounts ^ rankInBlockStep9) ^ subcounts & (rankInBlockStep9 ^ 0xFFFFFFFFFFFFFFFFL)) & 0x4020100804020100L) >>> 8) * 18049651735527937L >>> 54 & 7L;
        long word = (long)(blockLeft * 4) + offsetInBlock;
        long rankInWord = rankInBlock - (subcounts >>> (int)((offsetInBlock - 1L & 7L) * 9L) & 0x1FFL);
        return word * 64L + (long)Fast.select((long)this.bits[(int)word], (int)((int)rankInWord));
    }

    @Override
    public long numBits() {
        return this.rank9.numBits() + (long)this.inventory.length * 32L;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.bits = this.rank9.bitVector.bits();
    }

    @Override
    public BitVector bitVector() {
        return this.rank9.bitVector();
    }
}

