/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.sux4j.bits.BalancedParentheses;
import it.unimi.dsi.sux4j.bits.SparseRank;
import it.unimi.dsi.sux4j.bits.SparseSelect;
import it.unimi.dsi.sux4j.util.EliasFanoLongBigList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;

public class JacobsonBalancedParentheses
implements BalancedParentheses {
    private static final long serialVersionUID = 1L;
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    private static final boolean DDEBUG = false;
    private transient long[] bits;
    protected final BitVector bitVector;
    private final SparseSelect openingPioneers;
    private final SparseRank openingPioneersRank;
    private final EliasFanoLongBigList openingPioneerMatches;
    private final SparseSelect closingPioneers;
    private final SparseRank closingPioneersRank;
    private final EliasFanoLongBigList closingPioneerMatches;
    public static final long ONES_STEP_4 = 0x1111111111111111L;
    public static final long MSBS_STEP_4 = -8608480567731124088L;
    public static final long ONES_STEP_8 = 0x101010101010101L;
    public static final long MSBS_STEP_8 = -9187201950435737472L;
    private static final long ONES_STEP_16 = 0x1000100010001L;
    private static final long MSBS_STEP_16 = -9223231297218904064L;
    private static final long ONES_STEP_32 = 0x100000001L;
    private static final long MSBS_STEP_32 = -9223372034707292160L;
    private static final long L = 4627501566018457608L;
    private static final long L_ALT = 4193460528989997570L;

    public static String binary(long l, boolean reverse) {
        int i;
        if (reverse) {
            l = Long.reverse(l);
        }
        MutableString s = new MutableString().append("0000000000000000000000000000000000000000000000000000000000000000000000000").append(Long.toBinaryString(l));
        s.delete(0, s.length() - 64);
        s.insert(0, '\n');
        s.append('\n');
        for (i = 0; i < 32; ++i) {
            s.append(" ").append(Long.toHexString(l >>> (31 - i) * 2 & 3L));
        }
        s.append('\n');
        for (i = 0; i < 16; ++i) {
            s.append("   ").append(Long.toHexString(l >>> (15 - i) * 4 & 0xFL));
        }
        s.append('\n');
        return s.toString();
    }

    public static final int countFarOpen(long word, int l) {
        int c = 0;
        int e = 0;
        while (l-- != 0) {
            if ((word & 1L << l) != 0L) {
                if (++e <= 0) continue;
                ++c;
                continue;
            }
            if (e > 0) {
                e = -1;
                continue;
            }
            --e;
        }
        return c;
    }

    public static final int findFarOpen(long word, int l, int k) {
        int e = 0;
        while (l-- != 0) {
            if ((word & 1L << l) != 0L) {
                if (++e <= 0 || k-- != 0) continue;
                return l;
            }
            if (e > 0) {
                e = -1;
                continue;
            }
            --e;
        }
        return -1;
    }

    public static final int countFarClose(long word, int l) {
        int c = 0;
        int e = 0;
        for (int i = 0; i < l; ++i) {
            if ((word & 1L << i) != 0L) {
                if (e > 0) {
                    e = -1;
                    continue;
                }
                --e;
                continue;
            }
            if (++e <= 0) continue;
            ++c;
        }
        return c;
    }

    public static final int findFarClose2(long word, int k) {
        int e = 0;
        for (int i = 0; i < 64; ++i) {
            if ((word & 1L << i) != 0L) {
                if (e > 0) {
                    e = -1;
                    continue;
                }
                --e;
                continue;
            }
            if (++e <= 0 || k-- != 0) continue;
            return i;
        }
        return -1;
    }

    public static final int findFarClose(long word, int k) {
        long b1 = (word & 0xAAAAAAAAAAAAAAAAL) >>> 1;
        long b0 = word & 0x5555555555555555L;
        long lsb = (b1 ^ b0) & b1;
        long open2 = (b1 & b0) << 1 | lsb;
        long closed2 = ((b1 | b0) ^ 0x5555555555555555L) << 1 | lsb;
        long open4eccess = open2 & 0x3333333333333333L;
        long closed4eccess = (closed2 & 0xCCCCCCCCCCCCCCCCL) >>> 2;
        long open4 = (open4eccess | 0x8888888888888888L) - closed4eccess ^ 0x8888888888888888L;
        long open4mask = ((open4 & 0x8888888888888888L) >>> 3 | 0x8888888888888888L) - 0x1111111111111111L ^ 0x8888888888888888L;
        long closed4 = (closed4eccess | 0x8888888888888888L) - open4eccess ^ 0x8888888888888888L;
        long closed4mask = ((closed4 & 0x8888888888888888L) >>> 3 | 0x8888888888888888L) - 0x1111111111111111L ^ 0x8888888888888888L;
        open4 = ((open2 & 0xCCCCCCCCCCCCCCCCL) >>> 2) + (open4mask & open4);
        closed4 = (closed2 & 0x3333333333333333L) + (closed4mask & closed4);
        long open8eccess = open4 & 0xF0F0F0F0F0F0F0FL;
        long closed8eccess = (closed4 & 0xF0F0F0F0F0F0F0F0L) >>> 4;
        long open8 = (open8eccess | 0x8080808080808080L) - closed8eccess ^ 0x8080808080808080L;
        long open8mask = ((open8 & 0x8080808080808080L) >>> 7 | 0x8080808080808080L) - 0x101010101010101L ^ 0x8080808080808080L;
        long closed8 = (closed8eccess | 0x8080808080808080L) - open8eccess ^ 0x8080808080808080L;
        long closed8mask = ((closed8 & 0x8080808080808080L) >>> 7 | 0x8080808080808080L) - 0x101010101010101L ^ 0x8080808080808080L;
        open8 = ((open4 & 0xF0F0F0F0F0F0F0F0L) >>> 4) + (open8mask & open8);
        closed8 = (closed4 & 0xF0F0F0F0F0F0F0FL) + (closed8mask & closed8);
        long open16eccess = open8 & 0xFF00FF00FF00FFL;
        long closed16eccess = (closed8 & 0xFF00FF00FF00FF00L) >>> 8;
        long open16 = (open16eccess | 0x8000800080008000L) - closed16eccess ^ 0x8000800080008000L;
        long open16mask = ((open16 & 0x8000800080008000L) >>> 15 | 0x8000800080008000L) - 0x1000100010001L ^ 0x8000800080008000L;
        long closed16 = (closed16eccess | 0x8000800080008000L) - open16eccess ^ 0x8000800080008000L;
        long closed16mask = ((closed16 & 0x8000800080008000L) >>> 15 | 0x8000800080008000L) - 0x1000100010001L ^ 0x8000800080008000L;
        open16 = ((open8 & 0xFF00FF00FF00FF00L) >>> 8) + (open16mask & open16);
        closed16 = (closed8 & 0xFF00FF00FF00FFL) + (closed16mask & closed16);
        long open32eccess = open16 & 0xFFFF0000FFFFL;
        long closed32eccess = (closed16 & 0xFFFF0000FFFF0000L) >>> 16;
        long open32 = (open32eccess | 0x8000000080000000L) - closed32eccess ^ 0x8000000080000000L;
        long open32mask = ((open32 & 0x8000000080000000L) >>> 31 | 0x8000000080000000L) - 0x100000001L ^ 0x8000000080000000L;
        long closed32 = (closed32eccess | 0x8000000080000000L) - open32eccess ^ 0x8000000080000000L;
        long closed32mask = ((closed32 & 0x8000000080000000L) >>> 31 | 0x8000000080000000L) - 0x100000001L ^ 0x8000000080000000L;
        open32 = ((open16 & 0xFFFF0000FFFF0000L) >>> 16) + (open32mask & open32);
        closed32 = (closed16 & 0xFFFF0000FFFFL) + (closed32mask & closed32);
        long check32 = ((long)k - (closed32 & 0xFFFFFFFFL) >>> 63) - 1L;
        long mask = check32 & 0xFFFFFFFFL;
        k = (int)((long)k - (closed32 & mask));
        k = (int)((long)k + (open32 & mask));
        int shift = (int)(0x20L & check32);
        long check16 = ((long)k - (closed16 >>> shift & 0xFFFFL) >>> 63) - 1L;
        mask = check16 & 0xFFFFL;
        k = (int)((long)k - (closed16 >>> shift & mask));
        k = (int)((long)k + (open16 >>> shift & mask));
        shift = (int)((long)shift + (0x10L & check16));
        long check8 = ((long)k - (closed8 >>> shift & 0xFFL) >>> 63) - 1L;
        mask = check8 & 0xFFL;
        k = (int)((long)k - (closed8 >>> shift & mask));
        k = (int)((long)k + (open8 >>> shift & mask));
        shift = (int)((long)shift + (8L & check8));
        long check4 = ((long)k - (closed4 >>> shift & 0xFL) >>> 63) - 1L;
        mask = check4 & 0xFL;
        k = (int)((long)k - (closed4 >>> shift & mask));
        k = (int)((long)k + (open4 >>> shift & mask));
        shift = (int)((long)shift + (4L & check4));
        long check2 = ((long)k - (closed2 >>> shift & 3L) >>> 63) - 1L;
        mask = check2 & 3L;
        k = (int)((long)k - (closed2 >>> shift & mask));
        k = (int)((long)k + (open2 >>> shift & mask));
        shift = (int)((long)shift + (2L & check2));
        return (int)((long)(shift + k) + ((word >>> shift & (long)(k << 1 | 1)) << 1));
    }

    public static final int findNearClose2(long word) {
        int c = 1;
        for (int i = 1; i < 64; ++i) {
            c = (word & 1L << i) != 0L ? ++c : --c;
            if (c != 0) continue;
            return i;
        }
        return 64;
    }

    public static final int findNearClose(long word) {
        long byteSums = word - ((word & 0xAAAAAAAAAAAAAAAAL) >>> 1);
        byteSums = (byteSums & 0x3333333333333333L) + (byteSums >>> 2 & 0x3333333333333333L);
        byteSums = (byteSums + (byteSums >>> 4) & 0xF0F0F0F0F0F0F0FL) * 0x202020202020202L;
        byteSums = -4559700384417279864L - byteSums ^ (0x4038302820181008L ^ (byteSums ^ 0xFFFFFFFFFFFFFFFFL)) & 0x8080808080808080L;
        long update = (((byteSums | (byteSums | 0x8080808080808080L) - 0x101010101010101L) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) >>> 7;
        update = (update | 0x8080808080808080L) - 0x101010101010101L ^ (update ^ 0x101010101010101L | 0x7F7F7F7F7F7F7F7FL);
        long zeroes = 0x8787878787878787L & update;
        byteSums += word >>> 7 & 0x101010101010101L;
        byteSums = (byteSums | 0x8080808080808080L) - ((word >>> 7 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) ^ (byteSums ^ 0x8080808080808080L) & 0x8080808080808080L;
        update = (((byteSums | (byteSums | 0x8080808080808080L) - 0x101010101010101L) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) >>> 7;
        update = (update | 0x8080808080808080L) - 0x101010101010101L ^ (update ^ 0x101010101010101L | 0x7F7F7F7F7F7F7F7FL);
        zeroes = zeroes & (update ^ 0xFFFFFFFFFFFFFFFFL) | 0x8686868686868686L & update;
        byteSums += word >>> 6 & 0x101010101010101L;
        byteSums = (byteSums | 0x8080808080808080L) - ((word >>> 6 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) ^ (byteSums ^ 0x8080808080808080L) & 0x8080808080808080L;
        update = (((byteSums | (byteSums | 0x8080808080808080L) - 0x101010101010101L) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) >>> 7;
        update = (update | 0x8080808080808080L) - 0x101010101010101L ^ (update ^ 0x101010101010101L | 0x7F7F7F7F7F7F7F7FL);
        zeroes = zeroes & (update ^ 0xFFFFFFFFFFFFFFFFL) | 0x8585858585858585L & update;
        byteSums += word >>> 5 & 0x101010101010101L;
        byteSums = (byteSums | 0x8080808080808080L) - ((word >>> 5 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) ^ (byteSums ^ 0x8080808080808080L) & 0x8080808080808080L;
        update = (((byteSums | (byteSums | 0x8080808080808080L) - 0x101010101010101L) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) >>> 7;
        update = (update | 0x8080808080808080L) - 0x101010101010101L ^ (update ^ 0x101010101010101L | 0x7F7F7F7F7F7F7F7FL);
        zeroes = zeroes & (update ^ 0xFFFFFFFFFFFFFFFFL) | 0x8484848484848484L & update;
        byteSums += word >>> 4 & 0x101010101010101L;
        byteSums = (byteSums | 0x8080808080808080L) - ((word >>> 4 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) ^ (byteSums ^ 0x8080808080808080L) & 0x8080808080808080L;
        update = (((byteSums | (byteSums | 0x8080808080808080L) - 0x101010101010101L) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) >>> 7;
        update = (update | 0x8080808080808080L) - 0x101010101010101L ^ (update ^ 0x101010101010101L | 0x7F7F7F7F7F7F7F7FL);
        zeroes = zeroes & (update ^ 0xFFFFFFFFFFFFFFFFL) | 0x8383838383838383L & update;
        byteSums += word >>> 3 & 0x101010101010101L;
        byteSums = (byteSums | 0x8080808080808080L) - ((word >>> 3 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) ^ (byteSums ^ 0x8080808080808080L) & 0x8080808080808080L;
        update = (((byteSums | (byteSums | 0x8080808080808080L) - 0x101010101010101L) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) >>> 7;
        update = (update | 0x8080808080808080L) - 0x101010101010101L ^ (update ^ 0x101010101010101L | 0x7F7F7F7F7F7F7F7FL);
        zeroes = zeroes & (update ^ 0xFFFFFFFFFFFFFFFFL) | 0x8282828282828282L & update;
        byteSums += word >>> 2 & 0x101010101010101L;
        byteSums = (byteSums | 0x8080808080808080L) - ((word >>> 2 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) ^ (byteSums ^ 0x8080808080808080L) & 0x8080808080808080L;
        update = (((byteSums | (byteSums | 0x8080808080808080L) - 0x101010101010101L) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) >>> 7;
        update = (update | 0x8080808080808080L) - 0x101010101010101L ^ (update ^ 0x101010101010101L | 0x7F7F7F7F7F7F7F7FL);
        zeroes = zeroes & (update ^ 0xFFFFFFFFFFFFFFFFL) | 0x8181818181818181L & update;
        byteSums += word >>> 1 & 0x101010101010101L;
        byteSums = (byteSums | 0x8080808080808080L) - ((word >>> 1 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) ^ (byteSums ^ 0x8080808080808080L) & 0x8080808080808080L;
        update = (((byteSums | (byteSums | 0x8080808080808080L) - 0x101010101010101L) ^ 0xFFFFFFFFFFFFFFFFL) & 0x8080808080808080L) >>> 7;
        update = (update | 0x8080808080808080L) - 0x101010101010101L ^ (update ^ 0x101010101010101L | 0x7F7F7F7F7F7F7F7FL);
        zeroes = zeroes & (update ^ 0xFFFFFFFFFFFFFFFFL) | 0x8080808080808080L & update;
        int block = Long.numberOfTrailingZeros(zeroes >>> 7 & 0x101010101010101L);
        return ((int)((long)block + (zeroes >>> block & 0x7FL)) | block >> 8) & 0x7F;
    }

    public static final int findNearCloseAlt(long word) {
        long byteSums = (word << 6) - ((word << 6 & 0xAAAAAAAAAAAAAAAAL) >>> 1);
        byteSums = (byteSums & 0x3333333333333333L) + (byteSums >>> 2 & 0x3333333333333333L);
        byteSums = (byteSums + (byteSums >>> 4) & 0xF0F0F0F0F0F0F0FL) * 0x202020202020202L;
        byteSums = (0x8080808080808080L | byteSums) - 4193460528989997570L ^ 0x8080808080808080L;
        long update = (((byteSums - 0x101010101010101L & 0x8080808080808080L) >>> 7 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) - 0x101010101010101L;
        long zeroes = 0x8181818181818181L & update;
        update = (((((byteSums -= 0x202020202020202L - (((word >>= 2) & 0x202020202020202L) + (word << 1 & 0x202020202020202L))) | zeroes) - 0x101010101010101L ^ byteSums) >>> 7 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) - 0x101010101010101L;
        zeroes |= 0x8383838383838383L & update;
        update = (((((byteSums -= 0x202020202020202L - (((word >>= 2) & 0x202020202020202L) + (word << 1 & 0x202020202020202L))) | zeroes) - 0x101010101010101L ^ byteSums) >>> 7 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) - 0x101010101010101L;
        zeroes |= 0x8585858585858585L & update;
        update = (((((byteSums -= 0x202020202020202L - (((word >>= 2) & 0x202020202020202L) + (word << 1 & 0x202020202020202L))) | zeroes) - 0x101010101010101L ^ byteSums) >>> 7 ^ 0xFFFFFFFFFFFFFFFFL) & 0x101010101010101L) - 0x101010101010101L;
        int block = Long.numberOfTrailingZeros((zeroes |= 0x8787878787878787L & update) >>> 7 & 0x101010101010101L);
        return ((int)((long)block + (zeroes >>> block & 0x3FL)) | block >> 8) & 0x7F;
    }

    public JacobsonBalancedParentheses(BitVector bv) {
        this(bv, true, true, true);
    }

    public JacobsonBalancedParentheses(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public JacobsonBalancedParentheses(BitVector bitVector, boolean findOpen, boolean findClose, boolean enclose) {
        int i;
        int excess;
        int l;
        int block;
        if (!(findOpen || findClose || enclose)) {
            throw new IllegalArgumentException("You must specify at least one implemented method");
        }
        this.bitVector = bitVector;
        this.bits = bitVector.bits();
        long length = bitVector.length();
        int numWords = (int)((length + 64L - 1L) / 64L);
        byte[] count = new byte[numWords];
        byte[] residual = new byte[numWords];
        LongArrayList closingPioneers = null;
        LongArrayList closingPioneerMatches = null;
        LongArrayList openingPioneers = null;
        LongArrayList openingPioneerMatches = null;
        if (findOpen) {
            closingPioneers = new LongArrayList();
            closingPioneerMatches = new LongArrayList();
            for (block = 0; block < numWords; ++block) {
                l = (int)Math.min(64L, length - (long)block * 64L);
                if (block > 0) {
                    excess = 0;
                    int countFarClosing = JacobsonBalancedParentheses.countFarClose(this.bits[block], l);
                    for (int j = 0; j < l; ++j) {
                        if ((this.bits[block] & 1L << j) != 0L) {
                            if (excess > 0) {
                                excess = -1;
                                continue;
                            }
                            --excess;
                            continue;
                        }
                        if (++excess <= 0) continue;
                        int matchingBlock = block;
                        while (count[--matchingBlock] == 0) {
                        }
                        int n = matchingBlock;
                        count[n] = (byte)(count[n] - 1);
                        if (count[n] == 0 || --countFarClosing == 0) {
                            closingPioneers.add((long)(block * 64 + j));
                            closingPioneerMatches.add((long)(block * 64 + j - (matchingBlock * 64 + JacobsonBalancedParentheses.findFarOpen(this.bits[matchingBlock], 64, residual[matchingBlock]))));
                        }
                        int n2 = matchingBlock;
                        residual[n2] = (byte)(residual[n2] + 1);
                    }
                }
                count[block] = (byte)JacobsonBalancedParentheses.countFarOpen(this.bits[block], l);
            }
            i = count.length;
            while (i-- != 0) {
                if (count[i] == 0) continue;
                throw new IllegalArgumentException("Unbalanced parentheses");
            }
        }
        if (findClose) {
            Arrays.fill(residual, (byte)0);
            openingPioneers = new LongArrayList();
            openingPioneerMatches = new LongArrayList();
            block = numWords;
            while (block-- != 0) {
                l = (int)Math.min(64L, length - (long)block * 64L);
                if (block != numWords - 1) {
                    excess = 0;
                    int countFarOpening = JacobsonBalancedParentheses.countFarOpen(this.bits[block], l);
                    boolean somethingAdded = false;
                    int j = l;
                    while (j-- != 0) {
                        if ((this.bits[block] & 1L << j) == 0L) {
                            if (excess > 0) {
                                excess = -1;
                                continue;
                            }
                            --excess;
                            continue;
                        }
                        if (++excess <= 0) continue;
                        int matchingBlock = block;
                        while (count[++matchingBlock] == 0) {
                        }
                        int n = matchingBlock;
                        count[n] = (byte)(count[n] - 1);
                        if (count[n] == 0 || --countFarOpening == 0) {
                            openingPioneers.add((long)block * 64L + (long)j);
                            openingPioneerMatches.add(-((long)block * 64L + (long)j) + ((long)matchingBlock * 64L + (long)JacobsonBalancedParentheses.findFarClose(this.bits[matchingBlock], residual[matchingBlock])));
                        }
                        int n3 = matchingBlock;
                        residual[n3] = (byte)(residual[n3] + 1);
                    }
                }
                count[block] = (byte)JacobsonBalancedParentheses.countFarClose(this.bits[block], l);
            }
            i = count.length;
            while (i-- != 0) {
                if (count[i] == 0) continue;
                throw new IllegalArgumentException("Unbalanced parentheses");
            }
            Collections.reverse(openingPioneers);
            Collections.reverse(openingPioneerMatches);
        }
        this.closingPioneers = closingPioneers != null ? new SparseSelect((LongList)closingPioneers) : null;
        this.closingPioneersRank = closingPioneers != null ? this.closingPioneers.getRank() : null;
        this.closingPioneerMatches = closingPioneers != null ? new EliasFanoLongBigList((LongIterable)closingPioneerMatches) : null;
        this.openingPioneers = openingPioneers != null ? new SparseSelect((LongList)openingPioneers) : null;
        this.openingPioneersRank = openingPioneers != null ? this.openingPioneers.getRank() : null;
        this.openingPioneerMatches = openingPioneers != null ? new EliasFanoLongBigList((LongIterable)openingPioneerMatches) : null;
    }

    @Override
    public long enclose(long pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long findClose(long pos) {
        int word = (int)(pos / 64L);
        int bit = (int)(pos & 0x3FL);
        if ((this.bits[word] & 1L << bit) == 0L) {
            throw new IllegalArgumentException();
        }
        int result = JacobsonBalancedParentheses.findNearClose(this.bits[word] >>> bit);
        if (result < 64 - bit) {
            return (long)word * 64L + (long)bit + (long)result;
        }
        long pioneerIndex = this.openingPioneersRank.rank(pos + 1L) - 1L;
        long pioneer = this.openingPioneers.select(pioneerIndex);
        long match = pioneer + this.openingPioneerMatches.getLong(pioneerIndex);
        if (pos == pioneer) {
            return match;
        }
        int dist = (int)(pos - pioneer);
        int e = 2 * Long.bitCount(this.bits[word] >>> (int)pioneer & (1L << dist) - 1L) - dist;
        int matchWord = (int)(match / 64L);
        int matchBit = (int)(match % 64L);
        int numFarClose = matchBit - 2 * Long.bitCount(this.bits[matchWord] & (1L << matchBit) - 1L);
        return (long)matchWord * 64L + (long)JacobsonBalancedParentheses.findFarClose(this.bits[matchWord], numFarClose - e);
    }

    @Override
    public long findOpen(long pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long numBits() {
        return (this.openingPioneers != null ? this.openingPioneers.numBits() + this.openingPioneersRank.numBits() + this.openingPioneerMatches.numBits() : 0L) + (this.closingPioneers != null ? this.closingPioneers.numBits() + this.closingPioneersRank.numBits() + this.closingPioneerMatches.numBits() : 0L);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.bits = this.bitVector.bits();
    }

    @Override
    public BitVector bitVector() {
        return this.bitVector;
    }
}

