/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.bits.Select;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SimpleSelect
implements Select {
    private static final boolean ASSERTS = true;
    private static final long serialVersionUID = 1L;
    private static final int MAX_ONES_PER_INVENTORY = 8192;
    private static final int MAX_LOG2_LONGWORDS_PER_SUBINVENTORY = 3;
    private static final int MAX_SPAN = 65536;
    private final BitVector bitVector;
    private final long numOnes;
    private final int numWords;
    private transient long[] bits;
    private final long[] inventory;
    private final int log2OnesPerInventory;
    private final int onesPerInventory;
    private final int onesPerInventoryMask;
    private final long[] subinventory;
    private transient LongBigList subinventory16;
    private final int log2LongwordsPerSubinventory;
    private final int log2OnesPerSub64;
    private final int onesPerSub64;
    private final int log2OnesPerSub16;
    private final int onesPerSub16;
    private final int onesPerSub16Mask;
    private final long[] exactSpill;

    public SimpleSelect(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public SimpleSelect(BitVector bitVector) {
        this.bitVector = bitVector;
        this.bits = bitVector.bits();
        long length = bitVector.length();
        this.numWords = (int)((length + 63L) / 64L);
        long d = 0L;
        int i = this.numWords;
        while (i-- != 0) {
            d += (long)Long.bitCount(this.bits[i]);
        }
        this.log2OnesPerInventory = Fast.mostSignificantBit((int)(length == 0L ? 1 : (int)((d * 8192L + length - 1L) / length)));
        this.onesPerInventory = 1 << this.log2OnesPerInventory;
        this.onesPerInventoryMask = this.onesPerInventory - 1;
        int inventorySize = (int)((d + (long)this.onesPerInventory - 1L) / (long)this.onesPerInventory);
        this.inventory = new long[inventorySize + 1];
        d = 0L;
        for (int i2 = 0; i2 < this.numWords; ++i2) {
            for (int j = 0; j < 64 && (long)i2 * 64L + (long)j < length; ++j) {
                if ((this.bits[i2] & 1L << j) == 0L) continue;
                if ((d & (long)this.onesPerInventoryMask) == 0L) {
                    this.inventory[(int)(d >>> this.log2OnesPerInventory)] = (long)i2 * 64L + (long)j;
                }
                ++d;
            }
        }
        this.numOnes = d;
        this.inventory[inventorySize] = length;
        this.log2LongwordsPerSubinventory = Math.min(3, Math.max(0, this.log2OnesPerInventory - 2));
        this.log2OnesPerSub64 = Math.max(0, this.log2OnesPerInventory - this.log2LongwordsPerSubinventory);
        this.log2OnesPerSub16 = Math.max(0, this.log2OnesPerSub64 - 2);
        this.onesPerSub64 = 1 << this.log2OnesPerSub64;
        this.onesPerSub16 = 1 << this.log2OnesPerSub16;
        this.onesPerSub16Mask = this.onesPerSub16 - 1;
        if (this.onesPerInventory > 1) {
            d = 0L;
            long diff16 = 0L;
            long start = 0L;
            long span = 0L;
            int spilled = 0;
            int inventoryIndex = 0;
            for (int i3 = 0; i3 < this.numWords; ++i3) {
                for (int j = 0; j < 64 && (long)i3 * 64L + (long)j < length; ++j) {
                    if ((this.bits[i3] & 1L << j) == 0L) continue;
                    if ((d & (long)this.onesPerInventoryMask) == 0L) {
                        inventoryIndex = (int)(d >>> this.log2OnesPerInventory);
                        start = this.inventory[inventoryIndex];
                        span = this.inventory[inventoryIndex + 1] - start;
                        int ones = (int)Math.min(this.numOnes - d, (long)this.onesPerInventory);
                        diff16 += (long)Math.max(4, ones + this.onesPerSub16 - 1 >>> this.log2OnesPerSub16);
                        if (span >= 65536L && this.onesPerSub64 > 1) {
                            spilled += ones;
                        }
                    }
                    ++d;
                }
            }
            int subinventorySize = (int)((diff16 + 3L) / 4L);
            int exactSpillSize = spilled;
            this.subinventory = new long[subinventorySize];
            this.exactSpill = new long[exactSpillSize];
            this.subinventory16 = LongArrayBitVector.wrap((long[])this.subinventory).asLongBigList(16);
            int offset = 0;
            spilled = 0;
            d = 0L;
            for (int i4 = 0; i4 < this.numWords; ++i4) {
                for (int j = 0; j < 64 && (long)i4 * 64L + (long)j < length; ++j) {
                    if ((this.bits[i4] & 1L << j) == 0L) continue;
                    if ((d & (long)this.onesPerInventoryMask) == 0L) {
                        inventoryIndex = (int)(d >>> this.log2OnesPerInventory);
                        start = this.inventory[inventoryIndex];
                        span = this.inventory[inventoryIndex + 1] - start;
                        offset = 0;
                    }
                    if (span < 65536L) {
                        assert ((long)i4 * 64L + (long)j - start <= 65536L);
                        if ((d & (long)this.onesPerSub16Mask) == 0L) {
                            this.subinventory16.set((long)((inventoryIndex << this.log2LongwordsPerSubinventory + 2) + offset++), (long)i4 * 64L + (long)j - start);
                        }
                    } else if (this.onesPerSub64 == 1) {
                        this.subinventory[(inventoryIndex << this.log2LongwordsPerSubinventory) + offset++] = (long)i4 * 64L + (long)j;
                    } else {
                        if ((d & (long)this.onesPerInventoryMask) == 0L) {
                            int n = inventoryIndex;
                            this.inventory[n] = this.inventory[n] | Long.MIN_VALUE;
                            this.subinventory[inventoryIndex << this.log2LongwordsPerSubinventory] = spilled;
                        }
                        this.exactSpill[spilled++] = (long)i4 * 64L + (long)j;
                    }
                    ++d;
                }
            }
        } else {
            this.exactSpill = LongArrays.EMPTY_ARRAY;
            this.subinventory = LongArrays.EMPTY_ARRAY;
            this.subinventory16 = null;
        }
    }

    @Override
    public long select(long rank) {
        int bitCount;
        int residual;
        if (rank >= this.numOnes) {
            return -1L;
        }
        int inventoryIndex = (int)(rank >>> this.log2OnesPerInventory);
        long inventoryRank = this.inventory[inventoryIndex];
        int subrank = (int)(rank & (long)this.onesPerInventoryMask);
        if (subrank == 0) {
            return inventoryRank & Long.MAX_VALUE;
        }
        if (inventoryRank < 0L) {
            if (this.onesPerSub64 == 1) {
                return this.subinventory[(inventoryIndex << this.log2LongwordsPerSubinventory) + subrank];
            }
            return this.exactSpill[(int)(this.subinventory[inventoryIndex << this.log2LongwordsPerSubinventory] + (long)subrank)];
        }
        long start = inventoryRank + this.subinventory16.getLong((long)((inventoryIndex << this.log2LongwordsPerSubinventory + 2) + (subrank >>> this.log2OnesPerSub16)));
        if (residual == 0) {
            return start;
        }
        long[] bits = this.bits;
        int wordIndex = (int)(start / 64L);
        long word = bits[wordIndex] & -1L << (int)start;
        for (residual = subrank & this.onesPerSub16Mask; residual >= (bitCount = Long.bitCount(word)); residual -= bitCount) {
            word = bits[++wordIndex];
        }
        return (long)wordIndex * 64L + (long)Fast.select((long)word, (int)residual);
    }

    public long[] select(long rank, long[] dest, int offset, int length) {
        long s;
        if (length == 0) {
            return dest;
        }
        dest[offset] = s = this.select(rank);
        int curr = (int)(s / 64L);
        long window = this.bits[curr] & -1L << (int)s;
        window &= window - 1L;
        for (int i = 1; i < length; ++i) {
            while (window == 0L) {
                window = this.bits[++curr];
            }
            dest[offset + i] = curr * 64 + Long.numberOfTrailingZeros(window);
            window &= window - 1L;
        }
        return dest;
    }

    public long[] select(long rank, long[] dest) {
        return this.select(rank, dest, 0, dest.length);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.subinventory16 = LongArrayBitVector.wrap((long[])this.subinventory).asLongBigList(16);
        this.bits = this.bitVector.bits();
    }

    @Override
    public long numBits() {
        return (long)this.inventory.length * 64L + (long)this.subinventory.length * 64L + (long)this.exactSpill.length * 64L;
    }

    @Override
    public BitVector bitVector() {
        return this.bitVector;
    }
}

