/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.sux4j.bits.AbstractRank;
import it.unimi.dsi.sux4j.bits.SimpleSelect;
import it.unimi.dsi.sux4j.bits.SimpleSelectZero;
import it.unimi.dsi.sux4j.bits.SparseSelect;

public class SparseRank
extends AbstractRank {
    private static final long serialVersionUID = 2L;
    protected final long n;
    protected final long m;
    protected final int l;
    protected final long lowerLBitsMask;
    protected final long[] lowerBits;
    protected final BitVector upperBits;
    protected final SimpleSelectZero selectZeroUpper;
    protected final boolean fromSelect;

    public SparseRank(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public SparseRank(BitVector bitVector) {
        this(bitVector.length(), bitVector.count(), (LongIterator)bitVector.asLongSet().iterator());
    }

    public SparseRank(long n, long m, LongIterator iterator) {
        long pos = -1L;
        this.n = n;
        this.m = m;
        this.l = m == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(n / m)));
        this.lowerLBitsMask = (1L << this.l) - 1L;
        LongArrayBitVector lowerBitsVector = LongArrayBitVector.getInstance();
        LongBigList lowerBitsList = lowerBitsVector.asLongBigList(this.l);
        lowerBitsList.size(m);
        this.upperBits = LongArrayBitVector.getInstance().length(m + (n >>> this.l) + 1L);
        long last = 0L;
        for (long i = 0L; i < m; ++i) {
            pos = iterator.nextLong();
            if (pos >= n) {
                throw new IllegalArgumentException("Too large bit poisition: " + pos + " >= " + n);
            }
            if (pos < last) {
                throw new IllegalArgumentException("Positions are not nondecreasing: " + pos + " < " + last);
            }
            if (this.l != 0) {
                lowerBitsList.set(i, pos & this.lowerLBitsMask);
            }
            this.upperBits.set((pos >> this.l) + i);
            last = pos;
        }
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("There are more than " + m + " positions in the provided iterator");
        }
        this.lowerBits = lowerBitsVector.bits();
        this.selectZeroUpper = new SimpleSelectZero(this.upperBits);
        this.fromSelect = false;
    }

    protected SparseRank(long n, long m, int l, long[] lowerBits, BitVector upperBits) {
        this.n = n;
        this.m = m;
        this.l = l;
        this.lowerLBitsMask = (1L << l) - 1L;
        this.lowerBits = lowerBits;
        this.upperBits = upperBits;
        this.selectZeroUpper = new SimpleSelectZero(upperBits);
        this.fromSelect = true;
    }

    private final long extractLowerBits(long index) {
        int l = this.l;
        if (l == 0) {
            return 0L;
        }
        long position = index * (long)l;
        int startWord = (int)(position / 64L);
        int startBit = (int)(position % 64L);
        int totalOffset = startBit + l;
        long result = this.lowerBits[startWord] >>> startBit;
        return (totalOffset <= 64 ? result : result | this.lowerBits[startWord + 1] << -startBit) & this.lowerLBitsMask;
    }

    @Override
    public long rank(long pos) {
        if (this.m == 0L) {
            return 0L;
        }
        if (pos >= this.n) {
            return this.m;
        }
        long posShiftrL = pos >>> this.l;
        long upperPos = this.selectZeroUpper.selectZero(posShiftrL);
        long rank = upperPos - posShiftrL;
        long posLowerBits = pos & this.lowerLBitsMask;
        while (--upperPos >= 0L && this.upperBits.getBoolean(upperPos) && this.extractLowerBits(--rank) >= posLowerBits) {
        }
        return ++rank;
    }

    @Override
    public long numBits() {
        return this.selectZeroUpper.numBits() + (this.fromSelect ? 0L : this.upperBits.length() + (long)this.lowerBits.length * 64L);
    }

    public SparseSelect getSelect() {
        return new SparseSelect(this.n, this.m, this.l, this.lowerBits, new SimpleSelect(this.upperBits));
    }

    @Override
    public BitVector bitVector() {
        LongArrayBitVector result = LongArrayBitVector.getInstance().length(this.n);
        long prev = 0L;
        for (long i = 1L; i <= this.n; ++i) {
            long rank = this.rank(i);
            if (rank != prev) {
                result.set(i - 1L);
            }
            prev = rank;
        }
        return result;
    }
}

