/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.io.FileLinesByteArrayCollection;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.bits.Rank16;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.solve.Linear3SystemSolver;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import it.unimi.dsi.util.concurrent.ReorderingBlockingQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GOV3Function<T>
extends AbstractObject2LongFunction<T>
implements Serializable,
Size64 {
    private static final long serialVersionUID = 1L;
    private static final LongArrayBitVector END_OF_SOLUTION_QUEUE = LongArrayBitVector.getInstance();
    private static final ChunkedHashStore.Chunk END_OF_CHUNK_QUEUE = new ChunkedHashStore.Chunk();
    private static final Logger LOGGER = LoggerFactory.getLogger(GOV3Function.class);
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    private static final long SEED_STEP = 0x100000000000000L;
    private static final long OFFSET_MASK = 0xFFFFFFFFFFFFFFL;
    public static double C = 1.1;
    private static long C_TIMES_256 = (long)Math.floor(C * 256.0);
    public static final String NUMBER_OF_THREADS_PROPERTY = "it.unimi.dsi.sux4j.mph.threads";
    public static final int LOG2_CHUNK_SIZE = 10;
    private final int chunkShift;
    protected final long n;
    protected final long m;
    protected final int width;
    protected final long globalSeed;
    protected final long[] offsetAndSeed;
    protected final LongBigList data;
    protected final LongArrayBitVector marker;
    protected final Rank16 rank;
    protected final TransformationStrategy<? super T> transform;
    protected final long signatureMask;
    protected final LongBigList signatures;

    protected GOV3Function(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, int signatureWidth, LongIterable values, int dataWidth, boolean indirect, boolean compacted, File tempDir, ChunkedHashStore<T> chunkedHashStore) throws IOException {
        OfflineIterable.OfflineIterator iterator;
        boolean givenChunkedHashStore;
        this.transform = transform;
        if (signatureWidth != 0 && values != null) {
            throw new IllegalArgumentException("You cannot sign a function if you specify its values");
        }
        if (signatureWidth != 0 && dataWidth != -1) {
            throw new IllegalArgumentException("You cannot specify a signature width and a data width");
        }
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        pl.itemsName = "keys";
        boolean bl = givenChunkedHashStore = chunkedHashStore != null;
        if (chunkedHashStore == null) {
            if (keys == null) {
                throw new IllegalArgumentException("If you do not provide a chunked hash store, you must provide the keys");
            }
            chunkedHashStore = new ChunkedHashStore<T>(transform, tempDir, -Math.min(signatureWidth, 0), pl);
            chunkedHashStore.reset(r.nextLong());
            if (values == null || indirect) {
                chunkedHashStore.addAll(keys.iterator());
            } else {
                chunkedHashStore.addAll(keys.iterator(), values.iterator());
            }
        }
        this.n = chunkedHashStore.size();
        long l = this.defRetValue = signatureWidth < 0 ? 0L : -1L;
        if (this.n == 0L) {
            this.width = 0;
            this.chunkShift = 0;
            this.m = this.globalSeed = (long)0;
            this.data = null;
            this.marker = null;
            this.rank = null;
            this.offsetAndSeed = null;
            this.signatureMask = 0L;
            this.signatures = null;
            if (!givenChunkedHashStore) {
                chunkedHashStore.close();
            }
            return;
        }
        int log2NumChunks = Math.max(0, Fast.mostSignificantBit((long)(this.n >> 10)));
        this.chunkShift = chunkedHashStore.log2Chunks(log2NumChunks);
        int numChunks = 1 << log2NumChunks;
        LOGGER.debug("Number of chunks: " + numChunks);
        this.offsetAndSeed = new long[numChunks + 1];
        this.width = signatureWidth < 0 ? -signatureWidth : (dataWidth == -1 ? Fast.ceilLog2((long)this.n) : dataWidth);
        OfflineIterable offlineData = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
        int duplicates = 0;
        while (true) {
            LOGGER.debug("Generating GOV function with " + this.width + " output bits...");
            pl.expectedUpdates = numChunks;
            pl.itemsName = "chunks";
            pl.start((CharSequence)"Analysing chunks... ");
            AtomicLong unsolvable = new AtomicLong();
            try {
                int numberOfThreads = Integer.parseInt(System.getProperty(NUMBER_OF_THREADS_PROPERTY, Integer.toString(Math.min(16, Runtime.getRuntime().availableProcessors()))));
                ArrayBlockingQueue chunkQueue = new ArrayBlockingQueue(numberOfThreads * 8);
                ReorderingBlockingQueue queue = new ReorderingBlockingQueue(numberOfThreads * 128);
                ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads + 2);
                ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
                executorCompletionService.submit(() -> {
                    LongArrayBitVector data;
                    while ((data = (LongArrayBitVector)queue.take()) != END_OF_SOLUTION_QUEUE) {
                        offlineData.add((Object)data);
                    }
                    return null;
                });
                ChunkedHashStore<Object> chs = chunkedHashStore;
                executorCompletionService.submit(() -> {
                    try {
                        Iterator<ChunkedHashStore.Chunk> iterator = chs.iterator();
                        int i1 = 0;
                        while (iterator.hasNext()) {
                            ChunkedHashStore.Chunk chunk = new ChunkedHashStore.Chunk(iterator.next());
                            assert (i1 == chunk.index());
                            long chunkDataSize = C_TIMES_256 * (long)chunk.size() >>> 8;
                            assert (chunkDataSize <= Integer.MAX_VALUE);
                            long[] lArray = this.offsetAndSeed;
                            // MONITORENTER : this.offsetAndSeed
                            this.offsetAndSeed[i1 + 1] = this.offsetAndSeed[i1] + chunkDataSize;
                            assert (this.offsetAndSeed[i1 + 1] <= 0x100000000000000L);
                            // MONITOREXIT : lArray
                            chunkQueue.put(chunk);
                            ++i1;
                        }
                        return null;
                    }
                    finally {
                        int i2 = numberOfThreads;
                        while (true) {
                            if (i2-- == 0) {
                            }
                            chunkQueue.put(END_OF_CHUNK_QUEUE);
                        }
                    }
                });
                AtomicInteger activeThreads = new AtomicInteger(numberOfThreads);
                int i = numberOfThreads;
                while (i-- != 0) {
                    executorCompletionService.submit(() -> {
                        Thread.currentThread().setPriority(1);
                        long chunkTime = 0L;
                        long outputTime = 0L;
                        while (true) {
                            int n;
                            long[] lArray;
                            LongBigList data;
                            LongArrayBitVector dataBitVector;
                            ChunkedHashStore.Chunk chunk;
                            long start;
                            block9: {
                                start = System.nanoTime();
                                chunk = (ChunkedHashStore.Chunk)chunkQueue.take();
                                chunkTime += System.nanoTime() - start;
                                if (chunk == END_OF_CHUNK_QUEUE) {
                                    if (activeThreads.decrementAndGet() == 0) {
                                        queue.put((Object)END_OF_SOLUTION_QUEUE, (long)numChunks);
                                    }
                                    LOGGER.debug("Queue waiting time: " + Util.format((double)((double)chunkTime / 1.0E9)) + "s");
                                    LOGGER.debug("Output waiting time: " + Util.format((double)((double)outputTime / 1.0E9)) + "s");
                                    return null;
                                }
                                long seed = 0L;
                                Linear3SystemSolver solver = new Linear3SystemSolver((int)(this.offsetAndSeed[chunk.index() + 1] - this.offsetAndSeed[chunk.index()] & 0xFFFFFFFFFFFFFFL), chunk.size());
                                do {
                                    boolean solved22 = solver.generateAndSolve(chunk, seed, chunk.valueList((LongIterable)(indirect ? values : null)));
                                    unsolvable.addAndGet(solver.unsolvable);
                                    if (!solved22) continue;
                                    long[] solved22 = this.offsetAndSeed;
                                    // MONITORENTER : this.offsetAndSeed
                                    int n2 = chunk.index();
                                    this.offsetAndSeed[n2] = this.offsetAndSeed[n2] | seed;
                                    // MONITOREXIT : solved22
                                    dataBitVector = LongArrayBitVector.getInstance();
                                    data = dataBitVector.asLongBigList(this.width);
                                    lArray = solver.solution;
                                    n = lArray.length;
                                    break block9;
                                } while ((seed += 0x100000000000000L) != 0L);
                                throw new AssertionError((Object)"Exhausted local seeds");
                            }
                            for (int i = 0; i < n; ++i) {
                                long l = lArray[i];
                                data.add(l);
                            }
                            start = System.nanoTime();
                            queue.put((Object)dataBitVector, (long)chunk.index());
                            outputTime += System.nanoTime() - start;
                            ProgressLogger progressLogger = pl;
                            // MONITORENTER : progressLogger
                            pl.update();
                            // MONITOREXIT : progressLogger
                        }
                    });
                }
                try {
                    i = numberOfThreads + 2;
                    while (i-- != 0) {
                        executorCompletionService.take().get();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ChunkedHashStore.DuplicateException) {
                        throw (ChunkedHashStore.DuplicateException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                finally {
                    executorService.shutdown();
                }
                LOGGER.info("Unsolvable systems: " + unsolvable.get() + "/" + (unsolvable.get() + (long)numChunks) + " (" + Util.format((double)(100.0 * (double)unsolvable.get() / (double)(unsolvable.get() + (long)numChunks))) + "%)");
                pl.done();
            }
            catch (ChunkedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the chunked hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing triples...");
                chunkedHashStore.reset(r.nextLong());
                pl.itemsName = "keys";
                if (values == null || indirect) {
                    chunkedHashStore.addAll(keys.iterator());
                    continue;
                }
                chunkedHashStore.addAll(keys.iterator(), values.iterator());
                continue;
            }
            break;
        }
        this.globalSeed = chunkedHashStore.seed();
        long nonZero = 0L;
        this.m = this.offsetAndSeed[this.offsetAndSeed.length - 1];
        if (compacted) {
            LOGGER.info("Compacting...");
            iterator = offlineData.iterator();
            while (iterator.hasNext()) {
                LongBigList data = ((LongArrayBitVector)iterator.next()).asLongBigList(this.width);
                for (long i = 0L; i < data.size64(); ++i) {
                    if (data.getLong(i) == 0L) continue;
                    ++nonZero;
                }
            }
            iterator.close();
            this.marker = LongArrayBitVector.ofLength((long)this.m);
            LongBigList newData = LongArrayBitVector.getInstance().asLongBigList(this.width);
            newData.size(nonZero);
            nonZero = 0L;
            long j = 0L;
            iterator = offlineData.iterator();
            while (iterator.hasNext()) {
                LongBigList data = ((LongArrayBitVector)iterator.next()).asLongBigList(this.width);
                long i = 0L;
                while (i < data.size64()) {
                    long value = data.getLong(i);
                    if (value != 0L) {
                        this.marker.set(j);
                        newData.set(nonZero++, value);
                    }
                    ++i;
                    ++j;
                }
            }
            iterator.close();
            this.rank = new Rank16((BitVector)this.marker);
            this.data = newData;
        } else {
            LongArrayBitVector dataBitVector = LongArrayBitVector.getInstance((long)(this.m * (long)this.width));
            this.data = dataBitVector.asLongBigList(this.width);
            iterator = offlineData.iterator();
            while (iterator.hasNext()) {
                dataBitVector.append((BitVector)iterator.next());
            }
            iterator.close();
            this.marker = null;
            this.rank = null;
        }
        offlineData.close();
        LOGGER.info("Completed.");
        LOGGER.debug("Forecast bit cost per element: " + (this.marker == null ? C * (double)this.width : C + (double)this.width + 0.126));
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth > 0) {
            this.signatureMask = -1L >>> 64 - signatureWidth;
            this.signatures = chunkedHashStore.signatures(signatureWidth, pl);
        } else if (signatureWidth < 0) {
            this.signatureMask = -1L >>> 64 + signatureWidth;
            this.signatures = null;
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        if (!givenChunkedHashStore) {
            chunkedHashStore.close();
        }
    }

    public long getLong(Object o) {
        long result;
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[3];
        long[] h = new long[3];
        Hashes.spooky4(this.transform.toBitVector(o), this.globalSeed, h);
        int chunk = this.chunkShift == 64 ? 0 : (int)(h[0] >>> this.chunkShift);
        long chunkOffset = this.offsetAndSeed[chunk] & 0xFFFFFFFFFFFFFFL;
        Linear3SystemSolver.tripleToEquation(h, this.offsetAndSeed[chunk] & 0xFF00000000000000L, (int)((this.offsetAndSeed[chunk + 1] & 0xFFFFFFFFFFFFFFL) - chunkOffset), e);
        if (e[0] == -1) {
            return this.defRetValue;
        }
        long e0 = (long)e[0] + chunkOffset;
        long e1 = (long)e[1] + chunkOffset;
        long e2 = (long)e[2] + chunkOffset;
        long l = this.rank == null ? this.data.getLong(e0) ^ this.data.getLong(e1) ^ this.data.getLong(e2) : (result = (this.marker.getBoolean(e0) ? this.data.getLong(this.rank.rank(e0)) : 0L) ^ (this.marker.getBoolean(e1) ? this.data.getLong(this.rank.rank(e1)) : 0L) ^ (this.marker.getBoolean(e2) ? this.data.getLong(this.rank.rank(e2)) : 0L));
        if (this.signatureMask == 0L) {
            return result;
        }
        if (this.signatures != null) {
            return result >= this.n || ((this.signatures.getLong(result) ^ h[0]) & this.signatureMask) != 0L ? this.defRetValue : result;
        }
        return ((result ^ h[0]) & this.signatureMask) != 0L ? this.defRetValue : 1L;
    }

    public long getLongByTriple(long[] triple) {
        long result;
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[3];
        int chunk = this.chunkShift == 64 ? 0 : (int)(triple[0] >>> this.chunkShift);
        long chunkOffset = this.offsetAndSeed[chunk] & 0xFFFFFFFFFFFFFFL;
        Linear3SystemSolver.tripleToEquation(triple, this.offsetAndSeed[chunk] & 0xFF00000000000000L, (int)((this.offsetAndSeed[chunk + 1] & 0xFFFFFFFFFFFFFFL) - chunkOffset), e);
        long e0 = (long)e[0] + chunkOffset;
        long e1 = (long)e[1] + chunkOffset;
        long e2 = (long)e[2] + chunkOffset;
        if (e0 == -1L) {
            return this.defRetValue;
        }
        long l = this.rank == null ? this.data.getLong(e0) ^ this.data.getLong(e1) ^ this.data.getLong(e2) : (result = (this.marker.getBoolean(e0) ? this.data.getLong(this.rank.rank(e0)) : 0L) ^ (this.marker.getBoolean(e1) ? this.data.getLong(this.rank.rank(e1)) : 0L) ^ (this.marker.getBoolean(e2) ? this.data.getLong(this.rank.rank(e2)) : 0L));
        if (this.signatureMask == 0L) {
            return result;
        }
        if (this.signatures != null) {
            return result >= this.n || this.signatures.getLong(result) != (triple[0] & this.signatureMask) ? this.defRetValue : result;
        }
        return ((result ^ triple[0]) & this.signatureMask) != 0L ? this.defRetValue : 1L;
    }

    public long size64() {
        return this.n;
    }

    @Deprecated
    public int size() {
        return this.n > Integer.MAX_VALUE ? -1 : (int)this.n;
    }

    public long numBits() {
        if (this.n == 0L) {
            return 0L;
        }
        return (this.marker != null ? this.rank.numBits() + this.marker.length() : 0L) + (this.data != null ? this.data.size64() : 0L) * (long)this.width + (long)this.offsetAndSeed.length * 64L;
    }

    public boolean containsKey(Object o) {
        return true;
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(GOV3Function.class.getName(), "Builds a GOV function mapping a newline-separated list of strings to their ordinal position, or to specific values.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits; if negative, the generated function will be a dictionary."), new Switch("compacted", 'c', "compacted", "Whether the resulting function should be compacted."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("values", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'v', "values", "A binary file in DataInput format containing a long for each string (otherwise, the values will be the ordinal positions of the strings)."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised GOV function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean compacted = jsapResult.getBoolean("compacted");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            FileLinesByteArrayCollection collection = new FileLinesByteArrayCollection((CharSequence)stringFile, zipped);
            BinIO.storeObject(new GOV3Function(collection, TransformationStrategies.rawByteArray(), signatureWidth, null, -1, false, compacted, tempDir, null), (CharSequence)functionName);
        } else {
            TransformationStrategy transformationStrategy;
            Object collection;
            if ("-".equals(stringFile)) {
                ProgressLogger pl = new ProgressLogger(LOGGER);
                pl.displayLocalSpeed = true;
                pl.displayFreeMemory = true;
                pl.start((CharSequence)"Loading strings...");
                collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
                pl.done();
            } else {
                collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
            }
            TransformationStrategy transformationStrategy2 = iso ? TransformationStrategies.rawIso() : (transformationStrategy = utf32 ? TransformationStrategies.rawUtf32() : TransformationStrategies.rawUtf16());
            if (jsapResult.userSpecified("values")) {
                String values = jsapResult.getString("values");
                int dataWidth = 0;
                LongIterator i = BinIO.asLongIterator((CharSequence)values);
                while (i.hasNext()) {
                    dataWidth = Math.max(dataWidth, Fast.length((long)i.nextLong()));
                }
                BinIO.storeObject(new GOV3Function(collection, transformationStrategy, signatureWidth, BinIO.asLongIterable((CharSequence)values), dataWidth, false, compacted, tempDir, null), (CharSequence)functionName);
            } else {
                BinIO.storeObject(new GOV3Function(collection, transformationStrategy, signatureWidth, null, -1, false, compacted, tempDir, null), (CharSequence)functionName);
            }
        }
        LOGGER.info("Completed.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected int signatureWidth;
        protected File tempDir;
        protected ChunkedHashStore<T> chunkedHashStore;
        protected LongIterable values;
        protected int outputWidth = -1;
        protected boolean indirect;
        protected boolean compacted;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> dictionary(int signatureWidth) {
            this.signatureWidth = -signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(ChunkedHashStore<T> chunkedHashStore) {
            this.chunkedHashStore = chunkedHashStore;
            return this;
        }

        public Builder<T> store(ChunkedHashStore<T> chunkedHashStore, int outputWidth) {
            this.chunkedHashStore = chunkedHashStore;
            this.outputWidth = outputWidth;
            return this;
        }

        public Builder<T> values(LongIterable values, int outputWidth) {
            this.values = values;
            this.outputWidth = outputWidth;
            return this;
        }

        public Builder<T> values(LongIterable values) {
            this.values = values;
            int outputWidth = 0;
            LongIterator i = values.iterator();
            while (i.hasNext()) {
                outputWidth = Math.max(outputWidth, Fast.length((long)i.nextLong()));
            }
            this.outputWidth = outputWidth;
            return this;
        }

        public Builder<T> indirect() {
            this.indirect = true;
            return this;
        }

        public Builder<T> compacted() {
            this.compacted = true;
            return this;
        }

        public GOV3Function<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            if (this.transform == null) {
                if (this.chunkedHashStore != null) {
                    this.transform = this.chunkedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given ChunkedHashStore");
                }
            }
            return new GOV3Function<T>(this.keys, this.transform, this.signatureWidth, this.values, this.outputWidth, this.indirect, this.compacted, this.tempDir, this.chunkedHashStore);
        }
    }
}

