/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.io.FileLinesByteArrayCollection;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.solve.Linear3SystemSolver;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import it.unimi.dsi.util.concurrent.ReorderingBlockingQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GOVMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Serializable {
    public static final long serialVersionUID = 6L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GOVMinimalPerfectHashFunction.class);
    private static final LongArrayBitVector END_OF_SOLUTION_QUEUE = LongArrayBitVector.getInstance();
    private static final ChunkedHashStore.Chunk END_OF_CHUNK_QUEUE = new ChunkedHashStore.Chunk();
    private static final long SEED_STEP = 0x100000000000000L;
    private static final long OFFSET_MASK = 0xFFFFFFFFFFFFFFL;
    private static double C = 1.1;
    private static int C_TIMES_256 = (int)Math.floor(C * 256.0);
    public static final String NUMBER_OF_THREADS_PROPERTY = "it.unimi.dsi.sux4j.mph.threads";
    public static final int LOG2_CHUNK_SIZE = 10;
    protected final long n;
    private final int chunkShift;
    protected final long globalSeed;
    protected final long[] edgeOffsetAndSeed;
    protected final LongBigList values;
    protected final LongArrayBitVector bitVector;
    protected transient long[] array;
    protected final TransformationStrategy<? super T> transform;
    protected final long signatureMask;
    protected final LongBigList signatures;

    public static final int countNonzeroPairs(long x) {
        return Long.bitCount((x | x >>> 1) & 0x5555555555555555L);
    }

    private static final long countNonzeroPairs(long start, long end, long[] array) {
        int block = (int)(start / 32L);
        int endBlock = (int)(end / 32L);
        int startOffset = (int)(start % 32L);
        int endOffset = (int)(end % 32L);
        if (block == endBlock) {
            return GOVMinimalPerfectHashFunction.countNonzeroPairs((array[block] & (1L << endOffset * 2) - 1L) >>> startOffset * 2);
        }
        long pairs = 0L;
        if (startOffset != 0) {
            pairs += (long)GOVMinimalPerfectHashFunction.countNonzeroPairs(array[block++] >>> startOffset * 2);
        }
        while (block < endBlock) {
            pairs += (long)GOVMinimalPerfectHashFunction.countNonzeroPairs(array[block++]);
        }
        if (endOffset != 0) {
            pairs += (long)GOVMinimalPerfectHashFunction.countNonzeroPairs(array[block] & (1L << endOffset * 2) - 1L);
        }
        return pairs;
    }

    protected static long vertexOffset(long edgeOffsetSeed) {
        return (edgeOffsetSeed & 0xFFFFFFFFFFFFFFL) * (long)C_TIMES_256 >> 8;
    }

    protected GOVMinimalPerfectHashFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, int signatureWidth, File tempDir, ChunkedHashStore<T> chunkedHashStore) throws IOException {
        boolean givenChunkedHashStore;
        this.transform = transform;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        pl.itemsName = "keys";
        boolean bl = givenChunkedHashStore = chunkedHashStore != null;
        if (chunkedHashStore == null) {
            chunkedHashStore = new ChunkedHashStore<T>(transform, tempDir, pl);
            chunkedHashStore.reset(r.nextLong());
            chunkedHashStore.addAll(keys.iterator());
        }
        this.n = chunkedHashStore.size();
        this.defRetValue = -1L;
        int log2NumChunks = Math.max(0, Fast.mostSignificantBit((long)(this.n >> 10)));
        this.chunkShift = chunkedHashStore.log2Chunks(log2NumChunks);
        int numChunks = 1 << log2NumChunks;
        LOGGER.debug("Number of chunks: " + numChunks);
        this.edgeOffsetAndSeed = new long[numChunks + 1];
        this.bitVector = LongArrayBitVector.getInstance((long)(2L * (this.n * (long)C_TIMES_256 >> 8)));
        int duplicates = 0;
        while (true) {
            LOGGER.debug("Generating minimal perfect hash function...");
            pl.expectedUpdates = numChunks;
            pl.itemsName = "chunks";
            pl.start((CharSequence)"Analysing chunks... ");
            AtomicLong unsolvable = new AtomicLong();
            AtomicLong unorientable = new AtomicLong();
            try {
                int numberOfThreads = Integer.parseInt(System.getProperty(NUMBER_OF_THREADS_PROPERTY, Integer.toString(Math.min(16, Runtime.getRuntime().availableProcessors()))));
                ArrayBlockingQueue chunkQueue = new ArrayBlockingQueue(numberOfThreads * 8);
                ReorderingBlockingQueue queue = new ReorderingBlockingQueue(numberOfThreads * 128);
                ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads + 2);
                ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
                executorCompletionService.submit(() -> {
                    LongArrayBitVector data;
                    while ((data = (LongArrayBitVector)queue.take()) != END_OF_SOLUTION_QUEUE) {
                        this.bitVector.append((BitVector)data);
                    }
                    return null;
                });
                ChunkedHashStore<Object> chs = chunkedHashStore;
                executorCompletionService.submit(() -> {
                    try {
                        Iterator<ChunkedHashStore.Chunk> iterator = chs.iterator();
                        int i1 = 0;
                        while (iterator.hasNext()) {
                            ChunkedHashStore.Chunk chunk = new ChunkedHashStore.Chunk(iterator.next());
                            assert (i1 == chunk.index());
                            long[] lArray = this.edgeOffsetAndSeed;
                            // MONITORENTER : this.edgeOffsetAndSeed
                            this.edgeOffsetAndSeed[i1 + 1] = this.edgeOffsetAndSeed[i1] + (long)chunk.size();
                            assert (this.edgeOffsetAndSeed[i1 + 1] <= 0x100000000000000L);
                            // MONITOREXIT : lArray
                            chunkQueue.put(chunk);
                            ++i1;
                        }
                        return null;
                    }
                    finally {
                        int i2 = numberOfThreads;
                        while (true) {
                            if (i2-- == 0) {
                            }
                            chunkQueue.put(END_OF_CHUNK_QUEUE);
                        }
                    }
                });
                AtomicInteger activeThreads = new AtomicInteger(numberOfThreads);
                int i = numberOfThreads;
                while (i-- != 0) {
                    executorCompletionService.submit(() -> {
                        Thread.currentThread().setPriority(1);
                        long chunkTime = 0L;
                        long outputTime = 0L;
                        while (true) {
                            LongBigList dataList;
                            LongArrayBitVector dataBitVector;
                            long[] solution;
                            ChunkedHashStore.Chunk chunk;
                            block9: {
                                long start = System.nanoTime();
                                chunk = (ChunkedHashStore.Chunk)chunkQueue.take();
                                chunkTime += System.nanoTime() - start;
                                if (chunk == END_OF_CHUNK_QUEUE) {
                                    if (activeThreads.decrementAndGet() == 0) {
                                        queue.put((Object)END_OF_SOLUTION_QUEUE, (long)numChunks);
                                    }
                                    LOGGER.debug("Queue waiting time: " + Util.format((double)((double)chunkTime / 1.0E9)) + "s");
                                    LOGGER.debug("Output waiting time: " + Util.format((double)0.0) + "s");
                                    return null;
                                }
                                long seed = 0L;
                                long off = GOVMinimalPerfectHashFunction.vertexOffset(this.edgeOffsetAndSeed[chunk.index()]);
                                Linear3SystemSolver solver = new Linear3SystemSolver((int)(GOVMinimalPerfectHashFunction.vertexOffset(this.edgeOffsetAndSeed[chunk.index() + 1]) - off), chunk.size());
                                do {
                                    boolean solved22 = solver.generateAndSolve(chunk, seed, null);
                                    unorientable.addAndGet(solver.unorientable);
                                    unsolvable.addAndGet(solver.unsolvable);
                                    if (!solved22) continue;
                                    long[] solved22 = this.edgeOffsetAndSeed;
                                    // MONITORENTER : this.edgeOffsetAndSeed
                                    int n = chunk.index();
                                    this.edgeOffsetAndSeed[n] = this.edgeOffsetAndSeed[n] | seed;
                                    // MONITOREXIT : solved22
                                    solution = solver.solution;
                                    dataBitVector = LongArrayBitVector.ofLength((long)(solution.length * 2));
                                    dataList = dataBitVector.asLongBigList(2);
                                    break block9;
                                } while ((seed += 0x100000000000000L) != 0L);
                                throw new AssertionError((Object)"Exhausted local seeds");
                            }
                            for (int j = 0; j < solution.length; ++j) {
                                dataList.set((long)j, solution[j]);
                            }
                            queue.put((Object)dataBitVector, (long)chunk.index());
                            ProgressLogger progressLogger = pl;
                            // MONITORENTER : progressLogger
                            pl.update();
                            // MONITOREXIT : progressLogger
                        }
                    });
                }
                try {
                    i = numberOfThreads + 2;
                    while (i-- != 0) {
                        executorCompletionService.take().get();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ChunkedHashStore.DuplicateException) {
                        throw (ChunkedHashStore.DuplicateException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                finally {
                    executorService.shutdown();
                }
                LOGGER.info("Unsolvable systems: " + unsolvable.get() + "/" + (unsolvable.get() + (long)numChunks) + " (" + Util.format((double)(100.0 * (double)unsolvable.get() / (double)(unsolvable.get() + (long)numChunks))) + "%)");
                LOGGER.info("Unorientable systems: " + unorientable.get() + "/" + (unorientable.get() + (long)numChunks) + " (" + Util.format((double)(100.0 * (double)unorientable.get() / (double)(unorientable.get() + (long)numChunks))) + "%)");
                pl.done();
            }
            catch (ChunkedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the chunked hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing triples...");
                chunkedHashStore.reset(r.nextLong());
                pl.itemsName = "keys";
                chunkedHashStore.addAll(keys.iterator());
                continue;
            }
            break;
        }
        this.globalSeed = chunkedHashStore.seed();
        this.values = this.bitVector.asLongBigList(2);
        this.array = this.bitVector.bits();
        LOGGER.info("Completed.");
        LOGGER.debug("Forecast bit cost per key: " + 2.0 * C + 0.0625);
        LOGGER.info("Actual bit cost per key: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth != 0) {
            this.signatureMask = -1L >>> 64 - signatureWidth;
            this.signatures = LongArrayBitVector.getInstance().asLongBigList(signatureWidth);
            this.signatures.size(this.n);
            pl.expectedUpdates = this.n;
            pl.itemsName = "signatures";
            pl.start((CharSequence)"Signing...");
            for (ChunkedHashStore.Chunk chunk : chunkedHashStore) {
                Iterator<long[]> iterator = chunk.iterator();
                int i = chunk.size();
                while (i-- != 0) {
                    long[] triple = iterator.next();
                    int[] e = new int[3];
                    this.signatures.set(this.getLongByTripleNoCheck(triple, e), this.signatureMask & triple[0]);
                    pl.lightUpdate();
                }
            }
            pl.done();
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        if (!givenChunkedHashStore) {
            chunkedHashStore.close();
        }
    }

    public long numBits() {
        return this.values.size64() * 2L + (long)this.edgeOffsetAndSeed.length * 64L;
    }

    public long getLong(Object key) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[3];
        long[] h = new long[3];
        Hashes.spooky4(this.transform.toBitVector(key), this.globalSeed, h);
        int chunk = this.chunkShift == 64 ? 0 : (int)(h[0] >>> this.chunkShift);
        long edgeOffsetSeed = this.edgeOffsetAndSeed[chunk];
        long chunkOffset = GOVMinimalPerfectHashFunction.vertexOffset(edgeOffsetSeed);
        Linear3SystemSolver.tripleToEquation(h, edgeOffsetSeed & 0xFF00000000000000L, (int)(GOVMinimalPerfectHashFunction.vertexOffset(this.edgeOffsetAndSeed[chunk + 1]) - chunkOffset), e);
        if (e[0] == -1) {
            return this.defRetValue;
        }
        long result = (edgeOffsetSeed & 0xFFFFFFFFFFFFFFL) + GOVMinimalPerfectHashFunction.countNonzeroPairs(chunkOffset, chunkOffset + (long)e[(int)(this.values.getLong((long)e[0] + chunkOffset) + this.values.getLong((long)e[1] + chunkOffset) + this.values.getLong((long)e[2] + chunkOffset)) % 3], this.array);
        if (this.signatureMask != 0L) {
            return result >= this.n || ((this.signatures.getLong(result) ^ h[0]) & this.signatureMask) != 0L ? this.defRetValue : result;
        }
        return result < this.n ? result : this.defRetValue;
    }

    public long getLongByTriple(long[] triple) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[3];
        int chunk = this.chunkShift == 64 ? 0 : (int)(triple[0] >>> this.chunkShift);
        long edgeOffsetSeed = this.edgeOffsetAndSeed[chunk];
        long chunkOffset = GOVMinimalPerfectHashFunction.vertexOffset(edgeOffsetSeed);
        Linear3SystemSolver.tripleToEquation(triple, edgeOffsetSeed & 0xFF00000000000000L, (int)(GOVMinimalPerfectHashFunction.vertexOffset(this.edgeOffsetAndSeed[chunk + 1]) - chunkOffset), e);
        if (e[0] == -1) {
            return this.defRetValue;
        }
        long result = (edgeOffsetSeed & 0xFFFFFFFFFFFFFFL) + GOVMinimalPerfectHashFunction.countNonzeroPairs(chunkOffset, chunkOffset + (long)e[(int)(this.values.getLong((long)e[0] + chunkOffset) + this.values.getLong((long)e[1] + chunkOffset) + this.values.getLong((long)e[2] + chunkOffset)) % 3], this.array);
        if (this.signatureMask != 0L) {
            return result >= this.n || this.signatures.getLong(result) != (triple[0] & this.signatureMask) ? this.defRetValue : result;
        }
        return result < this.n ? result : this.defRetValue;
    }

    private long getLongByTripleNoCheck(long[] triple, int[] e) {
        int chunk = this.chunkShift == 64 ? 0 : (int)(triple[0] >>> this.chunkShift);
        long edgeOffsetSeed = this.edgeOffsetAndSeed[chunk];
        long chunkOffset = GOVMinimalPerfectHashFunction.vertexOffset(edgeOffsetSeed);
        Linear3SystemSolver.tripleToEquation(triple, edgeOffsetSeed & 0xFF00000000000000L, (int)(GOVMinimalPerfectHashFunction.vertexOffset(this.edgeOffsetAndSeed[chunk + 1]) - chunkOffset), e);
        return (edgeOffsetSeed & 0xFFFFFFFFFFFFFFL) + GOVMinimalPerfectHashFunction.countNonzeroPairs(chunkOffset, chunkOffset + (long)e[(int)(this.values.getLong((long)e[0] + chunkOffset) + this.values.getLong((long)e[1] + chunkOffset) + this.values.getLong((long)e[2] + chunkOffset)) % 3], this.array);
    }

    @Override
    public long size64() {
        return this.n;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.array = this.bitVector.bits();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(GOVMinimalPerfectHashFunction.class.getName(), "Builds a minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            FileLinesByteArrayCollection collection = new FileLinesByteArrayCollection((CharSequence)stringFile, zipped);
            BinIO.storeObject(new GOVMinimalPerfectHashFunction(collection, TransformationStrategies.rawByteArray(), signatureWidth, tempDir, null), (CharSequence)functionName);
        } else {
            Object collection;
            if ("-".equals(stringFile)) {
                ProgressLogger pl = new ProgressLogger(LOGGER);
                pl.displayLocalSpeed = true;
                pl.displayFreeMemory = true;
                pl.start((CharSequence)"Loading strings...");
                collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
                pl.done();
            } else {
                collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
            }
            TransformationStrategy transformationStrategy = iso ? TransformationStrategies.rawIso() : (utf32 ? TransformationStrategies.rawUtf32() : TransformationStrategies.rawUtf16());
            BinIO.storeObject(new GOVMinimalPerfectHashFunction(collection, transformationStrategy, signatureWidth, tempDir, null), (CharSequence)functionName);
        }
        LOGGER.info("Saved.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected int signatureWidth;
        protected File tempDir;
        protected ChunkedHashStore<T> chunkedHashStore;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(ChunkedHashStore<T> chunkedHashStore) {
            this.chunkedHashStore = chunkedHashStore;
            return this;
        }

        public GOVMinimalPerfectHashFunction<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            if (this.transform == null) {
                if (this.chunkedHashStore != null) {
                    this.transform = this.chunkedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given ChunkedHashStore");
                }
            }
            return new GOVMinimalPerfectHashFunction<T>(this.keys, this.transform, this.signatureWidth, this.tempDir, this.chunkedHashStore);
        }
    }
}

