/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.io.FileLinesByteArrayCollection;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.codec.Codec;
import it.unimi.dsi.sux4j.mph.solve.Linear4SystemSolver;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import it.unimi.dsi.util.concurrent.ReorderingBlockingQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GV4CompressedFunction<T>
extends AbstractObject2LongFunction<T>
implements Serializable,
Size64 {
    private static final long serialVersionUID = 1L;
    private static final LongArrayBitVector END_OF_SOLUTION_QUEUE = LongArrayBitVector.getInstance();
    private static final Pair<ChunkedHashStore.Chunk, Integer> END_OF_CHUNK_QUEUE = new Pair((Object)new ChunkedHashStore.Chunk(), (Object)0);
    private static final Logger LOGGER = LoggerFactory.getLogger(GV4CompressedFunction.class);
    private static final boolean DEBUG = false;
    protected static final int SEED_BITS = 10;
    protected static final int OFFSET_BITS = 54;
    private static final long SEED_STEP = 0x40000000000000L;
    private static final long OFFSET_MASK = 0x3FFFFFFFFFFFFFL;
    private static final long SEED_MASK = -18014398509481984L;
    public static final String NUMBER_OF_THREADS_PROPERTY = "it.unimi.dsi.sux4j.mph.threads";
    public static final double DELTA = 1.03;
    public static final int DELTA_TIMES_256 = (int)Math.floor(263.68);
    public static final int LOG2_CHUNK_SIZE = 10;
    private final int chunkShift;
    protected final long n;
    protected final int globalMaxCodewordLength;
    protected long globalSeed;
    protected final long[] offsetAndSeed;
    protected final LongArrayBitVector data;
    protected final TransformationStrategy<? super T> transform;
    protected final Codec.Decoder decoder;

    protected GV4CompressedFunction(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, LongIterable values, boolean indirect, File tempDir, ChunkedHashStore<T> chunkedHashStore, Codec codec) throws IOException {
        LongArrayBitVector dataBitVector;
        Long2LongOpenHashMap frequencies;
        boolean givenChunkedHashStore;
        Objects.requireNonNull(codec, "Null codec");
        this.transform = transform;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        pl.itemsName = "keys";
        boolean bl = givenChunkedHashStore = chunkedHashStore != null;
        if (!givenChunkedHashStore) {
            if (keys == null) {
                throw new IllegalArgumentException("If you do not provide a chunked hash store, you must provide the keys");
            }
            chunkedHashStore = new ChunkedHashStore<T>(transform, tempDir, -1, pl);
            chunkedHashStore.reset(r.nextLong());
            if (values == null || indirect) {
                chunkedHashStore.addAll(keys.iterator());
            } else {
                chunkedHashStore.addAll(keys.iterator(), values.iterator());
            }
        }
        this.n = chunkedHashStore.size();
        this.defRetValue = -1L;
        if (this.n == 0L) {
            this.globalMaxCodewordLength = 0;
            this.chunkShift = 0;
            this.globalSeed = 0;
            this.data = null;
            this.offsetAndSeed = null;
            this.decoder = null;
            if (!givenChunkedHashStore) {
                chunkedHashStore.close();
            }
            return;
        }
        if (indirect) {
            frequencies = new Long2LongOpenHashMap();
            LongIterator longIterator = values.iterator();
            while (longIterator.hasNext()) {
                long v = (Long)longIterator.next();
                frequencies.addTo(v, 1L);
            }
        } else {
            frequencies = chunkedHashStore.value2FrequencyMap();
        }
        Codec.Coder coder = codec.getCoder((Long2LongMap)frequencies);
        this.globalMaxCodewordLength = coder.maxCodewordLength();
        this.decoder = coder.getDecoder();
        int log2NumChunks = Math.max(0, Fast.mostSignificantBit((long)(this.n >> 10)));
        this.chunkShift = chunkedHashStore.log2Chunks(log2NumChunks);
        int numChunks = 1 << log2NumChunks;
        LOGGER.debug("Number of chunks: " + numChunks);
        this.offsetAndSeed = new long[numChunks + 1];
        OfflineIterable offlineData = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
        int duplicates = 0;
        while (true) {
            pl.expectedUpdates = numChunks;
            pl.itemsName = "chunks";
            pl.start((CharSequence)"Analysing chunks... ");
            AtomicLong unsolvable = new AtomicLong();
            try {
                int numberOfThreads = Integer.parseInt(System.getProperty(NUMBER_OF_THREADS_PROPERTY, Integer.toString(Math.min(16, Runtime.getRuntime().availableProcessors()))));
                ArrayBlockingQueue chunkQueue = new ArrayBlockingQueue(numberOfThreads);
                ReorderingBlockingQueue queue = new ReorderingBlockingQueue(numberOfThreads * 128);
                ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads + 2);
                ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
                executorCompletionService.submit(() -> {
                    LongArrayBitVector data;
                    while ((data = (LongArrayBitVector)queue.take()) != END_OF_SOLUTION_QUEUE) {
                        offlineData.add((Object)data);
                    }
                    return null;
                });
                ChunkedHashStore<Object> chs = chunkedHashStore;
                executorCompletionService.submit(() -> {
                    try {
                        Iterator<ChunkedHashStore.Chunk> iterator = chs.iterator();
                        int i1 = 0;
                        while (iterator.hasNext()) {
                            ChunkedHashStore.Chunk chunk = new ChunkedHashStore.Chunk(iterator.next());
                            assert (i1 == chunk.index());
                            LongBigList valueList = chunk.valueList((LongIterable)(indirect ? values : null));
                            long sumOfLengths = 0L;
                            for (int i = 0; i < chunk.size(); sumOfLengths += (long)coder.codewordLength(valueList.getLong((long)i)), ++i) {
                            }
                            assert ((sumOfLengths * (long)DELTA_TIMES_256 >>> 8) + (long)this.globalMaxCodewordLength <= Integer.MAX_VALUE);
                            long[] lArray = this.offsetAndSeed;
                            // MONITORENTER : this.offsetAndSeed
                            this.offsetAndSeed[i1 + 1] = this.offsetAndSeed[i1] + (sumOfLengths * (long)DELTA_TIMES_256 >>> 8) + (long)this.globalMaxCodewordLength;
                            assert (this.offsetAndSeed[i1 + 1] <= 0x40000000000000L);
                            // MONITOREXIT : lArray
                            chunkQueue.put(new Pair((Object)chunk, (Object)((int)sumOfLengths)));
                            ++i1;
                        }
                        return null;
                    }
                    finally {
                        int i2 = numberOfThreads;
                        while (true) {
                            if (i2-- == 0) {
                            }
                            chunkQueue.put(END_OF_CHUNK_QUEUE);
                        }
                    }
                });
                AtomicInteger activeThreads = new AtomicInteger(numberOfThreads);
                int i = numberOfThreads;
                while (i-- != 0) {
                    executorCompletionService.submit(() -> {
                        Thread.currentThread().setPriority(1);
                        long chunkTime = 0L;
                        long outputTime = 0L;
                        while (true) {
                            long[] solution;
                            LongArrayBitVector data;
                            ChunkedHashStore.Chunk chunk;
                            long start;
                            block9: {
                                start = System.nanoTime();
                                Pair chunkLength = (Pair)chunkQueue.take();
                                chunkTime += System.nanoTime() - start;
                                if (chunkLength == END_OF_CHUNK_QUEUE) {
                                    if (activeThreads.decrementAndGet() == 0) {
                                        queue.put((Object)END_OF_SOLUTION_QUEUE, (long)numChunks);
                                    }
                                    LOGGER.debug("Queue waiting time: " + Util.format((double)((double)chunkTime / 1.0E9)) + "s");
                                    LOGGER.debug("Output waiting time: " + Util.format((double)((double)outputTime / 1.0E9)) + "s");
                                    return null;
                                }
                                chunk = (ChunkedHashStore.Chunk)chunkLength.getFirst();
                                int numEquations = (Integer)chunkLength.getSecond();
                                int numVariables = (int)(this.offsetAndSeed[chunk.index() + 1] - this.offsetAndSeed[chunk.index()] & 0x3FFFFFFFFFFFFFL);
                                long seed = 0L;
                                Linear4SystemSolver solver = new Linear4SystemSolver(numVariables, numEquations);
                                do {
                                    boolean solved22 = solver.generateAndSolve(chunk, seed, chunk.valueList((LongIterable)(indirect ? values : null)), coder, numVariables - this.globalMaxCodewordLength, this.globalMaxCodewordLength);
                                    unsolvable.addAndGet(solver.unsolvable);
                                    if (!solved22) continue;
                                    long[] solved22 = this.offsetAndSeed;
                                    // MONITORENTER : this.offsetAndSeed
                                    int n = chunk.index();
                                    this.offsetAndSeed[n] = this.offsetAndSeed[n] | seed;
                                    // MONITOREXIT : solved22
                                    data = LongArrayBitVector.getInstance();
                                    solution = solver.solution;
                                    data.length((long)solution.length);
                                    break block9;
                                } while ((seed += 0x40000000000000L) != 0L);
                                throw new AssertionError((Object)"Exhausted local seeds");
                            }
                            for (int j = 0; j < solution.length; ++j) {
                                data.set((long)j, (int)solution[j]);
                            }
                            start = System.nanoTime();
                            queue.put((Object)data, (long)chunk.index());
                            outputTime += System.nanoTime() - start;
                            ProgressLogger progressLogger = pl;
                            // MONITORENTER : progressLogger
                            pl.update();
                            // MONITOREXIT : progressLogger
                        }
                    });
                }
                try {
                    i = numberOfThreads + 2;
                    while (i-- != 0) {
                        executorCompletionService.take().get();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ChunkedHashStore.DuplicateException) {
                        throw (ChunkedHashStore.DuplicateException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                finally {
                    executorService.shutdown();
                }
                LOGGER.info("Unsolvable systems: " + unsolvable.get() + "/" + (unsolvable.get() + (long)numChunks) + " (" + Util.format((double)(100.0 * (double)unsolvable.get() / (double)(unsolvable.get() + (long)numChunks))) + "%)");
                pl.done();
            }
            catch (ChunkedHashStore.DuplicateException e) {
                if (keys == null) {
                    throw new IllegalStateException("You provided no keys, but the chunked hash store was not checked");
                }
                if (duplicates++ > 3) {
                    throw new IllegalArgumentException("The input list contains duplicates");
                }
                LOGGER.warn("Found duplicate. Recomputing triples...");
                chunkedHashStore.reset(r.nextLong());
                pl.itemsName = "keys";
                if (values == null || indirect) {
                    chunkedHashStore.addAll(keys.iterator());
                    continue;
                }
                chunkedHashStore.addAll(keys.iterator(), values.iterator());
                continue;
            }
            break;
        }
        this.globalSeed = chunkedHashStore.seed();
        this.data = dataBitVector = LongArrayBitVector.getInstance();
        OfflineIterable.OfflineIterator iterator = offlineData.iterator();
        while (iterator.hasNext()) {
            dataBitVector.append((BitVector)iterator.next());
        }
        iterator.close();
        offlineData.close();
        LOGGER.info("Completed.");
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.n);
        if (!givenChunkedHashStore) {
            chunkedHashStore.close();
        }
    }

    public long getLong(Object o) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        int[] e = new int[4];
        long[] h = new long[3];
        Hashes.spooky4(this.transform.toBitVector(o), this.globalSeed, h);
        int chunk = this.chunkShift == 64 ? 0 : (int)(h[0] >>> this.chunkShift);
        long olc = this.offsetAndSeed[chunk];
        long chunkOffset = olc & 0x3FFFFFFFFFFFFFL;
        long nextChunkOffset = this.offsetAndSeed[chunk + 1] & 0x3FFFFFFFFFFFFFL;
        long chunkSeed = olc & 0xFFC0000000000000L;
        int w = this.globalMaxCodewordLength;
        Linear4SystemSolver.tripleToEquation(h, chunkSeed, (int)(nextChunkOffset - chunkOffset - (long)w), e);
        if (e[0] == -1) {
            return this.defRetValue;
        }
        long e0 = (long)e[0] + chunkOffset;
        long e1 = (long)e[1] + chunkOffset;
        long e2 = (long)e[2] + chunkOffset;
        long e3 = (long)e[3] + chunkOffset;
        long code = this.data.getLong(e0, e0 + (long)w) ^ this.data.getLong(e1, e1 + (long)w) ^ this.data.getLong(e2, e2 + (long)w) ^ this.data.getLong(e3, e3 + (long)w);
        return this.decoder.decode(code);
    }

    public long size64() {
        return this.n;
    }

    @Deprecated
    public int size() {
        return (int)Math.min(this.n, Integer.MAX_VALUE);
    }

    public long numBits() {
        if (this.n == 0L) {
            return 0L;
        }
        return this.data.size64() + (long)this.offsetAndSeed.length * 64L + this.decoder.numBits();
    }

    public boolean containsKey(Object o) {
        return true;
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        LongIterable values;
        SimpleJSAP jsap = new SimpleJSAP(GV4CompressedFunction.class.getName(), "Builds a GOV function mapping a newline-separated list of strings to their ordinal position, or to specific values.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("codec", (StringParser)JSAP.STRING_PARSER, "HUFFMAN", false, 'C', "codec", "The name of the codec to use (UNARY, BINARY, GAMMA, HUFFMAN, LLHUFFMAN)."), new FlaggedOption("limit", (StringParser)JSAP.INTEGER_PARSER, "20", false, 'l', "limit", "Decoding-table length limit for the LLHUFFMAN codec."), new FlaggedOption("values", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'v', "values", "A binary file in DataInput format containing a long for each string (otherwise, the values will be the ordinal positions of the strings)."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised GOV function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int limit = jsapResult.getInt("limit");
        Codec codec = null;
        switch (jsapResult.getString("codec")) {
            case "UNARY": {
                codec = new Codec.Unary();
                break;
            }
            case "BINARY": {
                codec = new Codec.Binary();
                break;
            }
            case "GAMMA": {
                codec = new Codec.Gamma();
                break;
            }
            case "HUFFMAN": {
                codec = new Codec.Huffman();
                break;
            }
            case "LLHUFFMAN": {
                codec = new Codec.Huffman(limit);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown codec \"" + jsapResult.getString("codec") + "\"");
            }
        }
        LongIterable longIterable = values = jsapResult.userSpecified("values") ? BinIO.asLongIterable((CharSequence)jsapResult.getString("values")) : null;
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            FileLinesByteArrayCollection collection = new FileLinesByteArrayCollection((CharSequence)stringFile, zipped);
            BinIO.storeObject(new GV4CompressedFunction(collection, TransformationStrategies.rawByteArray(), values, false, tempDir, null, codec), (CharSequence)functionName);
        } else {
            Object collection;
            if ("-".equals(stringFile)) {
                ProgressLogger pl = new ProgressLogger(LOGGER);
                pl.displayLocalSpeed = true;
                pl.displayFreeMemory = true;
                pl.start((CharSequence)"Loading strings...");
                collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
                pl.done();
            } else {
                collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
            }
            TransformationStrategy transformationStrategy = iso ? TransformationStrategies.rawIso() : (utf32 ? TransformationStrategies.rawUtf32() : TransformationStrategies.rawUtf16());
            BinIO.storeObject(new GV4CompressedFunction(collection, transformationStrategy, values, false, tempDir, null, codec), (CharSequence)functionName);
        }
        LOGGER.info("Completed.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected File tempDir;
        protected ChunkedHashStore<T> chunkedHashStore;
        protected LongIterable values;
        protected boolean indirect;
        protected boolean built;
        protected Codec codec;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(ChunkedHashStore<T> chunkedHashStore) {
            this.chunkedHashStore = chunkedHashStore;
            return this;
        }

        public Builder<T> values(LongIterable values) {
            this.values = values;
            return this;
        }

        public Builder<T> indirect() {
            this.indirect = true;
            return this;
        }

        public Builder<T> codec(Codec codec) {
            this.codec = codec;
            return this;
        }

        public GV4CompressedFunction<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            if (this.codec == null) {
                this.codec = new Codec.Huffman();
            }
            this.built = true;
            if (this.transform == null) {
                if (this.chunkedHashStore != null) {
                    this.transform = this.chunkedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given ChunkedHashStore");
                }
            }
            return new GV4CompressedFunction<T>(this.keys, this.transform, this.values, this.indirect, this.tempDir, this.chunkedHashStore, this.codec);
        }
    }
}

