/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.HuTuckerTransformationStrategy;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntBigArrayBigList;
import it.unimi.dsi.fastutil.ints.IntBigList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.bits.JacobsonBalancedParentheses;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.util.EliasFanoLongBigList;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HollowTrieMonotoneMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Serializable,
Size64 {
    private static final Logger LOGGER = LoggerFactory.getLogger(HollowTrieMonotoneMinimalPerfectHashFunction.class);
    private static final long serialVersionUID = 4L;
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    protected EliasFanoLongBigList skips;
    protected final LongArrayBitVector trie;
    protected JacobsonBalancedParentheses balParen;
    private final TransformationStrategy<? super T> transform;
    private long size;

    public long getLong(Object object) {
        if (this.size <= 1L) {
            return this.size - 1L;
        }
        BitVector bitVector = this.transform.toBitVector(object).fast();
        long p = 1L;
        long length = bitVector.length();
        long index = 0L;
        long s = 0L;
        long r = 0L;
        while ((s += (long)((int)this.skips.getLong(r))) < length) {
            if (bitVector.getBoolean(s)) {
                long q = this.balParen.findClose(p) + 1L;
                r += (q - p) / 2L;
                index += (q - p) / 2L;
                if (!this.trie.getBoolean(q)) {
                    return index;
                }
                p = q;
            } else {
                if (!this.trie.getBoolean(++p)) {
                    return index;
                }
                ++r;
            }
            ++s;
        }
        return this.defRetValue;
    }

    public HollowTrieMonotoneMinimalPerfectHashFunction(Iterable<? extends T> iterable, TransformationStrategy<? super T> transform) {
        this(iterable.iterator(), transform);
    }

    public HollowTrieMonotoneMinimalPerfectHashFunction(Iterator<? extends T> iterator, TransformationStrategy<? super T> transform) {
        this.transform = transform;
        this.defRetValue = -1L;
        long size = 0L;
        long numNodes = 0L;
        long maxLength = 0L;
        long totalLength = 0L;
        Node root = null;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        pl.start((CharSequence)"Generating hollow trie...");
        if (iterator.hasNext()) {
            LongArrayBitVector prev = LongArrayBitVector.copy((BitVector)transform.toBitVector(iterator.next()));
            LongArrayBitVector curr = LongArrayBitVector.getInstance();
            int last = -1;
            ObjectArrayList stack = new ObjectArrayList();
            IntArrayList len = new IntArrayList();
            pl.lightUpdate();
            totalLength = maxLength = prev.length();
            ++size;
            while (iterator.hasNext()) {
                Node node;
                Node parent;
                ++size;
                curr.replace(transform.toBitVector(iterator.next()));
                pl.lightUpdate();
                if (maxLength < curr.length()) {
                    maxLength = curr.length();
                }
                totalLength += curr.length();
                int prefix = (int)curr.longestCommonPrefixLength(prev);
                if ((long)prefix == prev.length() && (long)prefix == curr.length()) {
                    throw new IllegalArgumentException("The input bit vectors are not distinct");
                }
                if ((long)prefix == prev.length() || (long)prefix == curr.length()) {
                    throw new IllegalArgumentException("The input bit vectors are not prefix-free");
                }
                if (prev.getBoolean(prefix)) {
                    throw new IllegalArgumentException("The input bit vectors are not lexicographically sorted");
                }
                while (last >= 0 && len.getInt(last) > prefix) {
                    --last;
                }
                if (last >= 0) {
                    parent = (Node)stack.get(last);
                    node = parent.right;
                    prefix -= len.getInt(last);
                } else {
                    parent = null;
                    node = root;
                }
                stack.size(last + 1);
                len.size(last + 1);
                Node newNode = null;
                if (node != null) {
                    newNode = new Node(null, prefix);
                    ++numNodes;
                    if (parent == null) {
                        root.skip -= prefix + 1;
                        root = newNode;
                    } else {
                        parent.right = newNode;
                        node.skip -= prefix + 1;
                    }
                    Node n = node;
                    long reprSize = 0L;
                    long skipSize = 0L;
                    do {
                        reprSize += n.repr.length() + 2L;
                        skipSize += n.skips.size64() + 1L;
                    } while ((n = n.right) != null);
                    n = node;
                    newNode.repr.ensureCapacity(reprSize);
                    newNode.skips.ensureCapacity(skipSize);
                    do {
                        newNode.repr.add(true);
                        newNode.repr.append((BitVector)n.repr);
                        newNode.repr.add(false);
                        newNode.skips.add(n.skip);
                        newNode.skips.addAll((IntBigList)n.skips);
                    } while ((n = n.right) != null);
                    len.push((last < 0 ? 0 : len.getInt(last)) + 1 + newNode.skip);
                    stack.push((Object)newNode);
                    ++last;
                } else {
                    newNode = new Node(null, prefix);
                    if (parent == null) {
                        root = newNode;
                        len.push(root.skip + 1);
                        stack.push((Object)root);
                    } else {
                        parent.right = newNode;
                        len.push(len.getInt(last) + 1 + newNode.skip);
                        stack.push((Object)newNode);
                    }
                    ++numNodes;
                    ++last;
                }
                LongArrayBitVector temp = prev;
                prev = curr;
                curr = temp;
            }
        }
        this.size = size;
        pl.done();
        if (size <= 1L) {
            this.balParen = new JacobsonBalancedParentheses(BitVectors.EMPTY_VECTOR);
            this.trie = LongArrayBitVector.getInstance((long)0L);
            return;
        }
        LongArrayBitVector bitVector = LongArrayBitVector.getInstance((long)(2L * numNodes + 2L));
        bitVector.add(true);
        Node m = root;
        do {
            bitVector.add(true);
            bitVector.append((BitVector)m.repr);
            bitVector.add(false);
        } while ((m = m.right) != null);
        bitVector.add(false);
        LOGGER.debug("Generating succinct representations...");
        this.trie = bitVector;
        this.balParen = new JacobsonBalancedParentheses((BitVector)bitVector, false, true, false);
        final Node finalRoot = root;
        LongIterable skipIterable = () -> new LongIterator(){
            Node curr;
            long currElem;
            {
                this.curr = finalRoot;
                this.currElem = -1L;
            }

            public long nextLong() {
                if (this.currElem == -1L) {
                    ++this.currElem;
                    return this.curr.skip;
                }
                if (this.currElem < this.curr.skips.size64()) {
                    return this.curr.skips.getInt(this.currElem++);
                }
                this.curr = this.curr.right;
                this.currElem = 0L;
                return this.curr.skip;
            }

            public boolean hasNext() {
                return this.curr != null && (this.currElem < this.curr.skips.size64() || this.currElem == this.curr.skips.size64() && this.curr.right != null);
            }
        };
        long maxSkip = 0L;
        long minSkip = Long.MAX_VALUE;
        LongIterator i = skipIterable.iterator();
        while (i.hasNext()) {
            long s = i.nextLong();
            maxSkip = Math.max(s, maxSkip);
            minSkip = Math.min(s, minSkip);
        }
        int skipWidth = Fast.ceilLog2((long)maxSkip);
        LOGGER.debug("Max skip: " + maxSkip);
        LOGGER.debug("Max skip width: " + skipWidth);
        this.skips = new EliasFanoLongBigList(skipIterable.iterator(), minSkip, true);
        long numBits = this.numBits();
        LOGGER.debug("Bits: " + numBits);
        LOGGER.debug("Bits per open parenthesis: " + (double)this.balParen.numBits() / (double)size);
        double avgLength = (double)totalLength / (double)size;
        LOGGER.info("Forecast bit cost per element: " + (4.0 + Fast.log2((double)avgLength) + 1.0 + Fast.log2((double)(Fast.log2((double)(avgLength + 1.0)) + 1.0))));
        LOGGER.info("Actual bit cost per element: " + (double)numBits / (double)size);
    }

    @Override
    public long size64() {
        return this.size;
    }

    public long numBits() {
        return this.balParen.numBits() + this.trie.length() + this.skips.numBits() + this.transform.numBits();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        Object collection;
        SimpleJSAP jsap = new SimpleJSAP(HollowTrieMonotoneMinimalPerfectHashFunction.class.getName(), "Builds a monotone minimal perfect hash function based on a hollow trie reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("huTucker", 'h', "hu-tucker", "Use Hu-Tucker coding to reduce string length."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("trie", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised hollow trie."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String trieName = jsapResult.getString("trie");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean huTucker = jsapResult.getBoolean("huTucker");
        boolean utf32 = jsapResult.getBoolean("utf32");
        if ("-".equals(stringFile)) {
            ProgressLogger pl = new ProgressLogger(LOGGER);
            pl.displayLocalSpeed = true;
            pl.displayFreeMemory = true;
            pl.start((CharSequence)"Loading strings...");
            collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
            pl.done();
        } else {
            collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
        }
        HuTuckerTransformationStrategy transformationStrategy = huTucker ? new HuTuckerTransformationStrategy((Iterable)collection, true) : (iso ? TransformationStrategies.prefixFreeIso() : (utf32 ? TransformationStrategies.prefixFreeUtf32() : TransformationStrategies.prefixFreeUtf16()));
        BinIO.storeObject(new HollowTrieMonotoneMinimalPerfectHashFunction(collection, transformationStrategy), (CharSequence)trieName);
        LOGGER.info("Completed.");
    }

    private static final class Node {
        Node right;
        int skip;
        IntBigArrayBigList skips = new IntBigArrayBigList();
        LongArrayBitVector repr = LongArrayBitVector.getInstance();

        public Node(Node right, int skip) {
            this.right = right;
            this.skip = skip;
        }
    }
}

