/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.GOV3Function;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoStepsGOV3Function<T>
extends AbstractHashFunction<T>
implements Serializable,
Size64 {
    public static final long serialVersionUID = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TwoStepsGOV3Function.class);
    private static final boolean ASSERTS = false;
    protected final long n;
    protected final TransformationStrategy<? super T> transform;
    protected final GOV3Function<T> firstFunction;
    protected final GOV3Function<T> secondFunction;
    protected final long[] remap;
    protected final int escape;
    protected long seed;
    protected final int width;
    protected final double rankMean;

    protected TwoStepsGOV3Function(Iterable<? extends T> keys, TransformationStrategy<? super T> transform, final LongBigList values, File tempDir, ChunkedHashStore<T> chunkedHashStore) throws IOException {
        boolean givenChunkedHashStore;
        this.transform = transform;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        XoRoShiRo128PlusRandomGenerator random = new XoRoShiRo128PlusRandomGenerator();
        pl.itemsName = "keys";
        boolean bl = givenChunkedHashStore = chunkedHashStore != null;
        if (chunkedHashStore == null) {
            if (keys == null) {
                throw new IllegalArgumentException("If you do not provide a chunked hash store, you must provide the keys");
            }
            chunkedHashStore = new ChunkedHashStore<T>(transform, pl);
            chunkedHashStore.reset(random.nextLong());
            chunkedHashStore.addAll(keys.iterator());
        }
        this.n = chunkedHashStore.size();
        this.defRetValue = -1L;
        if (this.n == 0L) {
            this.width = 0;
            this.escape = 0;
            this.rankMean = 0;
            this.secondFunction = null;
            this.firstFunction = null;
            this.remap = null;
            if (!givenChunkedHashStore) {
                chunkedHashStore.close();
            }
            return;
        }
        int w = 0;
        Long2LongOpenHashMap counts = new Long2LongOpenHashMap();
        counts.defaultReturnValue(-1L);
        LongBigListIterator i = values.iterator();
        while (i.hasNext()) {
            long v = i.nextLong();
            counts.put(v, counts.get(v) + 1L);
            int size = Fast.length((long)v);
            if (size <= w) continue;
            w = size;
        }
        this.width = w;
        int m = counts.size();
        LOGGER.debug("Generating two-steps GOV3 function with " + w + " output bits...");
        long[] keysArray = counts.keySet().toArray(new long[m]);
        LongArrays.quickSort((long[])keysArray, (int)0, (int)keysArray.length, (a, b) -> Long.signum(counts.get(b) - counts.get(a)));
        long mean = 0L;
        for (int i2 = 0; i2 < keysArray.length; ++i2) {
            mean += (long)i2 * counts.get(keysArray[i2]);
        }
        this.rankMean = (double)mean / (double)this.n;
        long post = this.n;
        long bestCost = Long.MAX_VALUE;
        int pos = 0;
        int best = -1;
        for (int r = 0; r < w && pos < m; ++r) {
            long cost = (long)Math.min(GOV3Function.C * (double)this.n * 1.126 + (double)(this.n * (long)r), GOV3Function.C * (double)this.n * (double)r) + (long)Math.min(GOV3Function.C * (double)post * 1.126 + (double)(post * (long)w), GOV3Function.C * (double)post * (double)w) + (long)(pos * 64);
            if (cost < bestCost) {
                best = r;
                bestCost = cost;
            }
            for (int j = 0; j < 1 << r && pos < m; ++j) {
                long c = counts.get(keysArray[pos++]);
                post -= c;
            }
        }
        counts.clear();
        counts.trim();
        if (best >= 32) {
            best = 31;
        }
        LOGGER.debug("Best threshold: " + best);
        this.escape = (1 << best) - 1;
        this.remap = new long[this.escape];
        System.arraycopy(keysArray, 0, this.remap, 0, this.remap.length);
        final Long2LongOpenHashMap map = new Long2LongOpenHashMap();
        map.defaultReturnValue(-1L);
        for (int i3 = 0; i3 < this.escape; ++i3) {
            map.put(this.remap[i3], (long)i3);
        }
        if (best != 0) {
            this.firstFunction = new GOV3Function.Builder<T>().keys(keys).transform(transform).store(chunkedHashStore).values((LongIterable)new AbstractLongBigList(){

                public long getLong(long index) {
                    long value = map.get(values.getLong(index));
                    return value == -1L ? (long)TwoStepsGOV3Function.this.escape : value;
                }

                public long size64() {
                    return TwoStepsGOV3Function.this.n;
                }
            }, best).indirect().build();
            LOGGER.debug("Actual bit cost per key of first function: " + (double)this.firstFunction.numBits() / (double)this.n);
        } else {
            this.firstFunction = null;
        }
        chunkedHashStore.filter(triple -> this.firstFunction == null || this.firstFunction.getLongByTriple((long[])triple) == (long)this.escape);
        this.secondFunction = new GOV3Function.Builder<Object>().store(chunkedHashStore).values((LongIterable)values, w).indirect().build();
        this.seed = chunkedHashStore.seed();
        if (!givenChunkedHashStore) {
            chunkedHashStore.close();
        }
        LOGGER.debug("Actual bit cost per key of second function: " + (double)this.secondFunction.numBits() / (double)this.n);
        LOGGER.info("Actual bit cost per key: " + (double)this.numBits() / (double)this.n);
        LOGGER.info("Completed.");
    }

    public long getLong(Object o) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        long[] triple = new long[3];
        Hashes.spooky4(this.transform.toBitVector(o), this.seed, triple);
        if (this.firstFunction != null) {
            int firstValue = (int)this.firstFunction.getLongByTriple(triple);
            if (firstValue == -1) {
                return this.defRetValue;
            }
            if (firstValue != this.escape) {
                return this.remap[firstValue];
            }
        }
        return this.secondFunction.getLongByTriple(triple);
    }

    public long getLongByTriple(long[] triple) {
        if (this.firstFunction != null) {
            int firstValue = (int)this.firstFunction.getLongByTriple(triple);
            if (firstValue == -1) {
                return this.defRetValue;
            }
            if (firstValue != this.escape) {
                return this.remap[firstValue];
            }
        }
        return this.secondFunction.getLongByTriple(triple);
    }

    @Override
    public long size64() {
        return this.n;
    }

    public long numBits() {
        return (this.firstFunction != null ? this.firstFunction.numBits() : 0L) + this.secondFunction.numBits() + this.transform.numBits() + (long)this.remap.length * 64L;
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        Object collection;
        SimpleJSAP jsap = new SimpleJSAP(TwoStepsGOV3Function.class.getName(), "Builds a two-steps GOV3 function mapping a newline-separated list of strings to their ordinal position, or to specific values.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("values", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, 'v', "values", "A binary file in DataInput format containing a long for each string (otherwise, the values will be the ordinal positions of the strings)."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised two-steps GOV3 function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        if ("-".equals(stringFile)) {
            ProgressLogger pl = new ProgressLogger(LOGGER);
            pl.displayLocalSpeed = true;
            pl.displayFreeMemory = true;
            pl.start((CharSequence)"Loading strings...");
            collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
            pl.done();
        } else {
            collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
        }
        TransformationStrategy transformationStrategy = iso ? TransformationStrategies.rawIso() : (utf32 ? TransformationStrategies.rawUtf32() : TransformationStrategies.rawUtf16());
        BinIO.storeObject(new TwoStepsGOV3Function(collection, transformationStrategy, (LongBigList)LongBigArrayBigList.wrap((long[][])BinIO.loadLongsBig((CharSequence)jsapResult.getString("values"))), tempDir, null), (CharSequence)functionName);
        LOGGER.info("Completed.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected File tempDir;
        protected ChunkedHashStore<T> chunkedHashStore;
        protected LongBigList values;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public Builder<T> store(ChunkedHashStore<T> chunkedHashStore) {
            this.chunkedHashStore = chunkedHashStore;
            return this;
        }

        public Builder<T> values(LongBigList values) {
            this.values = values;
            return this;
        }

        public TwoStepsGOV3Function<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            if (this.transform == null) {
                if (this.chunkedHashStore != null) {
                    this.transform = this.chunkedHashStore.transform();
                } else {
                    throw new IllegalArgumentException("You must specify a TransformationStrategy, either explicitly or via a given ChunkedHashStore");
                }
            }
            return new TwoStepsGOV3Function<T>(this.keys, this.transform, this.values, this.tempDir, this.chunkedHashStore);
        }
    }
}

