/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.BitVectors;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.ints.IntBigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.io.OfflineIterable;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.io.ChunkedHashStore;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.GOV3Function;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.TwoStepsGOV3Function;
import it.unimi.dsi.util.XoRoShiRo128PlusRandomGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoStepsLcpMonotoneMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Size64,
Serializable {
    public static final long serialVersionUID = 4L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TwoStepsLcpMonotoneMinimalPerfectHashFunction.class);
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    protected final long n;
    protected final int bucketSize;
    protected final int log2BucketSize;
    protected final int bucketSizeMask;
    protected final GOV3Function<BitVector> offsets;
    protected final TwoStepsGOV3Function<BitVector> lcpLengths;
    protected final GOV3Function<BitVector> lcp2Bucket;
    protected final TransformationStrategy<? super T> transform;
    protected final long seed;
    protected final long signatureMask;
    protected final LongBigList signatures;

    protected TwoStepsLcpMonotoneMinimalPerfectHashFunction(Iterable<? extends T> keys, long numKeys, TransformationStrategy<? super T> transform, int signatureWidth, File tempDir) throws IOException {
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        this.transform = transform;
        XoRoShiRo128PlusRandomGenerator r = new XoRoShiRo128PlusRandomGenerator();
        if (numKeys == -1L) {
            if (keys instanceof Size64) {
                this.n = ((Size64)keys).size64();
            } else if (keys instanceof Collection) {
                this.n = ((Collection)keys).size();
            } else {
                long c = 0L;
                for (T dummy : keys) {
                    ++c;
                }
                this.n = c;
            }
        } else {
            this.n = numKeys;
        }
        this.defRetValue = -1L;
        if (this.n == 0L) {
            this.log2BucketSize = 0;
            this.bucketSizeMask = 0;
            this.bucketSize = 0;
            this.seed = 0;
            this.lcp2Bucket = null;
            this.offsets = null;
            this.lcpLengths = null;
            this.signatureMask = 0L;
            this.signatures = null;
            return;
        }
        int t = (int)Math.ceil(1.0 + GOV3Function.C * Math.log(2.0) + Math.log(this.n) - Math.log(1.0 + Math.log(this.n)));
        this.log2BucketSize = Fast.ceilLog2((int)t);
        this.bucketSize = 1 << this.log2BucketSize;
        this.bucketSizeMask = this.bucketSize - 1;
        LOGGER.debug("Bucket size: " + this.bucketSize);
        long numBuckets = (this.n + (long)this.bucketSize - 1L) / (long)this.bucketSize;
        LongArrayBitVector prev = LongArrayBitVector.getInstance();
        LongArrayBitVector curr = LongArrayBitVector.getInstance();
        int currLcp = 0;
        OfflineIterable lcps = new OfflineIterable((OfflineIterable.Serializer)BitVectors.OFFLINE_SERIALIZER, (Object)LongArrayBitVector.getInstance());
        final int[][] lcpLengths = IntBigArrays.newBigArray((long)((this.n + (long)this.bucketSize - 1L) / (long)this.bucketSize));
        int maxLcp = 0;
        long maxLength = 0L;
        ChunkedHashStore<LongArrayBitVector> chunkedHashStore = new ChunkedHashStore<LongArrayBitVector>(TransformationStrategies.identity(), pl);
        chunkedHashStore.reset(r.nextLong());
        pl.expectedUpdates = this.n;
        pl.start((CharSequence)"Scanning collection...");
        Iterator<T> iterator = keys.iterator();
        for (long b = 0L; b < numBuckets; ++b) {
            prev.replace(transform.toBitVector(iterator.next()));
            chunkedHashStore.add(prev);
            pl.lightUpdate();
            maxLength = Math.max(maxLength, prev.length());
            currLcp = (int)prev.length();
            int currBucketSize = (int)Math.min((long)this.bucketSize, this.n - b * (long)this.bucketSize);
            for (int i = 0; i < currBucketSize - 1; ++i) {
                curr.replace(transform.toBitVector(iterator.next()));
                chunkedHashStore.add(curr);
                pl.lightUpdate();
                int prefix = (int)curr.longestCommonPrefixLength(prev);
                if ((long)prefix == prev.length() && (long)prefix == curr.length()) {
                    throw new IllegalArgumentException("The input bit vectors are not distinct");
                }
                if ((long)prefix == prev.length() || (long)prefix == curr.length()) {
                    throw new IllegalArgumentException("The input bit vectors are not prefix-free");
                }
                if (prev.getBoolean(prefix)) {
                    throw new IllegalArgumentException("The input bit vectors are not lexicographically sorted");
                }
                currLcp = Math.min(prefix, currLcp);
                prev.replace(curr);
                maxLength = Math.max(maxLength, prev.length());
            }
            lcps.add((Object)prev.subVector(0L, (long)currLcp));
            IntBigArrays.set((int[][])lcpLengths, (long)b, (int)currLcp);
            maxLcp = Math.max(maxLcp, currLcp);
        }
        pl.done();
        chunkedHashStore.checkAndRetry(TransformationStrategies.wrap(keys, transform));
        this.seed = chunkedHashStore.seed();
        this.lcp2Bucket = new GOV3Function.Builder().keys(lcps).transform(TransformationStrategies.identity()).build();
        lcps.close();
        this.offsets = new GOV3Function.Builder<LongArrayBitVector>().store(chunkedHashStore).values((LongIterable)new AbstractLongBigList(){

            public long getLong(long index) {
                return index & (long)TwoStepsLcpMonotoneMinimalPerfectHashFunction.this.bucketSizeMask;
            }

            public long size64() {
                return TwoStepsLcpMonotoneMinimalPerfectHashFunction.this.n;
            }
        }, this.log2BucketSize).indirect().build();
        this.lcpLengths = new TwoStepsGOV3Function.Builder<LongArrayBitVector>().store(chunkedHashStore).values((LongBigList)new AbstractLongBigList(){

            public long getLong(long index) {
                return IntBigArrays.get((int[][])lcpLengths, (long)(index >>> TwoStepsLcpMonotoneMinimalPerfectHashFunction.this.log2BucketSize));
            }

            public long size64() {
                return TwoStepsLcpMonotoneMinimalPerfectHashFunction.this.n;
            }
        }).build();
        double p = 1.0 / (this.lcpLengths.rankMean + 1.0);
        double s = TwoStepsLcpMonotoneMinimalPerfectHashFunction.s(p, this.lcpLengths.width);
        LOGGER.debug("Forecast best threshold: " + s);
        double secondFunctionForecastBitsPerElement = s + GOV3Function.C + (Math.pow(2.0, s) - 1.0) * (double)this.lcpLengths.width / (double)this.n + ((double)this.lcpLengths.width + GOV3Function.C) * Math.pow(1.0 - p, Math.pow(2.0, s) + 1.0);
        LOGGER.debug("Forecast bit cost per element: " + ((double)this.log2BucketSize + GOV3Function.C + secondFunctionForecastBitsPerElement + Fast.log2((double)Math.E)));
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.n);
        if (signatureWidth != 0) {
            this.signatureMask = -1L >>> 64 - signatureWidth;
            chunkedHashStore.filter(null);
            this.signatures = chunkedHashStore.signatures(signatureWidth, pl);
        } else {
            this.signatureMask = 0L;
            this.signatures = null;
        }
        chunkedHashStore.close();
    }

    private static double W(double x) {
        return -Math.log(-1.0 / x) - Math.log(Math.log(-1.0 / x));
    }

    private static double s(double p, int r) {
        return Fast.log2((double)(TwoStepsLcpMonotoneMinimalPerfectHashFunction.W(1.0 / (Math.log(2.0) * ((double)r + GOV3Function.C) * (p - 1.0))) / Math.log(1.0 - p)));
    }

    @Override
    public long size64() {
        return this.n;
    }

    public long numBits() {
        if (this.n == 0L) {
            return 0L;
        }
        return this.offsets.numBits() + this.lcpLengths.numBits() + this.lcp2Bucket.numBits() + this.transform.numBits();
    }

    public long getLong(Object o) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        BitVector bitVector = this.transform.toBitVector(o).fast();
        long[] triple = new long[3];
        Hashes.spooky4(bitVector, this.seed, triple);
        long prefix = this.lcpLengths.getLongByTriple(triple);
        if (prefix == -1L || prefix > bitVector.length()) {
            return this.defRetValue;
        }
        long result = (this.lcp2Bucket.getLong(bitVector.subVector(0L, prefix)) << this.log2BucketSize) + this.offsets.getLongByTriple(triple);
        if (this.signatureMask != 0L) {
            return result < 0L || result >= this.n || this.signatures.getLong(result) != (triple[0] & this.signatureMask) ? this.defRetValue : result;
        }
        return result < 0L || result >= this.n ? this.defRetValue : result;
    }

    public long getLongByBitVectorAndTriple(BitVector bitVector, long[] triple) {
        if (this.n == 0L) {
            return this.defRetValue;
        }
        long prefix = this.lcpLengths.getLongByTriple(triple);
        if (prefix == -1L || prefix > bitVector.length()) {
            return this.defRetValue;
        }
        long result = (this.lcp2Bucket.getLong(bitVector.subVector(0L, prefix)) << this.log2BucketSize) + this.offsets.getLongByTriple(triple);
        if (this.signatureMask != 0L) {
            return result < 0L || result >= this.n || this.signatures.getLong(result) != (triple[0] & this.signatureMask) ? this.defRetValue : result;
        }
        return result < 0L || result >= this.n ? this.defRetValue : result;
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        Object collection;
        SimpleJSAP jsap = new SimpleJSAP(TwoStepsLcpMonotoneMinimalPerfectHashFunction.class.getName(), "Builds a two-steps LCP-based monotone minimal perfect hash function reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'T', "temp-dir", "A directory for temporary files."), new Switch("huTucker", 'h', "hu-tucker", "Use Hu-Tucker coding to reduce string length."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new FlaggedOption("signatureWidth", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, false, 's', "signature-width", "If specified, the signature width in bits; if negative, the generated function will be a dictionary."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised monotone minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the first case, strings will not be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        File tempDir = jsapResult.getFile("tempDir");
        boolean zipped = jsapResult.getBoolean("zipped");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        int signatureWidth = jsapResult.getInt("signatureWidth", 0);
        if ("-".equals(stringFile)) {
            ProgressLogger pl = new ProgressLogger(LOGGER);
            pl.displayLocalSpeed = true;
            pl.displayFreeMemory = true;
            pl.start((CharSequence)"Loading strings...");
            collection = new LineIterator(new FastBufferedReader((Reader)new InputStreamReader(zipped ? new GZIPInputStream(System.in) : System.in, encoding)), pl).allLines();
            pl.done();
        } else {
            collection = new FileLinesCollection((CharSequence)stringFile, encoding.toString(), zipped);
        }
        TransformationStrategy transformationStrategy = iso ? TransformationStrategies.prefixFreeIso() : (utf32 ? TransformationStrategies.prefixFreeUtf32() : TransformationStrategies.prefixFreeUtf16());
        BinIO.storeObject(new TwoStepsLcpMonotoneMinimalPerfectHashFunction(collection, -1L, transformationStrategy, signatureWidth, tempDir), (CharSequence)functionName);
        LOGGER.info("Completed.");
    }

    public static class Builder<T> {
        protected Iterable<? extends T> keys;
        protected TransformationStrategy<? super T> transform;
        protected long numKeys = -1L;
        protected int signatureWidth;
        protected File tempDir;
        protected boolean built;

        public Builder<T> keys(Iterable<? extends T> keys) {
            this.keys = keys;
            return this;
        }

        public Builder<T> numKeys(long numKeys) {
            this.numKeys = numKeys;
            return this;
        }

        public Builder<T> transform(TransformationStrategy<? super T> transform) {
            this.transform = transform;
            return this;
        }

        public Builder<T> signed(int signatureWidth) {
            this.signatureWidth = signatureWidth;
            return this;
        }

        public Builder<T> tempDir(File tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public TwoStepsLcpMonotoneMinimalPerfectHashFunction<T> build() throws IOException {
            if (this.built) {
                throw new IllegalStateException("This builder has been already used");
            }
            this.built = true;
            return new TwoStepsLcpMonotoneMinimalPerfectHashFunction<T>(this.keys, this.numKeys, this.transform, this.signatureWidth, this.tempDir);
        }
    }
}

