/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph.codec;

import com.google.common.primitives.Longs;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.LongArrays;
import java.io.Serializable;

public interface Codec {
    public Coder getCoder(Long2LongMap var1);

    public static class Huffman
    implements Codec {
        private final int maxDecodingTableLength;
        private final double entropyThreshold;

        public Huffman(int maxDecodingTableLength, double entropyThreshold) {
            this.maxDecodingTableLength = maxDecodingTableLength;
            this.entropyThreshold = entropyThreshold;
        }

        public Huffman(int maxDepth) {
            this(maxDepth, 0.99);
        }

        public Huffman() {
            this(Integer.MAX_VALUE, 1.0);
        }

        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            assert (Longs.min((long[])frequencies.values().toLongArray()) > 0L);
            int size = frequencies.size();
            if (size == 0 || size == 1) {
                return new Coder(new long[0], new int[0], new long[0], (Long2IntMap)Long2IntMaps.EMPTY_MAP);
            }
            long[] symbol = new long[size];
            frequencies.keySet().toArray(symbol);
            LongArrays.quickSort((long[])symbol, (x, y) -> Long.compare(frequencies.get(y), frequencies.get(x)));
            Long2IntOpenHashMap symbol2Rank = new Long2IntOpenHashMap();
            for (int i = 0; i < size; ++i) {
                symbol2Rank.put(symbol[i], i);
            }
            int[] length = new int[size];
            long[] a = new long[size];
            int cutpoint = -1;
            block1: do {
                int next;
                for (int i = 0; i < size; ++i) {
                    a[size - 1 - i] = frequencies.get(symbol[i]);
                }
                if (cutpoint != -1) {
                    long overallNumerosityBeyondCutpoint = 0L;
                    int i = size - cutpoint;
                    while (i-- != 0) {
                        overallNumerosityBeyondCutpoint += a[i];
                    }
                    long fakeNumerosity = overallNumerosityBeyondCutpoint / (long)(size - cutpoint);
                    long threshold = (long)(size - cutpoint) - overallNumerosityBeyondCutpoint % (long)(size - cutpoint);
                    int i2 = size - cutpoint;
                    while (i2-- != 0) {
                        a[i2] = fakeNumerosity + (long)((long)i2 < threshold ? 0 : 1);
                    }
                }
                a[0] = a[0] + a[1];
                int root = 0;
                int leaf = 2;
                for (next = 1; next < size - 1; ++next) {
                    if (leaf >= size || a[root] < a[leaf]) {
                        a[next] = a[root];
                        a[root++] = next;
                    } else {
                        a[next] = a[leaf++];
                    }
                    if (leaf >= size || root < next && a[root] < a[leaf]) {
                        int n = next;
                        a[n] = a[n] + a[root];
                        a[root++] = next;
                        continue;
                    }
                    int n = next;
                    a[n] = a[n] + a[leaf++];
                }
                a[size - 2] = 0L;
                for (next = size - 3; next >= 0; --next) {
                    a[next] = a[(int)a[next]] + 1L;
                }
                int available = 1;
                int used = 0;
                int depth = 0;
                root = size - 2;
                int next2 = size - 1;
                long overallLength = 0L;
                while (available > 0) {
                    while (root >= 0 && a[root] == (long)depth) {
                        ++used;
                        --root;
                    }
                    while (available > used) {
                        overallLength += (long)depth * frequencies.get(symbol[size - next2 - 1]);
                        a[next2--] = depth;
                        --available;
                    }
                    available = 2 * used;
                    ++depth;
                    used = 0;
                }
                int i = size;
                while (i-- != 0) {
                    length[i] = (int)a[size - 1 - i];
                }
                if (cutpoint != -1) break;
                long accumulatedOverallLength = 0L;
                int currentLength = 0;
                int d = 1;
                for (cutpoint = 0; cutpoint < size; ++cutpoint) {
                    if (currentLength != length[cutpoint]) {
                        if (++d > this.maxDecodingTableLength) continue block1;
                        currentLength = length[cutpoint];
                    }
                    if ((double)(accumulatedOverallLength += (long)length[cutpoint] * frequencies.get(symbol[cutpoint])) / (double)overallLength > this.entropyThreshold) continue block1;
                }
            } while (cutpoint < size - 2);
            long[] codeword = new long[size];
            int s = 0;
            long value = 0L;
            int currentLength = length[0];
            codeword[0] = 0L;
            for (int i = 1; i < size; ++i) {
                s = i;
                if (length[i] == currentLength) {
                    ++value;
                } else {
                    ++value;
                    value <<= length[i] - currentLength;
                    currentLength = length[i];
                }
                codeword[s] = Long.reverse(value) >>> 64 - currentLength;
            }
            return new Coder(codeword, length, symbol, (Long2IntMap)symbol2Rank);
        }

        protected static final class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private final long[] codeword;
            private final int[] codewordLength;
            private final long[] symbol;
            private final Long2IntMap symbol2Rank;

            public Coder(long[] codeWord, int[] codewordLength, long[] symbol, Long2IntMap symbol2Rank) {
                this.codeword = codeWord;
                this.codewordLength = codewordLength;
                this.symbol = symbol;
                this.symbol2Rank = symbol2Rank;
            }

            @Override
            public long encode(long symbol) {
                return this.codeword[this.symbol2Rank.get(symbol)];
            }

            @Override
            public int codewordLength(long symbol) {
                return this.codewordLength[this.symbol2Rank.get(symbol)];
            }

            @Override
            public int maxCodewordLength() {
                return this.codewordLength[this.codewordLength.length - 1];
            }

            @Override
            public Decoder getDecoder() {
                int size = this.codeword.length;
                int w = this.maxCodewordLength();
                if (w > 62) {
                    throw new IllegalArgumentException("Codeword length must not exceed 62");
                }
                int decodingTableLength = 1;
                if (size > 1) {
                    int i = size - 1;
                    while (i-- != 0) {
                        assert (this.codewordLength[i] <= this.codewordLength[i + 1]);
                        if (this.codewordLength[i] == this.codewordLength[i + 1]) continue;
                        ++decodingTableLength;
                    }
                }
                int[] shift = new int[decodingTableLength];
                int[] howManyUpToBlock = new int[decodingTableLength];
                long[] lastCodeWordPlusOne = new long[decodingTableLength];
                int p = -1;
                int l = -1;
                int prevL = 0;
                long word = 0L;
                for (int i = 0; i < size; ++i) {
                    l = this.codewordLength[i];
                    if (l != prevL) {
                        if (i != 0) {
                            lastCodeWordPlusOne[p] = word << w - prevL;
                            howManyUpToBlock[p] = i;
                        }
                        shift[++p] = w - l;
                        word <<= l - prevL;
                        prevL = l;
                    }
                    ++word;
                }
                if (p != -1) {
                    assert (p == decodingTableLength - 1) : p + " != " + (decodingTableLength - 1);
                    howManyUpToBlock[p] = size;
                    lastCodeWordPlusOne[p] = word << w - l;
                } else {
                    howManyUpToBlock[0] = 1;
                    lastCodeWordPlusOne[0] = 0x3FFFFFFFFFFFFFFFL;
                }
                return new Decoder(lastCodeWordPlusOne, howManyUpToBlock, shift, this.symbol);
            }

            protected static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static final long serialVersionUID = 0L;
                private final long[] lastCodeWordPlusOne;
                private final int[] howManyUpToBlock;
                private final int[] shift;
                private final long[] symbol;

                public Decoder(long[] lastCodeWordPlusOne, int[] howManyUpToBlock, int[] shift, long[] symbol) {
                    this.lastCodeWordPlusOne = lastCodeWordPlusOne;
                    this.howManyUpToBlock = howManyUpToBlock;
                    this.shift = shift;
                    this.symbol = symbol;
                }

                @Override
                public long decode(long value) {
                    long[] lastCodeWordPlusOne = this.lastCodeWordPlusOne;
                    int curr = 0;
                    while (true) {
                        if (value < lastCodeWordPlusOne[curr]) {
                            int s = this.shift[curr];
                            return this.symbol[(int)((value >>> s) - (lastCodeWordPlusOne[curr] >>> s)) + this.howManyUpToBlock[curr]];
                        }
                        ++curr;
                    }
                }

                @Override
                public long numBits() {
                    return 32 * this.shift.length + 32 * this.howManyUpToBlock.length + 64 * this.lastCodeWordPlusOne.length + 64 * this.symbol.length;
                }
            }
        }
    }

    public static class Unary
    implements Codec {
        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            assert (Longs.min((long[])frequencies.values().toLongArray()) > 0L);
            return new Coder((int)Longs.max((long[])frequencies.keySet().toLongArray()) + 1);
        }

        protected static class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private final int maxCodewordLength;

            public Coder(int maxCodewordLength) {
                this.maxCodewordLength = maxCodewordLength;
            }

            @Override
            public long encode(long symbol) {
                return 1L << (int)symbol;
            }

            @Override
            public int codewordLength(long symbol) {
                return (int)symbol + 1;
            }

            @Override
            public int maxCodewordLength() {
                return this.maxCodewordLength;
            }

            @Override
            public Decoder getDecoder() {
                return new Decoder(this.maxCodewordLength);
            }

            protected static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static final long serialVersionUID = 0L;
                private final int maxCodewordLengthMinus64;

                public Decoder(int maxCodewordLength) {
                    this.maxCodewordLengthMinus64 = maxCodewordLength - 64;
                }

                @Override
                public long decode(long value) {
                    return this.maxCodewordLengthMinus64 + Long.numberOfLeadingZeros(value);
                }

                @Override
                public long numBits() {
                    return 32L;
                }
            }
        }
    }

    public static class Gamma
    implements Codec {
        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            assert (Longs.min((long[])frequencies.values().toLongArray()) > 0L);
            return new Coder(Fast.mostSignificantBit((long)(Longs.max((long[])frequencies.keySet().toLongArray()) + 1L)) * 2 + 1);
        }

        protected static class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private final int maxCodewordLength;

            public Coder(int maxCodewordLength) {
                this.maxCodewordLength = maxCodewordLength;
            }

            @Override
            public long encode(long symbol) {
                int msb = Fast.mostSignificantBit((long)(++symbol));
                return Long.reverse(symbol) >>> 63 - 2 * msb;
            }

            @Override
            public int codewordLength(long symbol) {
                return 2 * Fast.mostSignificantBit((long)(symbol + 1L)) + 1;
            }

            @Override
            public int maxCodewordLength() {
                return this.maxCodewordLength;
            }

            @Override
            public Decoder getDecoder() {
                return new Decoder(this.maxCodewordLength);
            }

            protected static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static final long serialVersionUID = 0L;
                private final int maxCodewordLengthMinusOne;

                public Decoder(int maxCodewordLength) {
                    this.maxCodewordLengthMinusOne = maxCodewordLength - 1;
                }

                @Override
                public long decode(long code) {
                    int length = this.maxCodewordLengthMinusOne - 63 + Long.numberOfLeadingZeros(code);
                    return (code >>> this.maxCodewordLengthMinusOne - 2 * length) - 1L;
                }

                @Override
                public long numBits() {
                    return 32L;
                }
            }
        }
    }

    public static class Binary
    implements Codec {
        @Override
        public Coder getCoder(Long2LongMap frequencies) {
            assert (Longs.min((long[])frequencies.values().toLongArray()) > 0L);
            return new Coder(Fast.length((long)Longs.max((long[])frequencies.keySet().toLongArray())));
        }

        protected static class Coder
        implements it.unimi.dsi.sux4j.mph.codec.Codec$Coder {
            private final int codewordLength;

            public Coder(int codewordLength) {
                this.codewordLength = codewordLength;
            }

            @Override
            public long encode(long next) {
                return Long.reverse(next) >>> 64 - this.codewordLength;
            }

            @Override
            public int codewordLength(long symbol) {
                return this.codewordLength;
            }

            @Override
            public int maxCodewordLength() {
                return this.codewordLength;
            }

            @Override
            public Decoder getDecoder() {
                return new Decoder();
            }

            protected static final class Decoder
            implements it.unimi.dsi.sux4j.mph.codec.Codec$Decoder {
                private static final long serialVersionUID = 0L;

                protected Decoder() {
                }

                @Override
                public long decode(long value) {
                    return value;
                }

                @Override
                public long numBits() {
                    return 0L;
                }
            }
        }
    }

    public static interface Decoder
    extends Serializable {
        public long decode(long var1);

        public long numBits();
    }

    public static interface Coder {
        public long encode(long var1);

        public int codewordLength(long var1);

        public int maxCodewordLength();

        public Decoder getDecoder();
    }
}

