/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph.solve;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.codec.Codec;
import it.unimi.dsi.sux4j.mph.solve.Linear3SystemSolver;
import it.unimi.dsi.sux4j.mph.solve.Modulo2System;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Linear4SystemSolver {
    private static final int INITIAL_QUEUE_SIZE = 1024;
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(Linear4SystemSolver.class);
    private final int numVariables;
    private final int numEdges;
    public final int[] edge;
    public final int[] stack;
    private final int[] d;
    private boolean neverUsed;
    private int top;
    private final IntArrayList visitStack;
    private final int[][] edge2Vertex;
    private final boolean[] peeled;
    public long[] solution;
    public int unsolvable;
    public int undirectable;
    public long numPeeled;

    public Linear4SystemSolver(int numVariables, int numEquations) {
        this.numVariables = numVariables;
        this.numEdges = numEquations;
        this.peeled = new boolean[numEquations];
        this.edge = new int[numVariables];
        this.edge2Vertex = new int[4][numEquations];
        this.stack = new int[numEquations];
        this.d = new int[numVariables];
        this.visitStack = new IntArrayList(1024);
        this.neverUsed = true;
    }

    private final void cleanUpIfNecessary() {
        if (!this.neverUsed) {
            Arrays.fill(this.d, 0);
            Arrays.fill(this.edge, 0);
            Arrays.fill(this.peeled, false);
            this.unsolvable = 0;
            this.undirectable = 0;
        }
        this.neverUsed = false;
    }

    private final void xorEdge(int e, int hinge) {
        if (hinge != this.edge2Vertex[0][e]) {
            int n = this.edge2Vertex[0][e];
            this.edge[n] = this.edge[n] ^ e;
        }
        if (hinge != this.edge2Vertex[1][e]) {
            int n = this.edge2Vertex[1][e];
            this.edge[n] = this.edge[n] ^ e;
        }
        if (hinge != this.edge2Vertex[2][e]) {
            int n = this.edge2Vertex[2][e];
            this.edge[n] = this.edge[n] ^ e;
        }
        if (hinge != this.edge2Vertex[3][e]) {
            int n = this.edge2Vertex[3][e];
            this.edge[n] = this.edge[n] ^ e;
        }
    }

    private final void xorEdge(int e) {
        int n = this.edge2Vertex[0][e];
        this.edge[n] = this.edge[n] ^ e;
        int n2 = this.edge2Vertex[1][e];
        this.edge[n2] = this.edge[n2] ^ e;
        int n3 = this.edge2Vertex[2][e];
        this.edge[n3] = this.edge[n3] ^ e;
        int n4 = this.edge2Vertex[3][e];
        this.edge[n4] = this.edge[n4] ^ e;
    }

    public static void tripleToEquation(long[] triple, long seed, int numVariables, int[] e) {
        if (numVariables == 0) {
            e[3] = -1;
            e[2] = -1;
            e[1] = -1;
            e[0] = -1;
            return;
        }
        long[] hash = new long[4];
        Hashes.spooky4(triple, seed, hash);
        int shift = Long.numberOfLeadingZeros(numVariables);
        long mask = (1L << shift) - 1L;
        e[0] = (int)((hash[0] & mask) * (long)numVariables >>> shift);
        e[1] = (int)((hash[1] & mask) * (long)numVariables >>> shift);
        e[2] = (int)((hash[2] & mask) * (long)numVariables >>> shift);
        e[3] = (int)((hash[3] & mask) * (long)numVariables >>> shift);
    }

    public static void bitVectorToEquation(BitVector bv, long seed, int numVariables, int[] e) {
        if (numVariables == 0) {
            e[1] = e[2] = e[3] - 1;
            e[0] = e[2];
            return;
        }
        long[] hash = new long[4];
        Hashes.spooky4(bv, seed, hash);
        int shift = Long.numberOfLeadingZeros(numVariables);
        long mask = (1L << shift) - 1L;
        e[0] = (int)((hash[0] & mask) * (long)numVariables >>> shift);
        e[1] = (int)((hash[1] & mask) * (long)numVariables >>> shift);
        e[2] = (int)((hash[2] & mask) * (long)numVariables >>> shift);
        e[3] = (int)((hash[3] & mask) * (long)numVariables >>> shift);
    }

    private String edge2String(int e) {
        return "<" + this.edge2Vertex[0][e] + "," + this.edge2Vertex[1][e] + "," + this.edge2Vertex[2][e] + "," + this.edge2Vertex[3][e] + ">";
    }

    public boolean generateAndSolve(Iterable<long[]> triples, long seed, LongBigList valueList) {
        int[] d = this.d;
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        int[] edge2Vertex3 = this.edge2Vertex[3];
        this.cleanUpIfNecessary();
        int[] e = new int[4];
        Iterator<long[]> iterator = triples.iterator();
        for (int i = 0; i < this.numEdges; ++i) {
            Linear4SystemSolver.tripleToEquation(iterator.next(), seed, this.numVariables, e);
            edge2Vertex0[i] = e[0];
            d[edge2Vertex0[i]] = d[edge2Vertex0[i]] + 1;
            edge2Vertex1[i] = e[1];
            d[edge2Vertex1[i]] = d[edge2Vertex1[i]] + 1;
            edge2Vertex2[i] = e[2];
            d[edge2Vertex2[i]] = d[edge2Vertex2[i]] + 1;
            edge2Vertex3[i] = e[3];
            d[edge2Vertex3[i]] = d[edge2Vertex3[i]] + 1;
            this.xorEdge(i);
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("This " + Linear4SystemSolver.class.getSimpleName() + " has " + this.numEdges + " edges, but the provided iterator returns more");
        }
        return this.solve(valueList);
    }

    private boolean sort() {
        int[] d = this.d;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Peeling hypergraph (" + this.numVariables + " vertices, " + this.numEdges + " edges)...");
        }
        this.top = 0;
        for (int i = 0; i < this.numVariables; ++i) {
            if (d[i] != 1) continue;
            this.peel(i);
        }
        if (this.top == this.numEdges) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Peeling completed.");
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Peeled " + this.top + " edges out of " + this.numEdges + ".");
        }
        return false;
    }

    private void peel(int x) {
        int[] edge = this.edge;
        int[] stack = this.stack;
        int[] d = this.d;
        IntArrayList visitStack = this.visitStack;
        visitStack.clear();
        visitStack.push(x);
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        int[] edge2Vertex3 = this.edge2Vertex[3];
        while (!visitStack.isEmpty()) {
            int v = visitStack.popInt();
            if (d[v] != 1) continue;
            stack[this.top++] = v;
            int e = edge[v];
            this.peeled[e] = true;
            this.xorEdge(e, v);
            int n = edge2Vertex0[e];
            d[n] = d[n] - 1;
            if (d[n] == 1) {
                visitStack.add(edge2Vertex0[e]);
            }
            int n2 = edge2Vertex1[e];
            d[n2] = d[n2] - 1;
            if (d[n2] == 1) {
                visitStack.add(edge2Vertex1[e]);
            }
            int n3 = edge2Vertex2[e];
            d[n3] = d[n3] - 1;
            if (d[n3] == 1) {
                visitStack.add(edge2Vertex2[e]);
            }
            int n4 = edge2Vertex3[e];
            d[n4] = d[n4] - 1;
            if (d[n4] != 1) continue;
            visitStack.add(edge2Vertex3[e]);
        }
    }

    private boolean solve(LongBigList valueList) {
        boolean peelingCompleted = this.sort();
        this.numPeeled = this.top;
        long[] solution = this.solution = new long[this.numVariables];
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        int[] edge2Vertex3 = this.edge2Vertex[3];
        int[] edge = this.edge;
        int[] d = this.d;
        if (!peelingCompleted) {
            int[][] vertex2Edge = new int[d.length][];
            int i = vertex2Edge.length;
            while (i-- != 0) {
                vertex2Edge[i] = new int[d[i]];
            }
            int[] p = new int[d.length];
            long[] c = new long[d.length - this.top];
            Arrays.fill(d, 0);
            int j = 0;
            for (int i2 = 0; i2 < this.numEdges; ++i2) {
                int v3;
                int v2;
                int v1;
                int v0;
                if (this.peeled[i2]) continue;
                int n = v0 = edge2Vertex0[i2];
                int n2 = p[n];
                p[n] = n2 + 1;
                vertex2Edge[v0][n2] = j;
                int n3 = v1 = edge2Vertex1[i2];
                int n4 = p[n3];
                p[n3] = n4 + 1;
                vertex2Edge[v1][n4] = j;
                int n5 = v2 = edge2Vertex2[i2];
                int n6 = p[n5];
                p[n5] = n6 + 1;
                vertex2Edge[v2][n6] = j;
                int n7 = v3 = edge2Vertex3[i2];
                int n8 = p[n7];
                p[n7] = n8 + 1;
                vertex2Edge[v3][n8] = j;
                c[j++] = valueList.getLong((long)i2);
            }
            if (!Modulo2System.lazyGaussianElimination(vertex2Edge, c, Util.identity((int)this.numVariables), solution)) {
                ++this.unsolvable;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("System is unsolvable");
                }
                return false;
            }
        }
        while (this.top > 0) {
            int x = this.stack[--this.top];
            int e = edge[x];
            solution[x] = valueList.getLong((long)e);
            if (x != edge2Vertex0[e]) {
                int n = x;
                solution[n] = solution[n] ^ solution[edge2Vertex0[e]];
            }
            if (x != edge2Vertex1[e]) {
                int n = x;
                solution[n] = solution[n] ^ solution[edge2Vertex1[e]];
            }
            if (x != edge2Vertex2[e]) {
                int n = x;
                solution[n] = solution[n] ^ solution[edge2Vertex2[e]];
            }
            if (x != edge2Vertex3[e]) {
                int n = x;
                solution[n] = solution[n] ^ solution[edge2Vertex3[e]];
            }
            assert (valueList.getLong((long)e) == (solution[edge2Vertex0[e]] ^ solution[edge2Vertex1[e]] ^ solution[edge2Vertex2[e]] ^ solution[edge2Vertex3[e]])) : this.edge2String(e) + ": " + valueList.getLong((long)e) + " != " + (solution[edge2Vertex0[e]] ^ solution[edge2Vertex1[e]] ^ solution[edge2Vertex2[e]] ^ solution[edge2Vertex2[e]]);
        }
        return true;
    }

    public boolean generateAndSolve(Iterable<long[]> triples, long seed, LongBigList valueList, Codec.Coder coder, int m, int w) {
        int[] d = this.d;
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        int[] edge2Vertex3 = this.edge2Vertex[3];
        this.cleanUpIfNecessary();
        int[] e = new int[4];
        LongArrayBitVector convertedValues = LongArrayBitVector.getInstance();
        int j = 0;
        int i = 0;
        Iterator<long[]> iterator = triples.iterator();
        while (iterator.hasNext()) {
            long[] next = iterator.next();
            long v = valueList.getLong((long)i++);
            long convertedLong = coder.encode(v);
            int lenCodeword = coder.codewordLength(v);
            convertedValues.append(convertedLong, lenCodeword);
            Linear4SystemSolver.tripleToEquation(next, seed, m, e);
            for (int l = 0; l < lenCodeword; ++l) {
                edge2Vertex0[j] = e[0] + w - 1 - l;
                d[edge2Vertex0[j]] = d[edge2Vertex0[j]] + 1;
                edge2Vertex1[j] = e[1] + w - 1 - l;
                d[edge2Vertex1[j]] = d[edge2Vertex1[j]] + 1;
                edge2Vertex2[j] = e[2] + w - 1 - l;
                d[edge2Vertex2[j]] = d[edge2Vertex2[j]] + 1;
                edge2Vertex3[j] = e[3] + w - 1 - l;
                d[edge2Vertex3[j]] = d[edge2Vertex3[j]] + 1;
                this.xorEdge(j++);
            }
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("This " + Linear3SystemSolver.class.getSimpleName() + " has " + this.numEdges + " edges, but the provided iterator returns more");
        }
        return this.solve(convertedValues);
    }

    private boolean solve(LongArrayBitVector codedValues) {
        boolean peelingCompleted = this.sort();
        this.numPeeled = this.top;
        this.solution = new long[this.numVariables];
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        int[] edge2Vertex3 = this.edge2Vertex[3];
        int[] edge = this.edge;
        int[] d = this.d;
        int j = 0;
        if (!peelingCompleted) {
            int[][] vertex2Edge = new int[this.numVariables][];
            Arrays.fill((Object[])vertex2Edge, new int[0]);
            for (int i = 0; i < this.numVariables; ++i) {
                vertex2Edge[i] = new int[d[i]];
            }
            int[] p = new int[this.numVariables];
            long[] c = new long[this.stack.length];
            for (int i = 0; i < this.stack.length; ++i) {
                if (this.peeled[i]) continue;
                int v0 = edge2Vertex0[i];
                int v1 = edge2Vertex1[i];
                int v2 = edge2Vertex2[i];
                int v3 = edge2Vertex3[i];
                int n = v0;
                int n2 = p[n];
                p[n] = n2 + 1;
                vertex2Edge[v0][n2] = j;
                int n3 = v1;
                int n4 = p[n3];
                p[n3] = n4 + 1;
                vertex2Edge[v1][n4] = j;
                int n5 = v2;
                int n6 = p[n5];
                p[n5] = n6 + 1;
                vertex2Edge[v2][n6] = j;
                int n7 = v3;
                int n8 = p[n7];
                p[n7] = n8 + 1;
                vertex2Edge[v3][n8] = j;
                c[j++] = codedValues.getBoolean(i) ? 1L : 0L;
            }
            if (!Modulo2System.lazyGaussianElimination(vertex2Edge, c, Util.identity((int)this.numVariables), this.solution)) {
                ++this.unsolvable;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("System is unsolvable");
                }
                return false;
            }
        }
        while (this.top > 0) {
            int x;
            int e;
            long l = this.solution[x] = codedValues.getBoolean(e = edge[x = this.stack[--this.top]]) ? 1L : 0L;
            if (x != edge2Vertex0[e]) {
                int n = x;
                this.solution[n] = this.solution[n] ^ this.solution[edge2Vertex0[e]];
            }
            if (x != edge2Vertex1[e]) {
                int n = x;
                this.solution[n] = this.solution[n] ^ this.solution[edge2Vertex1[e]];
            }
            if (x != edge2Vertex2[e]) {
                int n = x;
                this.solution[n] = this.solution[n] ^ this.solution[edge2Vertex2[e]];
            }
            if (x != edge2Vertex3[e]) {
                int n = x;
                this.solution[n] = this.solution[n] ^ this.solution[edge2Vertex3[e]];
            }
            assert ((long)(codedValues.getBoolean(e) ? 1 : 0) == (this.solution[edge2Vertex0[e]] ^ this.solution[edge2Vertex1[e]] ^ this.solution[edge2Vertex2[e]] ^ this.solution[edge2Vertex3[e]])) : this.edge2String(e) + ": " + (codedValues.getBoolean(e) ? 1 : 0) + " != " + (this.solution[edge2Vertex0[e]] ^ this.solution[edge2Vertex1[e]] ^ this.solution[edge2Vertex2[e]] ^ this.solution[edge2Vertex2[e]]);
        }
        return true;
    }
}

