/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph.solve;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Modulo3System {
    private static final Logger LOGGER = LoggerFactory.getLogger(Modulo3System.class);
    private static final boolean DEBUG = false;
    private final int numVars;
    private final ArrayList<Modulo3Equation> equations;

    public Modulo3System(int numVars) {
        this.equations = new ArrayList();
        this.numVars = numVars;
    }

    protected Modulo3System(int numVars, ArrayList<Modulo3Equation> system) {
        this.equations = system;
        this.numVars = numVars;
    }

    public Modulo3System copy() {
        ArrayList<Modulo3Equation> list = new ArrayList<Modulo3Equation>(this.equations.size());
        for (Modulo3Equation equation : this.equations) {
            list.add(equation.copy());
        }
        return new Modulo3System(this.numVars, list);
    }

    public void add(Modulo3Equation equation) {
        if (equation.list.size64() != (long)this.numVars) {
            throw new IllegalArgumentException("The number of variables in the equation (" + equation.list.size64() + ") does not match the number of variables of the system (" + this.numVars + ")");
        }
        this.equations.add(equation);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.equations.size(); ++i) {
            b.append(this.equations.get(i)).append('\n');
        }
        return b.toString();
    }

    public boolean check(long[] solution) {
        assert (solution.length == this.numVars);
        LongArrayBitVector solutions = LongArrayBitVector.ofLength((long)(this.numVars * 2));
        LongBigList list = solutions.asLongBigList(2);
        int i = solution.length;
        while (i-- != 0) {
            list.set((long)i, solution[i]);
        }
        return this.check(solutions);
    }

    public boolean check(LongArrayBitVector solutions) {
        assert (solutions.length() == (long)(this.numVars * 2));
        long[] solutionBits = solutions.bits();
        for (Modulo3Equation equation : this.equations) {
            if (equation.c == Modulo3Equation.scalarProduct(equation.bits, solutionBits) % 3) continue;
            return false;
        }
        return true;
    }

    private boolean echelonForm() {
        block0: for (int i = 0; i < this.equations.size() - 1; ++i) {
            assert (this.equations.get((int)i).firstVar != Integer.MAX_VALUE);
            for (int j = i + 1; j < this.equations.size(); ++j) {
                Modulo3Equation eqJ = this.equations.get(j);
                Modulo3Equation eqI = this.equations.get(i);
                assert (eqI.firstVar != Integer.MAX_VALUE);
                assert (eqJ.firstVar != Integer.MAX_VALUE);
                int firstVar = eqI.firstVar;
                if (firstVar == eqJ.firstVar) {
                    eqI.eliminate(firstVar, eqJ);
                    if (eqI.isUnsolvable()) {
                        return false;
                    }
                    if (eqI.isIdentity()) continue block0;
                    eqI.updateFirstVar();
                }
                if (eqI.firstVar <= eqJ.firstVar) continue;
                Collections.swap(this.equations, i, j);
            }
        }
        return true;
    }

    public boolean gaussianElimination(long[] solution) {
        assert (solution.length == this.numVars);
        LongArrayBitVector solutions = LongArrayBitVector.ofLength((long)(this.numVars * 2));
        if (!this.gaussianElimination(solutions)) {
            return false;
        }
        LongBigList list = solutions.asLongBigList(2);
        int i = solution.length;
        while (i-- != 0) {
            solution[i] = list.getLong((long)i);
        }
        return true;
    }

    public boolean gaussianElimination(LongArrayBitVector solution) {
        assert (solution.length() == (long)(this.numVars * 2));
        for (Modulo3Equation equation : this.equations) {
            equation.updateFirstVar();
        }
        if (!this.echelonForm()) {
            return false;
        }
        long[] solutionBits = solution.bits();
        LongBigList solutionList = solution.asLongBigList(2);
        int i = this.equations.size();
        while (i-- != 0) {
            Modulo3Equation equation = this.equations.get(i);
            if (equation.isIdentity()) continue;
            assert (solutionList.getLong((long)equation.firstVar) == 0L) : equation.firstVar;
            int sum = (equation.c - Modulo3Equation.scalarProduct(equation.bits, solutionBits)) % 3;
            if (sum < 0) {
                sum += 3;
            }
            solutionList.set((long)equation.firstVar, sum == 0 ? 0L : (equation.firstCoeff == sum ? 1L : 2L));
        }
        return true;
    }

    public boolean lazyGaussianElimination(long[] solution) {
        int[][] var2Eq = new int[this.numVars][];
        int[] d = new int[this.numVars];
        for (Modulo3Equation equation : this.equations) {
            int v = (int)equation.list.size64();
            while (v-- != 0) {
                if (equation.list.getLong((long)v) == 0L) continue;
                int n = v;
                d[n] = d[n] + 1;
            }
        }
        int v = this.numVars;
        while (v-- != 0) {
            var2Eq[v] = new int[d[v]];
        }
        Arrays.fill(d, 0);
        int[] c = new int[this.equations.size()];
        for (int e = 0; e < this.equations.size(); ++e) {
            c[e] = this.equations.get((int)e).c;
            LongBigList list = this.equations.get((int)e).list;
            int v2 = (int)list.size64();
            while (v2-- != 0) {
                if (list.getLong((long)v2) == 0L) continue;
                int n = v2;
                int n2 = d[n];
                d[n] = n2 + 1;
                var2Eq[v2][n2] = e;
            }
        }
        return Modulo3System.lazyGaussianElimination(this, var2Eq, c, Util.identity((int)this.numVars), solution);
    }

    public static boolean lazyGaussianElimination(int[][] var2Eq, int[] c, int[] variable, long[] solution) {
        return Modulo3System.lazyGaussianElimination(null, var2Eq, c, variable, solution);
    }

    public static boolean lazyGaussianElimination(Modulo3System system, int[][] var2Eq, int[] c, int[] variable, long[] solution) {
        boolean buildSystem;
        int numEquations = c.length;
        if (numEquations == 0) {
            return true;
        }
        int numVars = var2Eq.length;
        assert (solution.length == numVars);
        boolean bl = buildSystem = system == null;
        if (buildSystem) {
            system = new Modulo3System(numVars);
            for (int i = 0; i < c.length; ++i) {
                system.add(new Modulo3Equation(c[i], numVars));
            }
        }
        int[] weight = new int[numVars];
        int[] priority = new int[numEquations];
        for (int v : variable) {
            int[] eq = var2Eq[v];
            if (eq.length == 0) continue;
            int currEq = eq[0];
            int currCoeff = 1;
            int j = 0;
            for (int i = 1; i < eq.length; ++i) {
                if (eq[i] != currEq) {
                    assert (eq[i] > currEq);
                    if ((currCoeff %= 3) != 0) {
                        if (buildSystem) {
                            system.equations.get(currEq).add(v, currCoeff);
                        }
                        int n = v;
                        weight[n] = weight[n] + 1;
                        int n2 = currEq;
                        priority[n2] = priority[n2] + 1;
                        eq[j++] = currEq;
                    }
                    currEq = eq[i];
                    currCoeff = 1;
                    continue;
                }
                ++currCoeff;
            }
            if (currCoeff != 3) {
                if (buildSystem) {
                    system.equations.get(currEq).add(v, currCoeff);
                }
                int n = v;
                weight[n] = weight[n] + 1;
                int n3 = currEq;
                priority[n3] = priority[n3] + 1;
                eq[j++] = currEq;
            }
            if (j == eq.length) continue;
            var2Eq[v] = Arrays.copyOf(var2Eq[v], j);
        }
        int[] u = new int[variable.length];
        int[] count = new int[3 * numEquations + 1];
        int i = variable.length;
        while (i-- != 0) {
            int n = weight[variable[i]];
            count[n] = count[n] + 1;
        }
        for (i = 1; i < count.length; ++i) {
            int n = i;
            count[n] = count[n] + count[i - 1];
        }
        i = variable.length;
        while (i-- != 0) {
            int n = weight[variable[i]];
            int n4 = count[n] - 1;
            count[n] = n4;
            u[n4] = variable[i];
        }
        IntArrayList variables = IntArrayList.wrap((int[])u);
        IntArrayList equationList = new IntArrayList();
        int i2 = priority.length;
        while (i2-- != 0) {
            if (priority[i2] > 1) continue;
            equationList.add(i2);
        }
        ArrayList<Modulo3Equation> dense = new ArrayList<Modulo3Equation>();
        ArrayList<Modulo3Equation> solved = new ArrayList<Modulo3Equation>();
        IntArrayList pivots = new IntArrayList();
        ArrayList<Modulo3Equation> equations = system.equations;
        long[] normalized = new long[equations.get((int)0).bits.length];
        long[] idleNormalized = new long[normalized.length];
        Arrays.fill(idleNormalized, 0x5555555555555555L);
        int numActive = 0;
        int remaining = equations.size();
        while (remaining != 0) {
            if (equationList.isEmpty()) {
                int var;
                while (weight[var = variables.popInt()] == 0) {
                }
                ++numActive;
                int n = var / 32;
                idleNormalized[n] = idleNormalized[n] ^ 1L << var % 32 * 2;
                int[] nArray = var2Eq[var];
                int n5 = nArray.length;
                for (int j = 0; j < n5; ++j) {
                    int equationIndex;
                    int n6 = equationIndex = nArray[j];
                    priority[n6] = priority[n6] - 1;
                    if (priority[n6] != 1) continue;
                    equationList.push(equationIndex);
                }
                continue;
            }
            --remaining;
            int first = equationList.popInt();
            Modulo3Equation equation = equations.get(first);
            if (priority[first] == 0) {
                if (equation.isUnsolvable()) {
                    return false;
                }
                if (equation.isIdentity()) continue;
                dense.add(equation);
                continue;
            }
            if (priority[first] != 1) continue;
            equation.normalized(normalized);
            int wordIndex = 0;
            while ((normalized[wordIndex] & idleNormalized[wordIndex]) == 0L) {
                ++wordIndex;
            }
            int pivot = wordIndex * 32 + Long.numberOfTrailingZeros(normalized[wordIndex] & idleNormalized[wordIndex]) / 2;
            pivots.add(pivot);
            solved.add(equation);
            weight[pivot] = 0;
            for (int equationIndex : var2Eq[pivot]) {
                if (equationIndex == first) continue;
                int n = equationIndex;
                priority[n] = priority[n] - 1;
                if (priority[n] == 1) {
                    equationList.add(equationIndex);
                }
                equations.get(equationIndex).eliminate(pivot, equation);
            }
        }
        LOGGER.debug("Active variables: " + numActive + " (" + Util.format((long)(numActive * 100 / numVars)) + "%)");
        Modulo3System denseSystem = new Modulo3System(numVars, dense);
        LongArrayBitVector solutions = LongArrayBitVector.ofLength((long)(numVars * 2));
        if (!denseSystem.gaussianElimination(solutions)) {
            return false;
        }
        long[] solutionBits = solutions.bits();
        LongBigList solutionList = solutions.asLongBigList(2);
        int i3 = solved.size();
        while (i3-- != 0) {
            Modulo3Equation equation = (Modulo3Equation)solved.get(i3);
            int pivot = pivots.getInt(i3);
            assert (solutionList.getLong((long)pivot) == 0L) : pivot;
            int pivotCoefficient = (int)equation.list.getLong((long)pivot);
            int sum = (equation.c - Modulo3Equation.scalarProduct(equation.bits, solutionBits)) % 3;
            if (sum < 0) {
                sum += 3;
            }
            assert (pivotCoefficient != -1);
            solutionList.set((long)pivot, sum == 0 ? 0L : (pivotCoefficient == sum ? 1L : 2L));
        }
        assert (system.check(solutions));
        for (i3 = 0; i3 < solution.length; ++i3) {
            solution[i3] = solutionList.getLong((long)i3);
        }
        return true;
    }

    protected static class Modulo3Equation {
        protected final LongArrayBitVector bitVector;
        protected final long[] bits;
        protected final LongBigList list;
        protected int c;
        protected int firstVar;
        protected int firstCoeff;
        private boolean isEmpty;

        public Modulo3Equation(int c, int numVars) {
            this.c = c;
            this.bitVector = LongArrayBitVector.ofLength((long)(numVars * 2));
            this.bits = this.bitVector.bits();
            this.list = this.bitVector.asLongBigList(2);
            this.firstVar = Integer.MAX_VALUE;
            this.isEmpty = true;
        }

        protected Modulo3Equation(Modulo3Equation equation) {
            this.c = equation.c;
            this.bitVector = equation.bitVector.copy();
            this.bits = this.bitVector.bits();
            this.list = this.bitVector.asLongBigList(2);
            this.firstVar = equation.firstVar;
            this.firstCoeff = equation.firstCoeff;
            this.isEmpty = equation.isEmpty;
        }

        public Modulo3Equation add(int variable, int coefficient) {
            assert (coefficient % 3 != 0) : coefficient;
            if (this.list.set((long)variable, (long)coefficient) != 0L) {
                throw new IllegalStateException();
            }
            this.isEmpty = false;
            return this;
        }

        public Modulo3Equation add(int variable) {
            return this.add(variable, 1);
        }

        public int[] variables() {
            IntArrayList variables = new IntArrayList();
            int i = 0;
            while ((long)i < this.list.size64()) {
                if (this.list.getLong((long)i) != 0L) {
                    variables.add(i);
                }
                ++i;
            }
            return variables.toIntArray();
        }

        public int[] coefficients() {
            IntArrayList coefficients = new IntArrayList();
            int i = 0;
            while ((long)i < this.list.size64()) {
                int c = (int)this.list.getLong((long)i);
                if (c != 0) {
                    coefficients.add(c);
                }
                ++i;
            }
            return coefficients.toIntArray();
        }

        public Modulo3Equation eliminate(int var, Modulo3Equation equation) {
            assert (this.list.getLong((long)var) != 0L);
            assert (equation.list.getLong((long)var) != 0L);
            int mul = this.list.getLong((long)var) == equation.list.getLong((long)var) ? 1 : 2;
            this.sub(equation, mul);
            return this;
        }

        public void sub(Modulo3Equation equation, int mul) {
            if (mul == 1) {
                this.c = (this.c + 2 * equation.c) % 3;
                this.subMod3(equation.bits);
            } else {
                this.c = (this.c + equation.c) % 3;
                this.addMod3(equation.bits);
            }
        }

        protected static final long addMod3(long x, long y) {
            long xy = x | y;
            long mask = xy << 1 & xy;
            mask |= x & y;
            mask &= 0xAAAAAAAAAAAAAAAAL;
            mask |= mask >>> 1;
            return x + y - mask;
        }

        protected static final long subMod3(long x, long y) {
            long mask = x;
            mask |= (x | (y ^= 0xFFFFFFFFFFFFFFFFL)) << 1 & y;
            mask &= 0xAAAAAAAAAAAAAAAAL;
            mask |= mask >>> 1;
            return x + y - mask;
        }

        private final void addMod3(long[] y) {
            long[] x = this.bits;
            long isNotEmpty = 0L;
            int i = x.length;
            while (i-- != 0) {
                x[i] = Modulo3Equation.addMod3(x[i], y[i]);
                isNotEmpty |= x[i];
            }
            this.isEmpty = isNotEmpty == 0L;
        }

        private final void subMod3(long[] y) {
            long[] x = this.bits;
            long isNotEmpty = 0L;
            int i = x.length;
            while (i-- != 0) {
                x[i] = Modulo3Equation.subMod3(x[i], y[i]);
                isNotEmpty |= x[i];
            }
            this.isEmpty = isNotEmpty == 0L;
        }

        public void updateFirstVar() {
            if (this.isEmpty) {
                this.firstVar = Integer.MAX_VALUE;
            } else {
                int i = -1;
                while (this.bits[++i] == 0L) {
                }
                int lsb = Long.numberOfTrailingZeros(this.bits[i]) / 2;
                this.firstVar = lsb + 32 * i;
                this.firstCoeff = (int)(this.bits[i] >> lsb * 2 & 3L);
            }
        }

        public boolean isUnsolvable() {
            return this.isEmpty && this.c != 0;
        }

        public boolean isIdentity() {
            return this.isEmpty && this.c == 0;
        }

        public int hashCode() {
            return HashCommon.murmurHash3((int)(this.c ^ this.bitVector.hashCode()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Modulo3Equation)) {
                return false;
            }
            Modulo3Equation equation = (Modulo3Equation)o;
            return this.c == equation.c && this.bitVector.equals(equation.bitVector);
        }

        public void normalized(long[] result) {
            long[] bits = this.bits;
            int i = bits.length;
            while (i-- != 0) {
                result[i] = bits[i] & 0x5555555555555555L | (bits[i] & 0xAAAAAAAAAAAAAAAAL) >>> 1;
            }
        }

        public static int scalarProduct(long[] x, long[] y) {
            int sum = 0;
            int i = y.length;
            while (i-- != 0) {
                long high = x[i] & 0xAAAAAAAAAAAAAAAAL;
                long low = x[i] & 0x5555555555555555L;
                long highShift = high >>> 1;
                long t = (y[i] ^ (high | highShift)) & (x[i] | highShift | low << 1);
                sum += Long.bitCount(t & 0xAAAAAAAAAAAAAAAAL) * 2 + Long.bitCount(t & 0x5555555555555555L);
            }
            return sum;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            boolean someNonZero = false;
            int i = 0;
            while ((long)i < this.list.size64()) {
                long coeff = this.list.getLong((long)i);
                if (coeff != 0L) {
                    if (someNonZero) {
                        b.append(" + ");
                    }
                    someNonZero = true;
                    b.append(coeff == 1L ? "x" : "2x").append('_').append(i);
                }
                ++i;
            }
            if (!someNonZero) {
                b.append('0');
            }
            return b.append(" = ").append(this.c).toString();
        }

        public Modulo3Equation copy() {
            return new Modulo3Equation(this);
        }
    }
}

