/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import it.unimi.dsi.webgraph.LazyIntIterator;

public class MaskedIntIterator
implements LazyIntIterator {
    private static final boolean ASSERTS = false;
    private final LazyIntIterator underlying;
    private final int[] mask;
    private final int maskLen;
    private int currMask;
    private int left;

    public MaskedIntIterator(int[] mask, LazyIntIterator underlying) {
        this(mask, mask == null ? 0 : mask.length, underlying);
    }

    public MaskedIntIterator(int[] mask, int maskLen, LazyIntIterator underlying) {
        this.mask = mask;
        this.maskLen = maskLen;
        this.underlying = underlying;
        if (maskLen != 0) {
            this.left = mask[this.currMask++];
            this.advance();
        } else {
            this.left = -1;
        }
    }

    @Override
    public int nextInt() {
        if (this.left == 0) {
            return -1;
        }
        int next = this.underlying.nextInt();
        if (this.left == -1 || next == -1) {
            return next;
        }
        if (this.left > 0) {
            --this.left;
            this.advance();
        }
        return next;
    }

    private void advance() {
        if (this.left == 0 && this.currMask < this.maskLen) {
            this.underlying.skip(this.mask[this.currMask++]);
            this.left = this.currMask < this.maskLen ? this.mask[this.currMask++] : -1;
        }
    }

    @Override
    public int skip(int n) {
        int skipped = 0;
        while (skipped < n && this.left != 0) {
            if (this.left == -1) {
                int result;
                if ((skipped += (result = this.underlying.skip(n - skipped))) >= n) continue;
                break;
            }
            if (n - skipped < this.left) {
                this.underlying.skip(n - skipped);
                this.left -= n - skipped;
                return n;
            }
            this.underlying.skip(this.left);
            skipped += this.left;
            this.left = 0;
            this.advance();
        }
        return skipped;
    }
}

