/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import it.unimi.dsi.webgraph.AbstractLazyIntIterator;
import it.unimi.dsi.webgraph.BVGraph;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntIterators;
import it.unimi.dsi.webgraph.NodeIterator;
import it.unimi.dsi.webgraph.UnionImmutableGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledImmutableSequentialGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.webgraph.labelling.BitStreamArcLabelledImmutableGraph;
import it.unimi.dsi.webgraph.labelling.Label;
import it.unimi.dsi.webgraph.labelling.LabelMergeStrategy;
import it.unimi.dsi.webgraph.labelling.LabelSemiring;
import it.unimi.dsi.webgraph.labelling.Labels;
import it.unimi.dsi.webgraph.labelling.UnionArcLabelledImmutableGraph;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transform {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transform.class);
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    public static final NoLoops NO_LOOPS = new NoLoops();

    private Transform() {
    }

    public static ImmutableGraph filterArcs(ImmutableGraph graph, ArcFilter filter) {
        return new FilteredImmutableGraph(filter, graph);
    }

    public static ImmutableGraph filterArcs(ImmutableGraph graph, ArcFilter filter, ProgressLogger ignored) {
        return Transform.filterArcs(graph, filter);
    }

    public static ArcLabelledImmutableGraph filterArcs(ArcLabelledImmutableGraph graph, LabelledArcFilter filter) {
        return new FilteredArcLabelledImmutableGraph(filter, graph);
    }

    public static ArcLabelledImmutableGraph filterArcs(ArcLabelledImmutableGraph graph, LabelledArcFilter filter, ProgressLogger ignored) {
        return Transform.filterArcs(graph, filter);
    }

    public static ImmutableGraph map(ImmutableGraph g, int[] map, ProgressLogger pl) {
        boolean isInjective;
        int k;
        boolean notEnlarged;
        int i;
        if (!g.randomAccess()) {
            throw new IllegalArgumentException("Graph mapping requires random access");
        }
        int sourceNumNodes = g.numNodes();
        if (map.length != sourceNumNodes) {
            throw new IllegalArgumentException("The graph to be mapped has " + sourceNumNodes + " whereas the map contains " + map.length + " entries");
        }
        int max = -1;
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.start((CharSequence)"Storing identity...");
        }
        int j = 0;
        for (i = 0; i < sourceNumNodes; ++i) {
            if (map[i] < 0) continue;
            ++j;
        }
        int remappedNodes = j;
        boolean everywhereDefined = remappedNodes == sourceNumNodes;
        int[] pseudoInverse = new int[remappedNodes];
        j = 0;
        for (i = 0; i < sourceNumNodes; ++i) {
            if (max < map[i]) {
                max = map[i];
            }
            if (map[i] < 0) continue;
            pseudoInverse[j++] = i;
        }
        int destNumNodes = max + 1;
        boolean bl = notEnlarged = destNumNodes <= sourceNumNodes;
        if (pl != null) {
            pl.count = remappedNodes;
            pl.done();
        }
        if (pl != null) {
            pl.start((CharSequence)"Sorting to obtain pseudoinverse...");
        }
        IntArrays.radixSortIndirect((int[])pseudoInverse, (int[])map, (int)0, (int)remappedNodes, (boolean)false);
        if (pl != null) {
            pl.count = sourceNumNodes;
            pl.done();
        }
        if (pl != null) {
            pl.start((CharSequence)"Checking whether it is injective...");
        }
        if ((k = remappedNodes - 1) >= 0) {
            while (k-- != 0 && map[pseudoInverse[k]] != map[pseudoInverse[k + 1]]) {
            }
        }
        boolean bl2 = isInjective = k == -1;
        if (pl != null) {
            pl.count = sourceNumNodes;
            pl.stop((CharSequence)("(It is" + (isInjective ? "" : " not") + " injective.)"));
            pl.done();
        }
        boolean isPermutation = isInjective && everywhereDefined && notEnlarged;
        return new RemappedImmutableGraph(map, g, isInjective, isPermutation, remappedNodes, destNumNodes, pseudoInverse);
    }

    public static ImmutableGraph map(ImmutableGraph g, int[] f) {
        return Transform.map(g, f, null);
    }

    public static ImmutableGraph symmetrizeOffline(ImmutableGraph g, int batchSize) throws IOException {
        return Transform.symmetrizeOffline(g, batchSize, null, null);
    }

    public static ImmutableGraph symmetrizeOffline(ImmutableGraph g, int batchSize, File tempDir) throws IOException {
        return Transform.symmetrizeOffline(g, batchSize, tempDir, null);
    }

    public static ImmutableGraph symmetrizeOffline(ImmutableGraph g, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        return Transform.union(g, Transform.transposeOffline(g, batchSize, tempDir, pl));
    }

    public static ImmutableGraph symmetrize(ImmutableGraph g, ImmutableGraph t, ProgressLogger pl) {
        return t == null ? Transform.union(g, Transform.transpose(g, pl)) : Transform.union(g, t);
    }

    public static ImmutableGraph symmetrize(ImmutableGraph g, ImmutableGraph t) {
        return Transform.symmetrize(g, t, null);
    }

    public static ImmutableGraph symmetrize(ImmutableGraph g, ProgressLogger pl) {
        return Transform.symmetrize(g, null, pl);
    }

    public static ImmutableGraph symmetrize(ImmutableGraph g) {
        return Transform.symmetrize(g, null, null);
    }

    public static ImmutableGraph transpose(ImmutableGraph g, ProgressLogger pl) {
        int[] a;
        int d;
        final int n = g.numNodes();
        int[] numPred = new int[n];
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Counting predecessors...");
        }
        NodeIterator nodeIterator = g.nodeIterator();
        long m = 0L;
        int i = n;
        while (i-- != 0) {
            nodeIterator.nextInt();
            d = nodeIterator.outdegree();
            a = nodeIterator.successorArray();
            m += (long)d;
            while (d-- != 0) {
                int n2 = a[d];
                numPred[n2] = numPred[n2] + 1;
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
        final int[][] pred = new int[n][];
        if (pl != null) {
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Allocating memory for predecessors...");
        }
        i = n;
        while (i-- != 0) {
            if (numPred[i] != 0) {
                pred[i] = new int[numPred[i]];
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
        java.util.Arrays.fill(numPred, 0);
        if (pl != null) {
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Computing predecessors...");
        }
        nodeIterator = g.nodeIterator();
        i = n;
        while (i-- != 0) {
            int j = nodeIterator.nextInt();
            d = nodeIterator.outdegree();
            a = nodeIterator.successorArray();
            while (d-- != 0) {
                int n3 = a[d];
                int n4 = numPred[n3];
                numPred[n3] = n4 + 1;
                pred[a[d]][n4] = j;
            }
            if (pl == null) continue;
            pl.update();
        }
        if (pl != null) {
            pl.done();
        }
        if (pl != null) {
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Sorting predecessors...");
        }
        i = n;
        while (i-- != 0) {
            if (pred[i] != null) {
                java.util.Arrays.sort(pred[i]);
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
        final long numArcs = m;
        return new ImmutableGraph(){

            @Override
            public int numNodes() {
                return n;
            }

            @Override
            public long numArcs() {
                return numArcs;
            }

            @Override
            public ImmutableGraph copy() {
                return this;
            }

            @Override
            public boolean randomAccess() {
                return true;
            }

            @Override
            public int[] successorArray(int x) {
                return pred[x] != null ? pred[x] : IntArrays.EMPTY_ARRAY;
            }

            @Override
            public int outdegree(int x) {
                return this.successorArray(x).length;
            }
        };
    }

    public static int processBatch(int n, int[] source, int[] target, File tempDir, List<File> batches) throws IOException {
        IntArrays.parallelQuickSort((int[])source, (int[])target, (int)0, (int)n);
        File batchFile = File.createTempFile("batch", ".bitstream", tempDir);
        batchFile.deleteOnExit();
        batches.add(batchFile);
        OutputBitStream batch = new OutputBitStream(batchFile);
        int u = 0;
        if (n != 0) {
            u = 1;
            int i = n - 1;
            while (i-- != 0) {
                if (source[i] == source[i + 1] && target[i] == target[i + 1]) continue;
                ++u;
            }
            batch.writeDelta(u);
            int prevSource = source[0];
            batch.writeDelta(prevSource);
            batch.writeDelta(target[0]);
            for (int i2 = 1; i2 < n; ++i2) {
                if (source[i2] != prevSource) {
                    batch.writeDelta(source[i2] - prevSource);
                    batch.writeDelta(target[i2]);
                    prevSource = source[i2];
                    continue;
                }
                if (target[i2] == target[i2 - 1]) continue;
                batch.writeDelta(0);
                batch.writeDelta(target[i2] - target[i2 - 1] - 1);
            }
        } else {
            batch.writeDelta(0);
        }
        batch.close();
        return u;
    }

    private static void processTransposeBatch(int n, int[] source, int[] target, long[] start, InputBitStream labelBitStream, File tempDir, List<File> batches, List<File> labelBatches, Label prototype) throws IOException {
        Arrays.quickSort((int)0, (int)n, (x, y) -> {
            int t = source[x] - source[y];
            if (t != 0) {
                return t;
            }
            return target[x] - target[y];
        }, (x, y) -> {
            int t = source[x];
            source[x] = source[y];
            source[y] = t;
            t = target[x];
            target[x] = target[y];
            target[y] = t;
            long u = start[x];
            start[x] = start[y];
            start[y] = u;
        });
        File batchFile = File.createTempFile("batch", ".bitstream", tempDir);
        batchFile.deleteOnExit();
        batches.add(batchFile);
        OutputBitStream batch = new OutputBitStream(batchFile);
        if (n != 0) {
            batch.writeDelta(n);
            int prevSource = source[0];
            batch.writeDelta(prevSource);
            batch.writeDelta(target[0]);
            for (int i = 1; i < n; ++i) {
                if (source[i] != prevSource) {
                    batch.writeDelta(source[i] - prevSource);
                    batch.writeDelta(target[i]);
                    prevSource = source[i];
                    continue;
                }
                if (target[i] == target[i - 1]) continue;
                batch.writeDelta(0);
                batch.writeDelta(target[i] - target[i - 1] - 1);
            }
        } else {
            batch.writeDelta(0);
        }
        batch.close();
        File labelFile = File.createTempFile("label-", ".bits", tempDir);
        labelFile.deleteOnExit();
        labelBatches.add(labelFile);
        OutputBitStream labelObs = new OutputBitStream(labelFile);
        for (int i = 0; i < n; ++i) {
            labelBitStream.position(start[i]);
            prototype.fromBitStream(labelBitStream, source[i]);
            prototype.toBitStream(labelObs, target[i]);
        }
        labelObs.close();
    }

    public static ImmutableSequentialGraph transposeOffline(ImmutableGraph g, int batchSize) throws IOException {
        return Transform.transposeOffline(g, batchSize, null);
    }

    public static ImmutableSequentialGraph transposeOffline(ImmutableGraph g, int batchSize, File tempDir) throws IOException {
        return Transform.transposeOffline(g, batchSize, tempDir, null);
    }

    public static ImmutableSequentialGraph transposeOffline(ImmutableGraph g, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        int[] source = new int[batchSize];
        int[] target = new int[batchSize];
        ObjectArrayList batches = new ObjectArrayList();
        int n = g.numNodes();
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Creating sorted batches...");
        }
        NodeIterator nodeIterator = g.nodeIterator();
        long m = 0L;
        int j = 0;
        long i = n;
        while (i-- != 0L) {
            int currNode = nodeIterator.nextInt();
            int d = nodeIterator.outdegree();
            int[] succ = nodeIterator.successorArray();
            m += (long)d;
            for (int k = 0; k < d; ++k) {
                target[j] = currNode;
                source[j++] = succ[k];
                if (j != batchSize) continue;
                Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                j = 0;
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (j != 0) {
            Transform.processBatch(j, source, target, tempDir, (List<File>)batches);
        }
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, m, pl);
        }
        return new BatchGraph(n, m, (ObjectArrayList<File>)batches);
    }

    protected static void logBatches(ObjectArrayList<File> batches, long pairs, ProgressLogger pl) {
        long length = 0L;
        for (File f : batches) {
            length += f.length();
        }
        pl.logger().info("Created " + batches.size() + " batches using " + Util.format((double)(8.0 * (double)length / (double)pairs)) + " bits/arc.");
    }

    public static ImmutableSequentialGraph mapOffline(ImmutableGraph g, int[] map, int batchSize) throws IOException {
        return Transform.mapOffline(g, map, batchSize, null);
    }

    public static ImmutableSequentialGraph mapOffline(ImmutableGraph g, int[] map, int batchSize, File tempDir) throws IOException {
        return Transform.mapOffline(g, map, batchSize, tempDir, null);
    }

    public static ImmutableSequentialGraph mapOffline(ImmutableGraph g, int[] map, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        int[] source = new int[batchSize];
        int[] target = new int[batchSize];
        ObjectArrayList batches = new ObjectArrayList();
        int max = -1;
        for (int x : map) {
            if (max >= x) continue;
            max = x;
        }
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = g.numNodes();
            pl.start((CharSequence)"Creating sorted batches...");
        }
        NodeIterator nodeIterator = g.nodeIterator();
        int j = 0;
        long pairs = 0L;
        long i = g.numNodes();
        while (i-- != 0L) {
            int currNode = nodeIterator.nextInt();
            if (map[currNode] != -1) {
                int d = nodeIterator.outdegree();
                int[] succ = nodeIterator.successorArray();
                for (int k = 0; k < d; ++k) {
                    if (map[succ[k]] == -1) continue;
                    source[j] = map[currNode];
                    target[j++] = map[succ[k]];
                    if (j != batchSize) continue;
                    pairs += (long)Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                    j = 0;
                }
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (g.numNodes() != map.length) {
            throw new IllegalArgumentException("Mismatch between number of nodes (" + g.numNodes() + ") and map length (" + map.length + ")");
        }
        if (j != 0) {
            pairs += (long)Transform.processBatch(j, source, target, tempDir, (List<File>)batches);
        }
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, pairs, pl);
        }
        return new BatchGraph(max + 1, -1L, (ObjectArrayList<File>)batches);
    }

    public static ArcLabelledImmutableGraph transposeOffline(ArcLabelledImmutableGraph g, int batchSize) throws IOException {
        return Transform.transposeOffline(g, batchSize, null);
    }

    public static ArcLabelledImmutableGraph transposeOffline(ArcLabelledImmutableGraph g, int batchSize, File tempDir) throws IOException {
        return Transform.transposeOffline(g, batchSize, tempDir, null);
    }

    public static ArcLabelledImmutableGraph transposeOffline(ArcLabelledImmutableGraph g, int batchSize, File tempDir, ProgressLogger pl) throws IOException {
        int[] source = new int[batchSize];
        int[] target = new int[batchSize];
        long[] start = new long[batchSize];
        FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
        OutputBitStream obs = new OutputBitStream((OutputStream)fbos);
        final ObjectArrayList batches = new ObjectArrayList();
        final ObjectArrayList labelBatches = new ObjectArrayList();
        final Label prototype = g.prototype().copy();
        final int n = g.numNodes();
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Creating sorted batches...");
        }
        ArcLabelledNodeIterator nodeIterator = g.nodeIterator();
        Label[] label = null;
        long m = 0L;
        int j = 0;
        int i = n;
        while (i-- != 0) {
            int currNode = nodeIterator.nextInt();
            int d = nodeIterator.outdegree();
            int[] succ = nodeIterator.successorArray();
            label = nodeIterator.labelArray();
            m += (long)d;
            for (int k = 0; k < d; ++k) {
                source[j] = succ[k];
                target[j] = currNode;
                start[j] = obs.writtenBits();
                label[k].toBitStream(obs, currNode);
                if (++j != batchSize) continue;
                obs.flush();
                Transform.processTransposeBatch(batchSize, source, target, start, new InputBitStream(fbos.array), tempDir, (List<File>)batches, (List<File>)labelBatches, prototype);
                fbos = new FastByteArrayOutputStream();
                obs = new OutputBitStream((OutputStream)fbos);
                j = 0;
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (j != 0) {
            obs.flush();
            Transform.processTransposeBatch(j, source, target, start, new InputBitStream(fbos.array), tempDir, (List<File>)batches, (List<File>)labelBatches, prototype);
        }
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, m, pl);
        }
        final long numArcs = m;
        return new ArcLabelledImmutableSequentialGraph(){

            @Override
            public int numNodes() {
                return n;
            }

            @Override
            public long numArcs() {
                return numArcs;
            }

            @Override
            public boolean hasCopiableIterators() {
                return true;
            }

            @Override
            public ArcLabelledNodeIterator nodeIterator() {
                try {
                    return new InternalArcLabelledNodeIterator(Integer.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            protected void finalize() throws Throwable {
                try {
                    for (File f : batches) {
                        f.delete();
                    }
                    for (File f : labelBatches) {
                        f.delete();
                    }
                }
                finally {
                    super.finalize();
                }
            }

            @Override
            public Label prototype() {
                return prototype;
            }

            class InternalArcLabelledNodeIterator
            extends ArcLabelledNodeIterator {
                private static final int STD_BUFFER_SIZE = 65536;
                private final int[] refArray;
                private final InputBitStream[] batchIbs;
                private final InputBitStream[] labelInputBitStream;
                private final int[] inputStreamLength;
                private final int[] prevTarget;
                private final IntHeapSemiIndirectPriorityQueue queue;
                private final int upperBound;
                private int last;
                private int outdegree;
                private int[] successor;
                private Label[] label;

                public InternalArcLabelledNodeIterator(int upperBound) throws IOException {
                    this(upperBound, null, null, null, null, null, -1, 0, IntArrays.EMPTY_ARRAY, new Label[0]);
                }

                public InternalArcLabelledNodeIterator(int upperBound, InputBitStream[] baseIbs, InputBitStream[] baseLabelInputBitStream, int[] refArray, int[] prevTarget, int[] inputStreamLength, int last, int outdegree, int[] successor, Label[] label) throws IOException {
                    this.upperBound = Math.min(n, upperBound);
                    this.last = last;
                    this.outdegree = outdegree;
                    this.successor = successor;
                    this.label = label;
                    this.batchIbs = new InputBitStream[batches.size()];
                    this.labelInputBitStream = new InputBitStream[batches.size()];
                    if (refArray == null) {
                        this.refArray = new int[batches.size()];
                        this.prevTarget = new int[batches.size()];
                        this.inputStreamLength = new int[batches.size()];
                        java.util.Arrays.fill(this.prevTarget, -1);
                        this.queue = new IntHeapSemiIndirectPriorityQueue(this.refArray);
                        for (int i = 0; i < batches.size(); ++i) {
                            this.batchIbs[i] = new InputBitStream((File)batches.get(i), 65536);
                            this.labelInputBitStream[i] = new InputBitStream((File)labelBatches.get(i), 65536);
                            this.inputStreamLength[i] = this.batchIbs[i].readDelta();
                            this.refArray[i] = this.batchIbs[i].readDelta();
                            this.queue.enqueue(i);
                        }
                    } else {
                        this.refArray = refArray;
                        this.prevTarget = prevTarget;
                        this.inputStreamLength = inputStreamLength;
                        this.queue = new IntHeapSemiIndirectPriorityQueue(refArray);
                        for (int i = 0; i < refArray.length; ++i) {
                            if (baseIbs[i] == null) continue;
                            this.batchIbs[i] = new InputBitStream((File)batches.get(i), 65536);
                            this.batchIbs[i].position(baseIbs[i].position());
                            this.labelInputBitStream[i] = new InputBitStream((File)labelBatches.get(i), 65536);
                            this.labelInputBitStream[i].position(baseLabelInputBitStream[i].position());
                            this.queue.enqueue(i);
                        }
                    }
                }

                @Override
                public int outdegree() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    return this.outdegree;
                }

                public boolean hasNext() {
                    return this.last < Math.min(n - 1, this.upperBound - 1);
                }

                public int nextInt() {
                    ++this.last;
                    int d = 0;
                    try {
                        int i;
                        while (!this.queue.isEmpty() && this.refArray[i = this.queue.first()] == this.last) {
                            this.successor = IntArrays.grow((int[])this.successor, (int)(d + 1));
                            int n = i;
                            int n2 = this.prevTarget[n] + (this.batchIbs[i].readDelta() + 1);
                            this.prevTarget[n] = n2;
                            this.successor[d] = n2;
                            this.label = (Label[])ObjectArrays.grow((Object[])this.label, (int)(d + 1));
                            this.label[d] = prototype.copy();
                            this.label[d].fromBitStream(this.labelInputBitStream[i], this.last);
                            int n3 = i;
                            this.inputStreamLength[n3] = this.inputStreamLength[n3] - 1;
                            if (this.inputStreamLength[n3] == 0) {
                                this.queue.dequeue();
                                this.batchIbs[i].close();
                                this.labelInputBitStream[i].close();
                                this.batchIbs[i] = null;
                                this.labelInputBitStream[i] = null;
                            } else {
                                int sourceDelta = this.batchIbs[i].readDelta();
                                if (sourceDelta != 0) {
                                    int n4 = i;
                                    this.refArray[n4] = this.refArray[n4] + sourceDelta;
                                    this.prevTarget[i] = -1;
                                    this.queue.changed();
                                }
                            }
                            ++d;
                        }
                        Arrays.quickSort((int)0, (int)d, (x, y) -> this.successor[x] - this.successor[y], (x, y) -> {
                            int t = this.successor[x];
                            this.successor[x] = this.successor[y];
                            this.successor[y] = t;
                            Label l = this.label[x];
                            this.label[x] = this.label[y];
                            this.label[y] = l;
                        });
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.outdegree = d;
                    return this.last;
                }

                @Override
                public int[] successorArray() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    return this.successor;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void finalize() throws Throwable {
                    try {
                        for (InputBitStream ibs : this.batchIbs) {
                            if (ibs == null) continue;
                            ibs.close();
                        }
                        for (InputBitStream ibs : this.labelInputBitStream) {
                            if (ibs == null) continue;
                            ibs.close();
                        }
                    }
                    finally {
                        super.finalize();
                    }
                }

                @Override
                public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    return new ArcLabelledNodeIterator.LabelledArcIterator(){
                        int last = -1;

                        @Override
                        public Label label() {
                            return InternalArcLabelledNodeIterator.this.label[this.last];
                        }

                        @Override
                        public int nextInt() {
                            if (this.last + 1 == InternalArcLabelledNodeIterator.this.outdegree) {
                                return -1;
                            }
                            return InternalArcLabelledNodeIterator.this.successor[++this.last];
                        }

                        @Override
                        public int skip(int k) {
                            int toSkip = Math.min(k, InternalArcLabelledNodeIterator.this.outdegree - this.last - 1);
                            this.last += toSkip;
                            return toSkip;
                        }
                    };
                }

                @Override
                public ArcLabelledNodeIterator copy(int upperBound) {
                    try {
                        if (this.last == -1) {
                            return new InternalArcLabelledNodeIterator(upperBound);
                        }
                        return new InternalArcLabelledNodeIterator(upperBound, this.batchIbs, this.labelInputBitStream, (int[])this.refArray.clone(), (int[])this.prevTarget.clone(), (int[])this.inputStreamLength.clone(), this.last, this.outdegree, java.util.Arrays.copyOf(this.successor, this.outdegree), java.util.Arrays.copyOf(this.label, this.outdegree));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
    }

    public static ImmutableGraph transpose(ImmutableGraph g) {
        return Transform.transpose(g, null);
    }

    public static ArcLabelledImmutableGraph union(ArcLabelledImmutableGraph g0, ArcLabelledImmutableGraph g1, LabelMergeStrategy labelMergeStrategy) {
        return new UnionArcLabelledImmutableGraph(g0, g1, labelMergeStrategy == null ? Labels.KEEP_FIRST_MERGE_STRATEGY : labelMergeStrategy);
    }

    public static ImmutableGraph union(ImmutableGraph g0, ImmutableGraph g1) {
        return g0 instanceof ArcLabelledImmutableGraph && g1 instanceof ArcLabelledImmutableGraph ? Transform.union((ArcLabelledImmutableGraph)g0, (ArcLabelledImmutableGraph)g1, null) : new UnionImmutableGraph(g0, g1);
    }

    public static ImmutableGraph compose(ImmutableGraph g0, ImmutableGraph g1) {
        return new ComposedGraph(g0, g1);
    }

    public static ArcLabelledImmutableGraph compose(final ArcLabelledImmutableGraph g0, final ArcLabelledImmutableGraph g1, final LabelSemiring strategy) {
        if (g0.prototype().getClass() != g1.prototype().getClass()) {
            throw new IllegalArgumentException("The two graphs have different label classes (" + g0.prototype().getClass().getSimpleName() + ", " + g1.prototype().getClass().getSimpleName() + ")");
        }
        return new ArcLabelledImmutableSequentialGraph(){

            @Override
            public Label prototype() {
                return g0.prototype();
            }

            @Override
            public int numNodes() {
                return Math.max(g0.numNodes(), g1.numNodes());
            }

            @Override
            public boolean hasCopiableIterators() {
                return g0.hasCopiableIterators() && g1.hasCopiableIterators();
            }

            @Override
            public ArcLabelledNodeIterator nodeIterator() {
                return new InternalArcLabelledNodeIterator(Integer.MAX_VALUE);
            }

            class InternalArcLabelledNodeIterator
            extends ArcLabelledNodeIterator {
                private final int upperBound;
                private int next = 0;
                private int[] succ = IntArrays.EMPTY_ARRAY;
                private Label[] label = new Label[0];
                private int maxOutDegree;
                private int smallCount;
                private Int2ObjectOpenHashMap<Label> successors = new Int2ObjectOpenHashMap(16, 0.5f);
                private int outdegree = -1;
                private ArcLabelledNodeIterator it0;

                public InternalArcLabelledNodeIterator(int upperBond) {
                    this.successors.defaultReturnValue((Object)strategy.zero());
                    this.it0 = g0.nodeIterator();
                    this.upperBound = upperBond;
                }

                public int nextInt() {
                    this.outdegree = -1;
                    int result = this.it0.nextInt();
                    assert (result == this.next);
                    ++this.next;
                    return result;
                }

                public boolean hasNext() {
                    return this.next < this.upperBound && this.it0.hasNext();
                }

                @Override
                public int outdegree() {
                    if (this.outdegree < 0) {
                        this.successorArray();
                    }
                    return this.outdegree;
                }

                private void ensureCache() {
                    if (this.outdegree < 0) {
                        int i;
                        int d = this.it0.outdegree();
                        ArcLabelledNodeIterator.LabelledArcIterator s = this.it0.successors();
                        if (this.successors.size() < this.maxOutDegree / 2 && this.smallCount++ > 100) {
                            this.smallCount = 0;
                            this.maxOutDegree = 0;
                            this.successors = new Int2ObjectOpenHashMap(16, 0.5f);
                            this.successors.defaultReturnValue((Object)strategy.zero());
                        } else {
                            this.successors.clear();
                        }
                        for (i = 0; i < d; ++i) {
                            int x;
                            ArcLabelledNodeIterator.LabelledArcIterator s1 = g1.successors(s.nextInt());
                            while ((x = s1.nextInt()) >= 0) {
                                this.successors.put(x, (Object)strategy.add(strategy.multiply(s.label(), s1.label()), (Label)this.successors.get(x)));
                            }
                        }
                        this.outdegree = this.successors.size();
                        this.succ = IntArrays.ensureCapacity((int[])this.succ, (int)this.outdegree, (int)0);
                        this.label = (Label[])ObjectArrays.ensureCapacity((Object[])this.label, (int)this.outdegree, (int)0);
                        this.successors.keySet().toArray(this.succ);
                        IntArrays.quickSort((int[])this.succ, (int)0, (int)this.outdegree);
                        i = this.outdegree;
                        while (i-- != 0) {
                            this.label[i] = (Label)this.successors.get(this.succ[i]);
                        }
                        if (this.outdegree > this.maxOutDegree) {
                            this.maxOutDegree = this.outdegree;
                        }
                    }
                }

                @Override
                public int[] successorArray() {
                    this.ensureCache();
                    return this.succ;
                }

                @Override
                public Label[] labelArray() {
                    this.ensureCache();
                    return this.label;
                }

                @Override
                public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                    this.ensureCache();
                    return new ArcLabelledNodeIterator.LabelledArcIterator(){
                        int i = -1;

                        @Override
                        public Label label() {
                            return InternalArcLabelledNodeIterator.this.label[this.i];
                        }

                        @Override
                        public int nextInt() {
                            return this.i < InternalArcLabelledNodeIterator.this.outdegree - 1 ? InternalArcLabelledNodeIterator.this.succ[++this.i] : -1;
                        }

                        @Override
                        public int skip(int n) {
                            int incr = Math.min(n, InternalArcLabelledNodeIterator.this.outdegree - this.i - 1);
                            this.i += incr;
                            return incr;
                        }
                    };
                }

                @Override
                public ArcLabelledNodeIterator copy(int upperBound) {
                    InternalArcLabelledNodeIterator result = new InternalArcLabelledNodeIterator(upperBound);
                    result.it0 = this.it0.copy(upperBound);
                    result.next = this.next;
                    result.succ = java.util.Arrays.copyOf(this.succ, this.succ.length);
                    result.label = java.util.Arrays.copyOf(this.label, this.label.length);
                    result.maxOutDegree = this.maxOutDegree;
                    result.smallCount = this.smallCount;
                    result.successors = new Int2ObjectOpenHashMap(this.successors);
                    result.successors.defaultReturnValue(this.successors.defaultReturnValue());
                    result.outdegree = this.outdegree;
                    return result;
                }
            }
        };
    }

    public static ImmutableSequentialGraph line(ImmutableGraph g, String mapBasename, File tempDir, int batchSize, ProgressLogger pl) throws IOException {
        int i;
        int[] succ;
        int d;
        int x;
        int n = g.numNodes();
        int[] source = new int[batchSize];
        int[] target = new int[batchSize];
        int currBatch = 0;
        int pairs = 0;
        ObjectArrayList batches = new ObjectArrayList();
        long[] edge = new long[(int)g.numArcs()];
        int edgesSoFar = 0;
        NodeIterator nodeIterator = g.nodeIterator();
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = n;
            pl.start((CharSequence)"Producing batches for line graph");
        }
        long expNumberOfArcs = 0L;
        while (nodeIterator.hasNext()) {
            x = nodeIterator.nextInt();
            d = nodeIterator.outdegree();
            expNumberOfArcs += (long)(d * d);
            succ = nodeIterator.successorArray();
            for (i = 0; i < d; ++i) {
                if (succ[i] == x) {
                    throw new IllegalArgumentException("The graph contains a loop on node " + x);
                }
                edge[edgesSoFar++] = (long)x << 32 | (long)succ[i];
            }
        }
        LOGGER.info("Expected number of arcs: " + expNumberOfArcs);
        LongArrays.parallelQuickSort((long[])edge);
        nodeIterator = g.nodeIterator();
        while (nodeIterator.hasNext()) {
            x = nodeIterator.nextInt();
            d = nodeIterator.outdegree();
            succ = (int[])nodeIterator.successorArray().clone();
            for (i = 0; i < d; ++i) {
                int from0 = x;
                int to0 = succ[i];
                int edge0 = LongArrays.binarySearch((long[])edge, (int)0, (int)edgesSoFar, (long)((long)from0 << 32 | (long)to0));
                int dNext = g.outdegree(to0);
                int[] succNext = g.successorArray(to0);
                for (int j = 0; j < dNext; ++j) {
                    int from1 = to0;
                    int to1 = succNext[j];
                    int edge1 = LongArrays.binarySearch((long[])edge, (int)0, (int)edgesSoFar, (long)((long)from1 << 32 | (long)to1));
                    if (currBatch == batchSize) {
                        pairs += Transform.processBatch(batchSize, source, target, tempDir, (List<File>)batches);
                        currBatch = 0;
                    }
                    source[currBatch] = edge0;
                    target[currBatch++] = edge1;
                }
            }
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (currBatch > 0) {
            pairs += Transform.processBatch(currBatch, source, target, tempDir, (List<File>)batches);
            currBatch = 0;
        }
        if (edgesSoFar != edge.length) {
            throw new IllegalArgumentException("Something went wrong (probably the graph was not symmetric)");
        }
        DataOutputStream dosSource = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(mapBasename + ".source")));
        DataOutputStream dosTarget = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(mapBasename + ".target")));
        for (long e : edge) {
            dosSource.writeInt((int)(e >> 32));
            dosTarget.writeInt((int)(e & 0xFFFFFFFFFFFFFFFFL));
        }
        dosSource.close();
        dosTarget.close();
        if (pl != null) {
            pl.done();
            Transform.logBatches((ObjectArrayList<File>)batches, pairs, pl);
        }
        return new BatchGraph(edgesSoFar, -1L, (ObjectArrayList<File>)batches);
    }

    public static int[] grayCodePermutation(ImmutableGraph g) {
        int n = g.numNodes();
        int[] perm = new int[n];
        int i = n;
        while (i-- != 0) {
            perm[i] = i;
        }
        IntComparator grayComparator = (x, y) -> {
            LazyIntIterator i1 = g.successors(x);
            LazyIntIterator j = g.successors(y);
            boolean parity = false;
            while (true) {
                int a = i1.nextInt();
                int b = j.nextInt();
                if (a == -1 && b == -1) {
                    return 0;
                }
                if (a == -1) {
                    return parity ? 1 : -1;
                }
                if (b == -1) {
                    return parity ? -1 : 1;
                }
                if (a != b) {
                    return parity ^ a < b ? 1 : -1;
                }
                parity = !parity;
            }
        };
        IntArrays.parallelQuickSort((int[])perm, (int)0, (int)n, (IntComparator)grayComparator);
        int[] invPerm = new int[n];
        i = n;
        while (i-- != 0) {
            invPerm[perm[i]] = i;
        }
        return invPerm;
    }

    public static int[] randomPermutation(ImmutableGraph g, long seed) {
        return IntArrays.shuffle((int[])Util.identity((int)g.numNodes()), (Random)new XoRoShiRo128PlusRandom(seed));
    }

    public static int[] hostByHostGrayCodePermutation(ImmutableGraph g, int[] hostMap, boolean strict) {
        int n = g.numNodes();
        int[] perm = new int[n];
        int i = n;
        while (i-- != 0) {
            perm[i] = i;
        }
        IntComparator hostByHostGrayComparator = (x, y) -> {
            int t = hostMap[x] - hostMap[y];
            if (t != 0) {
                return t;
            }
            LazyIntIterator i1 = g.successors(x);
            LazyIntIterator j = g.successors(y);
            boolean parity = false;
            while (true) {
                int b;
                int a;
                if (strict) {
                    int h = hostMap[x];
                    while ((a = i1.nextInt()) != -1 && hostMap[a] != h) {
                    }
                    while ((b = j.nextInt()) != -1 && hostMap[b] != h) {
                    }
                } else {
                    a = i1.nextInt();
                    b = j.nextInt();
                }
                if (a == -1 && b == -1) {
                    return 0;
                }
                if (a == -1) {
                    return parity ? 1 : -1;
                }
                if (b == -1) {
                    return parity ? -1 : 1;
                }
                if (a != b) {
                    return parity ^ a < b ? 1 : -1;
                }
                parity = !parity;
            }
        };
        IntArrays.parallelQuickSort((int[])perm, (int)0, (int)n, (IntComparator)hostByHostGrayComparator);
        int[] invPerm = new int[n];
        i = n;
        while (i-- != 0) {
            invPerm[perm[i]] = i;
        }
        return invPerm;
    }

    public static int[] lexicographicalPermutation(ImmutableGraph g) {
        int n = g.numNodes();
        int[] perm = new int[n];
        int i = n;
        while (i-- != 0) {
            perm[i] = i;
        }
        IntComparator lexicographicalComparator = (x, y) -> {
            int b;
            int a;
            LazyIntIterator i1 = g.successors(x);
            LazyIntIterator j = g.successors(y);
            do {
                a = i1.nextInt();
                b = j.nextInt();
                if (a == -1 && b == -1) {
                    return 0;
                }
                if (a == -1) {
                    return -1;
                }
                if (b != -1) continue;
                return 1;
            } while (a == b);
            return b - a;
        };
        IntArrays.parallelQuickSort((int[])perm, (int)0, (int)n, (IntComparator)lexicographicalComparator);
        int[] invPerm = new int[n];
        i = n;
        while (i-- != 0) {
            invPerm[perm[i]] = i;
        }
        return invPerm;
    }

    protected static boolean ensureNumArgs(String[] param, int n) {
        return (n < 0 || param.length == n) && (n >= 0 || param.length >= -n);
    }

    protected static ImmutableGraph load(Class<?> graphClass, String baseName, boolean offline, ProgressLogger pl) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        ImmutableGraph graph = null;
        graph = graphClass != null ? (offline ? (ImmutableGraph)graphClass.getMethod("loadOffline", CharSequence.class).invoke(null, baseName) : (ImmutableGraph)graphClass.getMethod("load", CharSequence.class, ProgressLogger.class).invoke(null, baseName, pl)) : (offline ? ImmutableGraph.loadOffline(baseName) : ImmutableGraph.load(baseName, pl));
        return graph;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, JSAPException {
        int[] f;
        ImmutableGraph result;
        Class sourceGraphClass = null;
        Class destGraphClass = BVGraph.class;
        boolean offline = false;
        boolean ascii = false;
        Field[] field = Transform.class.getDeclaredFields();
        ArrayList<String> filterList = new ArrayList<String>();
        ArrayList<String> labelledFilterList = new ArrayList<String>();
        for (Field f2 : field) {
            if (ArcFilter.class.isAssignableFrom(f2.getType())) {
                filterList.add(f2.getName());
            }
            if (!LabelledArcFilter.class.isAssignableFrom(f2.getType())) continue;
            labelledFilterList.add(f2.getName());
        }
        SimpleJSAP jsap = new SimpleJSAP(Transform.class.getName(), "Transforms one or more graphs. All transformations require, after the name,\nsome parameters specified below:\n\nidentity                  sourceBasename destBasename\nmap                       sourceBasename destBasename map [cutoff]\nmapOffline                sourceBasename destBasename map [batchSize] [tempDir]\ntranspose                 sourceBasename destBasename\ntransposeOffline          sourceBasename destBasename [batchSize] [tempDir]\nsymmetrize                sourceBasename [transposeBasename] destBasename\nsymmetrizeOffline         sourceBasename destBasename [batchSize] [tempDir]\nunion                     source1Basename source2Basename destBasename [strategy]\ncompose                   source1Basename source2Basename destBasename [semiring]\ngray                      sourceBasename destBasename\ngrayPerm                  sourceBasename dest\nstrictHostByHostGray      sourceBasename destBasename hostMap\nstrictHostByHostGrayPerm  sourceBasename dest hostMap\nlooseHostByHostGray       sourceBasename destBasename hostMap\nlooseHostByHostGrayPerm   sourceBasename dest hostMap\nlex                       sourceBasename destBasename\nlexPerm                   sourceBasename dest\nline                      sourceBasename destBasename mapName [batchSize]\nrandom                    sourceBasename destBasename [seed]\narcfilter                 sourceBasename destBasename arcFilter (available filters: " + filterList + ")\nlarcfilter                sourceBasename destBasename arcFilter (available filters: " + labelledFilterList + ")\n\nPlease consult the Javadoc documentation for more information on each transform.", new Parameter[]{new FlaggedOption("sourceGraphClass", (StringParser)GraphClassParser.getParser(), JSAP.NO_DEFAULT, false, 's', "source-graph-class", "Forces a Java class to load the source graph."), new FlaggedOption("destGraphClass", (StringParser)GraphClassParser.getParser(), BVGraph.class.getName(), false, 'd', "dest-graph-class", "Forces a Java class to store the destination graph."), new FlaggedOption("destArcLabelledGraphClass", (StringParser)GraphClassParser.getParser(), BitStreamArcLabelledImmutableGraph.class.getName(), false, 'L', "dest-arc-labelled-graph-class", "Forces a Java class to store the labels of the destination graph."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("offline", 'o', "offline", "Use the offline load method to reduce memory consumption."), new Switch("sequential", 'S', "sequential", "Equivalent to offline."), new Switch("ascii", 'a', "ascii", "Maps are in ASCII form (one integer per line)."), new UnflaggedOption("transform", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The transformation to be applied."), new UnflaggedOption("param", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The remaining parameters.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        sourceGraphClass = jsapResult.getClass("sourceGraphClass");
        destGraphClass = jsapResult.getClass("destGraphClass");
        offline = jsapResult.getBoolean("offline") || jsapResult.getBoolean("sequential");
        ascii = jsapResult.getBoolean("ascii");
        String transform = jsapResult.getString("transform");
        String[] param = jsapResult.getStringArray("param");
        String[] source = null;
        String dest = null;
        String map = null;
        ArcFilter arcFilter = null;
        LabelledArcFilter labelledArcFilter = null;
        LabelSemiring labelSemiring = null;
        LabelMergeStrategy labelMergeStrategy = null;
        int batchSize = 1000000;
        int cutoff = -1;
        long seed = 0L;
        File tempDir = null;
        if (!Transform.ensureNumArgs(param, -2)) {
            return;
        }
        if (transform.equals("identity") || transform.equals("transpose") || transform.equals("removeDangling") || transform.equals("gray") || transform.equals("grayPerm") || transform.equals("lex") || transform.equals("lexPerm")) {
            source = new String[]{param[0]};
            dest = param[1];
            if (!Transform.ensureNumArgs(param, 2)) {
                return;
            }
        } else if (transform.equals("map") || transform.equals("strictHostByHostGray") || transform.equals("strictHostByHostGrayPerm") || transform.equals("looseHostByHostGray") || transform.equals("looseHostByHostGrayPerm")) {
            if (!Transform.ensureNumArgs(param, -3)) {
                return;
            }
            source = new String[]{param[0]};
            dest = param[1];
            map = param[2];
            if (param.length == 4) {
                cutoff = Integer.parseInt(param[3]);
            } else if (!Transform.ensureNumArgs(param, 3)) {
                return;
            }
        } else if (transform.equals("mapOffline")) {
            if (!Transform.ensureNumArgs(param, -3)) {
                return;
            }
            source = new String[]{param[0]};
            dest = param[1];
            map = param[2];
            if (param.length >= 4) {
                batchSize = (Integer)JSAP.INTSIZE_PARSER.parse(param[3]);
                if (param.length == 5) {
                    tempDir = new File(param[4]);
                } else if (!Transform.ensureNumArgs(param, 4)) {
                    return;
                }
            } else if (!Transform.ensureNumArgs(param, 3)) {
                return;
            }
        } else if (transform.equals("symmetrize")) {
            if (param.length == 2) {
                source = new String[]{param[0], null};
                dest = param[1];
            } else {
                if (!Transform.ensureNumArgs(param, 3)) return;
                source = new String[]{param[0], param[1]};
                dest = param[2];
            }
        } else if (transform.equals("random")) {
            if (param.length == 2) {
                source = new String[]{param[0], null};
                dest = param[1];
            } else {
                if (!Transform.ensureNumArgs(param, 3)) return;
                source = new String[]{param[0]};
                dest = param[1];
                seed = Long.parseLong(param[2]);
            }
        } else if (transform.equals("arcfilter")) {
            if (!Transform.ensureNumArgs(param, 3)) return;
            try {
                arcFilter = (ArcFilter)Transform.class.getField(param[2]).get(null);
            }
            catch (NoSuchFieldException e) {
                arcFilter = (ArcFilter)ObjectParser.fromSpec((String)param[2], ArcFilter.class, (String[])GraphClassParser.PACKAGE);
            }
            source = new String[]{param[0], null};
            dest = param[1];
        } else if (transform.equals("larcfilter")) {
            if (!Transform.ensureNumArgs(param, 3)) return;
            try {
                labelledArcFilter = (LabelledArcFilter)Transform.class.getField(param[2]).get(null);
            }
            catch (NoSuchFieldException e) {
                labelledArcFilter = (LabelledArcFilter)ObjectParser.fromSpec((String)param[2], LabelledArcFilter.class, (String[])GraphClassParser.PACKAGE);
            }
            source = new String[]{param[0], null};
            dest = param[1];
        } else if (transform.equals("union")) {
            if (!Transform.ensureNumArgs(param, -3)) {
                return;
            }
            source = new String[]{param[0], param[1]};
            dest = param[2];
            if (param.length == 4) {
                labelMergeStrategy = (LabelMergeStrategy)ObjectParser.fromSpec((String)param[3], LabelMergeStrategy.class, (String[])GraphClassParser.PACKAGE);
            } else if (!Transform.ensureNumArgs(param, 3)) {
                return;
            }
        } else if (transform.equals("compose")) {
            if (!Transform.ensureNumArgs(param, -3)) {
                return;
            }
            source = new String[]{param[0], param[1]};
            dest = param[2];
            if (param.length == 4) {
                labelSemiring = (LabelSemiring)ObjectParser.fromSpec((String)param[3], LabelSemiring.class, (String[])GraphClassParser.PACKAGE);
            } else if (!Transform.ensureNumArgs(param, 3)) {
                return;
            }
        } else if (transform.equals("transposeOffline") || transform.equals("symmetrizeOffline")) {
            if (!Transform.ensureNumArgs(param, -2)) {
                return;
            }
            source = new String[]{param[0]};
            dest = param[1];
            if (param.length >= 3) {
                batchSize = (Integer)JSAP.INTSIZE_PARSER.parse(param[2]);
                if (param.length == 4) {
                    tempDir = new File(param[3]);
                } else if (!Transform.ensureNumArgs(param, 3)) {
                    return;
                }
            } else if (!Transform.ensureNumArgs(param, 2)) {
                return;
            }
        } else if (transform.equals("line")) {
            if (!Transform.ensureNumArgs(param, -3)) {
                return;
            }
            source = new String[]{param[0]};
            dest = param[1];
            map = param[2];
            if (param.length == 4) {
                batchSize = Integer.parseInt(param[3]);
            }
        } else {
            System.err.println("Unknown transform: " + transform);
            return;
        }
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ImmutableGraph[] graph = new ImmutableGraph[source.length];
        Class destLabelledGraphClass = jsapResult.getClass("destArcLabelledGraphClass");
        if (!ArcLabelledImmutableGraph.class.isAssignableFrom(destLabelledGraphClass)) {
            throw new IllegalArgumentException("The arc-labelled destination class " + destLabelledGraphClass.getName() + " is not an instance of ArcLabelledImmutableGraph");
        }
        for (int i = 0; i < source.length; ++i) {
            graph[i] = source[i] == null ? null : Transform.load(sourceGraphClass, source[i], offline && (i != 1 || !transform.equals("compose")), pl);
        }
        boolean graph0IsLabelled = graph[0] instanceof ArcLabelledImmutableGraph;
        ArcLabelledImmutableGraph graph0Labelled = graph0IsLabelled ? (ArcLabelledImmutableGraph)graph[0] : null;
        boolean graph1IsLabelled = graph.length > 1 && graph[1] instanceof ArcLabelledImmutableGraph;
        String notForLabelled = "This transformation will just apply to the unlabelled graph; label information will be absent";
        if (transform.equals("identity")) {
            result = graph[0];
        } else if (transform.equals("map") || transform.equals("mapOffline")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            pl.start((CharSequence)"Reading map...");
            int n = graph[0].numNodes();
            f = new int[n];
            long loaded = ascii ? (long)TextIO.loadInts((CharSequence)map, (int[])f) : (long)BinIO.loadInts((CharSequence)map, (int[])f);
            if ((long)n != loaded) {
                throw new IllegalArgumentException("The source graph has " + n + " nodes, but the permutation contains " + loaded + " longs");
            }
            if (cutoff != -1) {
                int i = f.length;
                while (i-- != 0) {
                    if (f[i] < cutoff) continue;
                    f[i] = -1;
                }
            }
            pl.count = n;
            pl.done();
            result = transform.equals("map") ? Transform.map(graph[0], f, pl) : Transform.mapOffline(graph[0], f, batchSize, tempDir, pl);
            LOGGER.info("Transform computation completed.");
        } else if (transform.equals("arcfilter")) {
            if (graph0IsLabelled && !(arcFilter instanceof LabelledArcFilter)) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                result = Transform.filterArcs(graph[0], arcFilter, pl);
            } else {
                result = Transform.filterArcs(graph[0], arcFilter, pl);
            }
        } else if (transform.equals("larcfilter")) {
            if (!graph0IsLabelled) {
                throw new IllegalArgumentException("Filtering on labelled arcs requires a labelled graph");
            }
            result = Transform.filterArcs(graph0Labelled, labelledArcFilter, pl);
        } else if (transform.equals("symmetrize")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            result = Transform.symmetrize(graph[0], graph[1], pl);
        } else if (transform.equals("symmetrizeOffline")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            result = Transform.symmetrizeOffline(graph[0], batchSize, tempDir, pl);
        } else if (transform.equals("removeDangling")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            int n = graph[0].numNodes();
            LOGGER.info("Finding dangling nodes...");
            f = new int[n];
            NodeIterator nodeIterator = graph[0].nodeIterator();
            int c = 0;
            for (int i = 0; i < n; ++i) {
                nodeIterator.nextInt();
                f[i] = nodeIterator.outdegree() != 0 ? c++ : -1;
            }
            result = Transform.map(graph[0], f, pl);
        } else if (transform.equals("transpose")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            result = Transform.transpose(graph[0], pl);
        } else if (transform.equals("transposeOffline")) {
            result = graph0IsLabelled ? Transform.transposeOffline(graph0Labelled, batchSize, tempDir, pl) : Transform.transposeOffline(graph[0], batchSize, tempDir, pl);
        } else if (transform.equals("union")) {
            if (graph0IsLabelled && graph1IsLabelled) {
                if (labelMergeStrategy == null) {
                    throw new IllegalArgumentException("Uniting labelled graphs requires a merge strategy");
                }
                result = Transform.union(graph0Labelled, (ArcLabelledImmutableGraph)graph[1], labelMergeStrategy);
            } else {
                if (graph0IsLabelled || graph1IsLabelled) {
                    LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                }
                result = Transform.union(graph[0], graph[1]);
            }
        } else if (transform.equals("compose")) {
            if (graph0IsLabelled && graph1IsLabelled) {
                if (labelSemiring == null) {
                    throw new IllegalArgumentException("Composing labelled graphs requires a composition strategy");
                }
                result = Transform.compose(graph0Labelled, (ArcLabelledImmutableGraph)graph[1], labelSemiring);
            } else {
                if (graph0IsLabelled || graph1IsLabelled) {
                    LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                }
                result = Transform.compose(graph[0], graph[1]);
            }
        } else if (transform.equals("gray")) {
            if (graph0IsLabelled) {
                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
            }
            result = Transform.map(graph[0], Transform.grayCodePermutation(graph[0]));
        } else {
            if (transform.equals("grayPerm")) {
                if (graph0IsLabelled) {
                    LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                }
                BinIO.storeInts((int[])Transform.grayCodePermutation(graph[0]), (CharSequence)param[1]);
                return;
            }
            if (transform.equals("strictHostByHostGray")) {
                if (graph0IsLabelled) {
                    LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                }
                int[] f3 = new int[graph[0].numNodes()];
                if (ascii) {
                    TextIO.loadInts((CharSequence)map, (int[])f3);
                } else {
                    BinIO.loadInts((CharSequence)map, (int[])f3);
                }
                result = Transform.map(graph[0], Transform.hostByHostGrayCodePermutation(graph[0], f3, true));
            } else {
                if (transform.equals("strictHostByHostGrayPerm")) {
                    if (graph0IsLabelled) {
                        LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                    }
                    int[] f4 = new int[graph[0].numNodes()];
                    if (ascii) {
                        TextIO.loadInts((CharSequence)map, (int[])f4);
                    } else {
                        BinIO.loadInts((CharSequence)map, (int[])f4);
                    }
                    BinIO.storeInts((int[])Transform.hostByHostGrayCodePermutation(graph[0], f4, true), (CharSequence)param[1]);
                    return;
                }
                if (transform.equals("looseHostByHostGray")) {
                    if (graph0IsLabelled) {
                        LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                    }
                    int[] f5 = new int[graph[0].numNodes()];
                    if (ascii) {
                        TextIO.loadInts((CharSequence)map, (int[])f5);
                    } else {
                        BinIO.loadInts((CharSequence)map, (int[])f5);
                    }
                    result = Transform.map(graph[0], Transform.hostByHostGrayCodePermutation(graph[0], f5, false));
                } else {
                    if (transform.equals("looseHostByHostGrayPerm")) {
                        if (graph0IsLabelled) {
                            LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                        }
                        int[] f6 = new int[graph[0].numNodes()];
                        if (ascii) {
                            TextIO.loadInts((CharSequence)map, (int[])f6);
                        } else {
                            BinIO.loadInts((CharSequence)map, (int[])f6);
                        }
                        BinIO.storeInts((int[])Transform.hostByHostGrayCodePermutation(graph[0], f6, false), (CharSequence)param[1]);
                        return;
                    }
                    if (transform.equals("lex")) {
                        if (graph0IsLabelled) {
                            LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                        }
                        result = Transform.map(graph[0], Transform.lexicographicalPermutation(graph[0]));
                    } else {
                        if (transform.equals("lexPerm")) {
                            if (graph0IsLabelled) {
                                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                            }
                            BinIO.storeInts((int[])Transform.lexicographicalPermutation(graph[0]), (CharSequence)param[1]);
                            return;
                        }
                        if (transform.equals("random")) {
                            if (graph0IsLabelled) {
                                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                            }
                            result = Transform.map(graph[0], Transform.randomPermutation(graph[0], seed));
                        } else if (transform.equals("line")) {
                            if (graph0IsLabelled) {
                                LOGGER.warn("This transformation will just apply to the unlabelled graph; label information will be absent");
                            }
                            result = Transform.line(graph[0], map, tempDir, batchSize, pl);
                        } else {
                            result = null;
                        }
                    }
                }
            }
        }
        if (result instanceof ArcLabelledImmutableGraph) {
            LOGGER.info("The result is a labelled graph (class: " + destLabelledGraphClass.getName() + ")");
            File destFile = new File(dest);
            String underlyingName = (destFile.isAbsolute() ? dest : destFile.getName()) + "-underlying";
            destLabelledGraphClass.getMethod("store", ArcLabelledImmutableGraph.class, CharSequence.class, CharSequence.class, ProgressLogger.class).invoke(null, result, dest, underlyingName, pl);
            ImmutableGraph.store(destGraphClass, result, dest + "-underlying", pl);
            return;
        } else {
            ImmutableGraph.store(destGraphClass, result, dest, pl);
        }
    }

    private static final class ComposedGraph
    extends ImmutableSequentialGraph {
        private final ImmutableGraph g0;
        private final ImmutableGraph g1;

        private ComposedGraph(ImmutableGraph g0, ImmutableGraph g1) {
            this.g0 = g0;
            this.g1 = g1;
        }

        @Override
        public int numNodes() {
            return Math.max(this.g0.numNodes(), this.g1.numNodes());
        }

        @Override
        public ImmutableSequentialGraph copy() {
            return new ComposedGraph(this.g0, this.g1.copy());
        }

        @Override
        public boolean hasCopiableIterators() {
            return true;
        }

        @Override
        public NodeIterator nodeIterator() {
            return new ComposedGraphNodeIterator(Integer.MAX_VALUE);
        }

        private final class ComposedGraphNodeIterator
        extends NodeIterator {
            private final NodeIterator it0;
            private final int upperBound;
            private int[] succ;
            private final IntOpenHashSet successors;
            private int outdegree;
            private int nextNode;

            public ComposedGraphNodeIterator(int upperBound) {
                this(upperBound, composedGraph.g0.nodeIterator(), IntArrays.EMPTY_ARRAY, new IntOpenHashSet(16, 0.5f), -1, 0);
            }

            public ComposedGraphNodeIterator(int upperBound, NodeIterator it, int[] succ, IntOpenHashSet successors, int outdegree, int nextNode) {
                this.it0 = it;
                this.upperBound = upperBound;
                this.succ = succ;
                this.successors = successors;
                this.outdegree = outdegree;
                this.nextNode = nextNode;
            }

            public int nextInt() {
                this.outdegree = -1;
                int result = this.it0.nextInt();
                assert (result == this.nextNode);
                ++this.nextNode;
                return result;
            }

            public boolean hasNext() {
                return this.nextNode < this.upperBound && this.it0.hasNext();
            }

            @Override
            public int outdegree() {
                if (this.outdegree < 0) {
                    this.successorArray();
                }
                return this.outdegree;
            }

            @Override
            public int[] successorArray() {
                if (this.outdegree < 0) {
                    int d = this.it0.outdegree();
                    int[] s = this.it0.successorArray();
                    this.successors.clear();
                    for (int i = 0; i < d; ++i) {
                        int x;
                        LazyIntIterator s1 = ComposedGraph.this.g1.successors(s[i]);
                        while ((x = s1.nextInt()) >= 0) {
                            this.successors.add(x);
                        }
                    }
                    this.outdegree = this.successors.size();
                    this.succ = IntArrays.ensureCapacity((int[])this.succ, (int)this.outdegree, (int)0);
                    this.successors.toArray(this.succ);
                    IntArrays.quickSort((int[])this.succ, (int)0, (int)this.outdegree);
                }
                return this.succ;
            }

            @Override
            public NodeIterator copy(int upperBound) {
                return new ComposedGraphNodeIterator(upperBound, this.it0.copy(Integer.MAX_VALUE), java.util.Arrays.copyOf(this.succ, this.succ.length), new IntOpenHashSet((IntCollection)this.successors), this.outdegree, this.nextNode);
            }
        }
    }

    public static final class BatchGraph
    extends ImmutableSequentialGraph {
        private final ObjectArrayList<File> batches;
        private final int n;
        private final long numArcs;

        public BatchGraph(int n, long m, ObjectArrayList<File> batches) {
            this.batches = batches;
            this.n = n;
            this.numArcs = m;
        }

        @Override
        public int numNodes() {
            return this.n;
        }

        @Override
        public long numArcs() {
            return this.numArcs;
        }

        @Override
        public boolean hasCopiableIterators() {
            return true;
        }

        @Override
        public BatchGraph copy() {
            return this;
        }

        @Override
        public NodeIterator nodeIterator() {
            try {
                return new BatchGraphNodeIterator(this.n, this.batches, this.n);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void finalize() throws Throwable {
            try {
                for (File f : this.batches) {
                    f.delete();
                }
            }
            finally {
                super.finalize();
            }
        }

        private static final class BatchGraphNodeIterator
        extends NodeIterator {
            private static final int STD_BUFFER_SIZE = 131072;
            private final IntHeapSemiIndirectPriorityQueue queue;
            private final int[] refArray;
            private final InputBitStream[] batchIbs;
            private final int upperBound;
            private final int[] inputStreamLength;
            private final int[] prevTarget;
            private int last;
            private int outdegree;
            private int[] successor;
            private final ObjectArrayList<File> batches;
            private final int n;

            private BatchGraphNodeIterator(int n, ObjectArrayList<File> batches, int upperBound) throws IOException {
                this(n, batches, upperBound, null, null, null, null, -1, 0, IntArrays.EMPTY_ARRAY);
            }

            private BatchGraphNodeIterator(int n, ObjectArrayList<File> batches, int upperBound, InputBitStream[] baseIbs, int[] refArray, int[] prevTarget, int[] inputStreamLength, int last, int outdegree, int[] successor) throws IOException {
                this.n = n;
                this.batches = batches;
                this.upperBound = Math.min(n, upperBound);
                this.last = last;
                this.outdegree = outdegree;
                this.successor = successor;
                this.batchIbs = new InputBitStream[batches.size()];
                if (refArray == null) {
                    this.refArray = new int[batches.size()];
                    this.prevTarget = new int[batches.size()];
                    this.inputStreamLength = new int[batches.size()];
                    java.util.Arrays.fill(this.prevTarget, -1);
                    this.queue = new IntHeapSemiIndirectPriorityQueue(this.refArray);
                    for (int i = 0; i < batches.size(); ++i) {
                        this.batchIbs[i] = new InputBitStream((File)batches.get(i), 131072);
                        this.inputStreamLength[i] = this.batchIbs[i].readDelta();
                        this.refArray[i] = this.batchIbs[i].readDelta();
                        this.queue.enqueue(i);
                    }
                } else {
                    this.refArray = refArray;
                    this.prevTarget = prevTarget;
                    this.inputStreamLength = inputStreamLength;
                    this.queue = new IntHeapSemiIndirectPriorityQueue(refArray);
                    for (int i = 0; i < refArray.length; ++i) {
                        if (baseIbs[i] == null) continue;
                        this.batchIbs[i] = new InputBitStream((File)batches.get(i), 131072);
                        this.batchIbs[i].position(baseIbs[i].position());
                        this.queue.enqueue(i);
                    }
                }
            }

            @Override
            public NodeIterator copy(int upperBound) {
                try {
                    if (this.last == -1) {
                        return new BatchGraphNodeIterator(this.n, this.batches, upperBound);
                    }
                    return new BatchGraphNodeIterator(this.n, this.batches, upperBound, this.batchIbs, (int[])this.refArray.clone(), (int[])this.prevTarget.clone(), (int[])this.inputStreamLength.clone(), this.last, this.outdegree, java.util.Arrays.copyOf(this.successor, this.outdegree));
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            @Override
            public int outdegree() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                return this.outdegree;
            }

            public boolean hasNext() {
                return this.last < this.upperBound - 1;
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.last;
                int d = 0;
                try {
                    int i;
                    while (!this.queue.isEmpty() && this.refArray[i = this.queue.first()] == this.last) {
                        this.successor = IntArrays.grow((int[])this.successor, (int)(d + 1));
                        int n = i;
                        int n2 = this.prevTarget[n] + (this.batchIbs[i].readDelta() + 1);
                        this.prevTarget[n] = n2;
                        this.successor[d] = n2;
                        int n3 = i;
                        this.inputStreamLength[n3] = this.inputStreamLength[n3] - 1;
                        if (this.inputStreamLength[n3] == 0) {
                            this.queue.dequeue();
                            this.batchIbs[i].close();
                            this.batchIbs[i] = null;
                        } else {
                            int sourceDelta = this.batchIbs[i].readDelta();
                            if (sourceDelta != 0) {
                                int n4 = i;
                                this.refArray[n4] = this.refArray[n4] + sourceDelta;
                                this.prevTarget[i] = -1;
                                this.queue.changed();
                            }
                        }
                        ++d;
                    }
                    IntArrays.quickSort((int[])this.successor, (int)0, (int)d);
                    if (d != 0) {
                        int p = 0;
                        for (int j = 1; j < d; ++j) {
                            if (this.successor[p] == this.successor[j]) continue;
                            this.successor[++p] = this.successor[j];
                        }
                        d = p + 1;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(this + " " + e);
                }
                this.outdegree = d;
                return this.last;
            }

            @Override
            public int[] successorArray() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                return this.successor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                try {
                    for (InputBitStream ibs : this.batchIbs) {
                        if (ibs == null) continue;
                        ibs.close();
                    }
                }
                finally {
                    super.finalize();
                }
            }
        }
    }

    private static final class RemappedImmutableGraph
    extends ImmutableGraph {
        private final int[] map;
        private final ImmutableGraph g;
        private final boolean isInjective;
        private final boolean isPermutation;
        private final int remappedNodes;
        private final int destNumNodes;
        private final int[] pseudoInverse;
        private int[] succ;
        private int outdegree;
        private int currentNode = -1;

        private RemappedImmutableGraph(int[] map, ImmutableGraph g, boolean isInjective, boolean isPermutation, int remappedNodes, int destNumNodes, int[] pseudoInverse) {
            this.map = map;
            this.g = g;
            this.isInjective = isInjective;
            this.isPermutation = isPermutation;
            this.remappedNodes = remappedNodes;
            this.destNumNodes = destNumNodes;
            this.pseudoInverse = pseudoInverse;
        }

        @Override
        public RemappedImmutableGraph copy() {
            return new RemappedImmutableGraph(this.map, this.g.copy(), this.isInjective, this.isPermutation, this.remappedNodes, this.destNumNodes, this.pseudoInverse);
        }

        @Override
        public int numNodes() {
            return this.destNumNodes;
        }

        @Override
        public boolean randomAccess() {
            return true;
        }

        @Override
        public boolean hasCopiableIterators() {
            return true;
        }

        @Override
        public int[] successorArray(int x) {
            if (this.currentNode != x) {
                IntOpenHashSet succSet = new IntOpenHashSet();
                succSet.clear();
                if (this.isPermutation) {
                    LazyIntIterator i = this.g.successors(this.pseudoInverse[x]);
                    int d = this.g.outdegree(this.pseudoInverse[x]);
                    while (d-- != 0) {
                        succSet.add(this.map[i.nextInt()]);
                    }
                } else {
                    int t;
                    int low = 0;
                    int high = this.remappedNodes - 1;
                    int mid = 0;
                    while (low <= high) {
                        mid = low + high >>> 1;
                        int midVal = this.map[this.pseudoInverse[mid]];
                        if (midVal < x) {
                            low = mid + 1;
                            continue;
                        }
                        if (midVal <= x) break;
                        high = mid - 1;
                    }
                    if (this.isInjective) {
                        int p = this.pseudoInverse[mid];
                        if (this.map[p] == x) {
                            LazyIntIterator i = this.g.successors(p);
                            int d = this.g.outdegree(p);
                            while (d-- != 0) {
                                t = this.map[i.nextInt()];
                                if (t == -1) continue;
                                succSet.add(t);
                            }
                        }
                    } else {
                        int p;
                        while (mid > 0 && this.map[this.pseudoInverse[mid - 1]] == x) {
                            --mid;
                        }
                        while (mid < this.remappedNodes && this.map[p = this.pseudoInverse[mid]] == x) {
                            LazyIntIterator i = this.g.successors(p);
                            int d = this.g.outdegree(p);
                            while (d-- != 0) {
                                t = this.map[i.nextInt()];
                                if (t == -1) continue;
                                succSet.add(t);
                            }
                            ++mid;
                        }
                    }
                }
                this.outdegree = succSet.size();
                this.currentNode = x;
                this.succ = succSet.toIntArray();
                if (this.outdegree > 0) {
                    IntArrays.quickSort((int[])this.succ, (int)0, (int)this.outdegree);
                }
            }
            return this.succ;
        }

        @Override
        public int outdegree(int x) {
            if (this.currentNode != x) {
                this.successorArray(x);
            }
            return this.outdegree;
        }
    }

    private static final class FilteredArcLabelledImmutableGraph
    extends ArcLabelledImmutableGraph {
        private final LabelledArcFilter filter;
        private final ArcLabelledImmutableGraph graph;
        private int[] succ;
        private Label[] label;
        private int cachedNode = -1;

        @Override
        public boolean hasCopiableIterators() {
            return this.graph.hasCopiableIterators();
        }

        private FilteredArcLabelledImmutableGraph(LabelledArcFilter filter, ArcLabelledImmutableGraph graph) {
            this.filter = filter;
            this.graph = graph;
        }

        @Override
        public int numNodes() {
            return this.graph.numNodes();
        }

        @Override
        public ArcLabelledImmutableGraph copy() {
            return new FilteredArcLabelledImmutableGraph(this.filter, this.graph.copy());
        }

        @Override
        public boolean randomAccess() {
            return this.graph.randomAccess();
        }

        @Override
        public Label prototype() {
            return this.graph.prototype();
        }

        private void fillCache(int x) {
            if (x == this.cachedNode) {
                return;
            }
            this.cachedNode = x;
            this.succ = LazyIntIterators.unwrap(this.successors(x));
            this.label = super.labelArray(x);
        }

        @Override
        public ArcLabelledNodeIterator.LabelledArcIterator successors(int x) {
            return new FilteredLabelledArcIterator(x, this.graph.successors(x));
        }

        @Override
        public int[] successorArray(int x) {
            this.fillCache(x);
            return this.succ;
        }

        @Override
        public Label[] labelArray(int x) {
            this.fillCache(x);
            return this.label;
        }

        @Override
        public int outdegree(int x) {
            this.fillCache(x);
            return this.succ.length;
        }

        @Override
        public ArcLabelledNodeIterator nodeIterator() {
            return new FilterdArcLabelledNodeIterator(Integer.MAX_VALUE);
        }

        private final class FilteredLabelledArcIterator
        extends AbstractLazyIntIterator
        implements ArcLabelledNodeIterator.LabelledArcIterator {
            private final int x;
            private final ArcLabelledNodeIterator.LabelledArcIterator successors;

            private FilteredLabelledArcIterator(int x, ArcLabelledNodeIterator.LabelledArcIterator successors) {
                this.x = x;
                this.successors = successors;
            }

            @Override
            public int nextInt() {
                int t;
                while ((t = this.successors.nextInt()) != -1) {
                    if (!FilteredArcLabelledImmutableGraph.this.filter.accept(this.x, t, this.successors.label())) continue;
                    return t;
                }
                return -1;
            }

            @Override
            public Label label() {
                return this.successors.label();
            }
        }

        private final class FilterdArcLabelledNodeIterator
        extends ArcLabelledNodeIterator {
            private final ArcLabelledNodeIterator nodeIterator;
            private final int upperBound;
            private int currNode;
            private int outdegree;

            public FilterdArcLabelledNodeIterator(int upperBound) {
                this(upperBound, filteredArcLabelledImmutableGraph.graph.nodeIterator(), -1, -1);
            }

            public FilterdArcLabelledNodeIterator(int upperBound, ArcLabelledNodeIterator nodeIterator, int currNode, int outdegree) {
                this.upperBound = upperBound;
                this.nodeIterator = nodeIterator;
                this.currNode = currNode;
                this.outdegree = outdegree;
            }

            @Override
            public int outdegree() {
                if (this.currNode == -1) {
                    throw new IllegalStateException();
                }
                if (this.outdegree == -1) {
                    int d = 0;
                    ArcLabelledNodeIterator.LabelledArcIterator successors = this.successors();
                    while (successors.nextInt() != -1) {
                        ++d;
                    }
                    this.outdegree = d;
                }
                return this.outdegree;
            }

            public int nextInt() {
                this.outdegree = -1;
                this.currNode = this.nodeIterator.nextInt();
                return this.currNode;
            }

            public boolean hasNext() {
                return this.currNode + 1 < this.upperBound && this.nodeIterator.hasNext();
            }

            @Override
            public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                return new FilteredLabelledArcIterator(this.currNode, this.nodeIterator.successors());
            }

            @Override
            public ArcLabelledNodeIterator copy(int upperBound) {
                return new FilterdArcLabelledNodeIterator(upperBound, this.nodeIterator.copy(upperBound), this.currNode, this.outdegree);
            }
        }
    }

    private static final class FilteredImmutableGraph
    extends ImmutableGraph {
        private final ArcFilter filter;
        private final ImmutableGraph graph;
        private int[] succ;
        private int cachedNode = -1;

        private FilteredImmutableGraph(ArcFilter filter, ImmutableGraph graph) {
            this.filter = filter;
            this.graph = graph;
        }

        @Override
        public int numNodes() {
            return this.graph.numNodes();
        }

        @Override
        public FilteredImmutableGraph copy() {
            return new FilteredImmutableGraph(this.filter, this.graph.copy());
        }

        @Override
        public boolean randomAccess() {
            return this.graph.randomAccess();
        }

        @Override
        public boolean hasCopiableIterators() {
            return this.graph.hasCopiableIterators();
        }

        @Override
        public LazyIntIterator successors(final int x) {
            return new AbstractLazyIntIterator(){
                private final LazyIntIterator s;
                {
                    this.s = graph.successors(x);
                }

                @Override
                public int nextInt() {
                    int t;
                    while ((t = this.s.nextInt()) != -1) {
                        if (!filter.accept(x, t)) continue;
                        return t;
                    }
                    return -1;
                }
            };
        }

        private void fillCache(int x) {
            if (x == this.cachedNode) {
                return;
            }
            this.succ = LazyIntIterators.unwrap(this.successors(x));
            this.cachedNode = x;
        }

        @Override
        public int[] successorArray(int x) {
            this.fillCache(x);
            return this.succ;
        }

        @Override
        public int outdegree(int x) {
            this.fillCache(x);
            return this.succ.length;
        }

        @Override
        public NodeIterator nodeIterator() {
            return new FilteredImmutableGraphNodeIterator(this.graph.nodeIterator());
        }

        @Override
        public NodeIterator nodeIterator(int from) {
            return new FilteredImmutableGraphNodeIterator(this.graph.nodeIterator(from), from, -1, IntArrays.EMPTY_ARRAY);
        }

        private final class FilteredImmutableGraphNodeIterator
        extends NodeIterator {
            private final NodeIterator nodeIterator;
            private int nextNode;
            private int outdegree;
            private int[] succ;

            public FilteredImmutableGraphNodeIterator(NodeIterator nodeIterator) {
                this(nodeIterator, 0, -1, IntArrays.EMPTY_ARRAY);
            }

            public FilteredImmutableGraphNodeIterator(NodeIterator nodeIterator, int nextNode, int outdegree, int[] succ) {
                this.nodeIterator = nodeIterator;
                this.nextNode = nextNode;
                this.outdegree = outdegree;
                this.succ = succ;
            }

            @Override
            public int outdegree() {
                if (this.outdegree == -1) {
                    throw new IllegalStateException();
                }
                return this.outdegree;
            }

            public int nextInt() {
                int currNode = this.nodeIterator.nextInt();
                assert (this.nextNode == currNode);
                ++this.nextNode;
                int oldOutdegree = this.nodeIterator.outdegree();
                int[] oldSucc = this.nodeIterator.successorArray();
                this.succ = IntArrays.ensureCapacity((int[])this.succ, (int)oldOutdegree, (int)0);
                this.outdegree = 0;
                for (int i = 0; i < oldOutdegree; ++i) {
                    if (!FilteredImmutableGraph.this.filter.accept(currNode, oldSucc[i])) continue;
                    this.succ[this.outdegree++] = oldSucc[i];
                }
                return currNode;
            }

            @Override
            public int[] successorArray() {
                if (this.outdegree == -1) {
                    throw new IllegalStateException();
                }
                return this.succ;
            }

            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            @Override
            public NodeIterator copy(int upperBound) {
                return new FilteredImmutableGraphNodeIterator(this.nodeIterator.copy(upperBound), this.nextNode, this.outdegree, java.util.Arrays.copyOf(this.succ, Math.max(0, this.outdegree)));
            }
        }
    }

    public static final class LowerBound
    implements LabelledArcFilter {
        private final int lowerBound;

        public LowerBound(int lowerBound) {
            this.lowerBound = lowerBound;
        }

        public LowerBound(String lowerBound) {
            this(Integer.parseInt(lowerBound));
        }

        @Override
        public boolean accept(int i, int j, Label label) {
            return label.getInt() >= this.lowerBound;
        }
    }

    public static final class NodeClassFilter
    implements ArcFilter,
    LabelledArcFilter {
        private final boolean keepOnlySame;
        private final int[] nodeClass;

        public NodeClassFilter(String classFile, boolean keepOnlySame) {
            try {
                this.nodeClass = BinIO.loadInts((CharSequence)classFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.keepOnlySame = keepOnlySame;
        }

        public NodeClassFilter(String classFile, String keepOnlySame) {
            this(classFile, Boolean.parseBoolean(keepOnlySame));
        }

        @Override
        public boolean accept(int i, int j) {
            return this.keepOnlySame == (this.nodeClass[i] == this.nodeClass[j]);
        }

        @Override
        public boolean accept(int i, int j, Label label) {
            return this.keepOnlySame == (this.nodeClass[i] == this.nodeClass[j]);
        }
    }

    private static final class NoLoops
    implements ArcFilter,
    LabelledArcFilter {
        private NoLoops() {
        }

        @Override
        public boolean accept(int i, int j) {
            return i != j;
        }

        @Override
        public boolean accept(int i, int j, Label label) {
            return i != j;
        }
    }

    public static interface LabelledArcFilter {
        public boolean accept(int var1, int var2, Label var3);
    }

    public static interface ArcFilter {
        public boolean accept(int var1, int var2);
    }
}

