/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterators;
import it.unimi.dsi.webgraph.MergedIntIterator;
import it.unimi.dsi.webgraph.NodeIterator;
import it.unimi.dsi.webgraph.Transform;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionImmutableGraph
extends ImmutableGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transform.class);
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private static final int INITIAL_ARRAY_SIZE = 16;
    private final ImmutableGraph g0;
    private final ImmutableGraph g1;
    private final int n0;
    private final int n1;
    private final int numNodes;
    private int cachedNode = -1;
    private int outdegree;
    private int[] cache;

    public UnionImmutableGraph(ImmutableGraph g0, ImmutableGraph g1) {
        this.g0 = g0;
        this.g1 = g1;
        this.n0 = g0.numNodes();
        this.n1 = g1.numNodes();
        this.numNodes = Math.max(this.n0, this.n1);
    }

    @Override
    public UnionImmutableGraph copy() {
        return new UnionImmutableGraph(this.g0.copy(), this.g1.copy());
    }

    @Override
    public NodeIterator nodeIterator(int from) {
        return new InternalNodeIterator(from < this.n0 ? this.g0.nodeIterator(from) : null, from < this.n1 ? this.g1.nodeIterator(from) : null);
    }

    @Override
    public int numNodes() {
        return this.numNodes;
    }

    @Override
    public boolean randomAccess() {
        return this.g0.randomAccess() && this.g1.randomAccess();
    }

    @Override
    public boolean hasCopiableIterators() {
        return this.g0.hasCopiableIterators() && this.g1.hasCopiableIterators();
    }

    private void fillCache(int x) {
        int t;
        if (x == this.cachedNode) {
            return;
        }
        MergedIntIterator merge = new MergedIntIterator(x < this.n0 ? this.g0.successors(x) : LazyIntIterators.EMPTY_ITERATOR, x < this.n1 ? this.g1.successors(x) : LazyIntIterators.EMPTY_ITERATOR);
        this.outdegree = 0;
        this.cache = new int[16];
        this.outdegree += LazyIntIterators.unwrap(merge, this.cache);
        while ((t = merge.nextInt()) != -1) {
            int upto = this.cache.length;
            this.cache = IntArrays.grow((int[])this.cache, (int)(upto + 1));
            this.cache[upto++] = t;
            ++this.outdegree;
            this.outdegree += LazyIntIterators.unwrap(merge, this.cache, upto, this.cache.length - upto);
        }
        this.cachedNode = x;
    }

    @Override
    public int[] successorArray(int x) {
        this.fillCache(x);
        return this.cache;
    }

    @Override
    public int outdegree(int x) {
        this.fillCache(x);
        return this.outdegree;
    }

    private static class InternalNodeIterator
    extends NodeIterator {
        private int[] cache;
        private int outdegree;
        private NodeIterator i0;
        private NodeIterator i1;

        public InternalNodeIterator(NodeIterator i0, NodeIterator i1) {
            this(i0, i1, -1, IntArrays.EMPTY_ARRAY);
        }

        public InternalNodeIterator(NodeIterator i0, NodeIterator i1, int outdegree, int[] cache) {
            this.i0 = i0;
            this.i1 = i1;
            this.outdegree = outdegree;
            this.cache = cache;
        }

        public boolean hasNext() {
            return this.i0 != null && this.i0.hasNext() || this.i1 != null && this.i1.hasNext();
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.outdegree = -1;
            int result = -1;
            if (this.i0 != null) {
                if (this.i0.hasNext()) {
                    result = this.i0.nextInt();
                } else {
                    this.i0 = null;
                }
            }
            if (this.i1 != null) {
                if (this.i1.hasNext()) {
                    result = this.i1.nextInt();
                } else {
                    this.i1 = null;
                }
            }
            return result;
        }

        @Override
        public int[] successorArray() {
            int t;
            if (this.outdegree != -1) {
                return this.cache;
            }
            if (this.i0 == null) {
                this.outdegree = this.i1.outdegree();
                this.cache = this.i1.successorArray();
                return this.cache;
            }
            if (this.i1 == null) {
                this.outdegree = this.i0.outdegree();
                this.cache = this.i0.successorArray();
                return this.cache;
            }
            MergedIntIterator merge = new MergedIntIterator(this.i0.successors(), this.i1.successors());
            this.outdegree = LazyIntIterators.unwrap(merge, this.cache);
            while ((t = merge.nextInt()) != -1) {
                int upto = this.cache.length;
                this.cache = IntArrays.grow((int[])this.cache, (int)(upto + 1));
                this.cache[upto++] = t;
                ++this.outdegree;
                this.outdegree += LazyIntIterators.unwrap(merge, this.cache, upto, this.cache.length - upto);
            }
            return this.cache;
        }

        @Override
        public int outdegree() {
            this.successorArray();
            return this.outdegree;
        }

        @Override
        public NodeIterator copy(int upperBound) {
            return new InternalNodeIterator(this.i0.copy(upperBound), this.i1.copy(upperBound), this.outdegree, Arrays.copyOf(this.cache, Math.max(this.outdegree, 0)));
        }
    }
}

