/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.examples;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class BreadthFirst {
    private BreadthFirst() {
    }

    public static void main(String[] arg) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(BreadthFirst.class.getName(), "Visits a graph in breadth-first fashion, possibly starting just from a given node.", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new FlaggedOption("start", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(-1), false, 's', "start", "The starting node; if missing or -1, the visit will be complete."), new FlaggedOption("maxDist", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(Integer.MAX_VALUE), false, 'm', "maxDist", "Maximum distance (nodes at larger distance from the root are not enqueued"), new Switch("print", 'p', "print", "Print nodes as they are enqueued. If set, ordinary output is suppressed."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        ProgressLogger pl = new ProgressLogger();
        pl.logInterval = jsapResult.getLong("logInterval");
        String basename = jsapResult.getString("basename");
        ImmutableGraph graph = jsapResult.userSpecified("graphClass") ? (ImmutableGraph)jsapResult.getClass("graphClass").getMethod("load", CharSequence.class, ProgressLogger.class).invoke(null, basename, pl) : ImmutableGraph.load(basename, pl);
        int maxDist = jsapResult.getInt("maxDist");
        boolean print = jsapResult.getBoolean("print");
        int start = jsapResult.getInt("start");
        IntArrayFIFOQueue queue = new IntArrayFIFOQueue();
        int n = graph.numNodes();
        int[] dist = new int[n];
        Arrays.fill(dist, Integer.MAX_VALUE);
        int lo = start == -1 ? 0 : start;
        int hi = start == -1 ? n : start + 1;
        int curr = lo;
        int ecc = 0;
        int reachable = 0;
        pl.start((CharSequence)"Starting visit...");
        pl.expectedUpdates = hi - lo;
        pl.itemsName = "nodes";
        for (int i = lo; i < hi; ++i) {
            if (dist[i] == Integer.MAX_VALUE) {
                queue.enqueue(i);
                if (print) {
                    System.out.println(i);
                }
                dist[i] = 0;
                while (!queue.isEmpty()) {
                    curr = queue.dequeueInt();
                    LazyIntIterator successors = graph.successors(curr);
                    int d = graph.outdegree(curr);
                    while (d-- != 0) {
                        int succ = successors.nextInt();
                        if (dist[succ] != Integer.MAX_VALUE || dist[curr] + 1 > maxDist) continue;
                        ++reachable;
                        dist[succ] = dist[curr] + 1;
                        ecc = Math.max(ecc, dist[succ]);
                        queue.enqueue(succ);
                        if (!print) continue;
                        System.out.println(succ);
                    }
                }
            }
            pl.update();
        }
        pl.done();
        if (!print) {
            if (start == -1) {
                System.out.println("The maximum depth of a tree in the breadth-first spanning forest is " + ecc);
            } else {
                System.out.println("The eccentricity of node " + start + " is " + ecc + " (" + reachable + " reachable nodes)");
            }
        }
    }
}

