/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.labelling;

import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.webgraph.labelling.Label;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;

public abstract class ArcLabelledImmutableGraph
extends ImmutableGraph {
    public static final String UNDERLYINGGRAPH_PROPERTY_KEY = "underlyinggraph";
    public static final String UNDERLYINGGRAPH_SUFFIX = "-underlying";

    @Override
    public abstract ArcLabelledImmutableGraph copy();

    @Override
    public ArcLabelledNodeIterator nodeIterator() {
        return this.nodeIterator(0);
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator(int from) {
        class InternalArcLabelledNodeIterator
        extends ArcLabelledNodeIterator {
            int curr;
            final int n;
            final int upperBound;
            final /* synthetic */ int val$from;

            public InternalArcLabelledNodeIterator(int upperBound) {
                this.val$from = n;
                this.curr = this.val$from - 1;
                this.n = ArcLabelledImmutableGraph.this.numNodes();
                this.upperBound = upperBound;
            }

            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ++this.curr;
            }

            public boolean hasNext() {
                return this.curr < Math.min(this.n - 1, this.upperBound - 1);
            }

            @Override
            public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                if (this.curr == this.val$from - 1) {
                    throw new IllegalStateException();
                }
                return ArcLabelledImmutableGraph.this.successors(this.curr);
            }

            @Override
            public int outdegree() {
                if (this.curr == this.val$from - 1) {
                    throw new IllegalStateException();
                }
                return ArcLabelledImmutableGraph.this.outdegree(this.curr);
            }

            @Override
            public ArcLabelledNodeIterator copy(int upperBound) {
                InternalArcLabelledNodeIterator result = new InternalArcLabelledNodeIterator(upperBound);
                result.curr = this.curr;
                return result;
            }
        }
        return new InternalArcLabelledNodeIterator(Integer.MAX_VALUE);
    }

    @Override
    public abstract ArcLabelledNodeIterator.LabelledArcIterator successors(int var1);

    public abstract Label prototype();

    public Label[] labelArray(int x) {
        return ArcLabelledNodeIterator.unwrap(this.successors(x), this.outdegree(x));
    }

    @Deprecated
    public static ArcLabelledImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return (ArcLabelledImmutableGraph)ImmutableGraph.loadSequential(basename);
    }

    @Deprecated
    public static ArcLabelledImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return (ArcLabelledImmutableGraph)ImmutableGraph.loadSequential(basename, pl);
    }

    public static ArcLabelledImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return (ArcLabelledImmutableGraph)ImmutableGraph.loadOffline(basename);
    }

    public static ArcLabelledImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return (ArcLabelledImmutableGraph)ImmutableGraph.loadOffline(basename, pl);
    }

    public static ArcLabelledImmutableGraph load(CharSequence basename) throws IOException {
        return (ArcLabelledImmutableGraph)ImmutableGraph.load(basename);
    }

    public static ArcLabelledImmutableGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return (ArcLabelledImmutableGraph)ImmutableGraph.load(basename, pl);
    }

    public static ArcLabelledImmutableGraph loadOnce(InputStream is) throws IOException {
        return (ArcLabelledImmutableGraph)ImmutableGraph.loadOnce(is);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        long numArcs = -1L;
        try {
            numArcs = this.numArcs();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        s.append("Nodes: " + this.numNodes() + "\nArcs: " + (numArcs == -1L ? "unknown" : Long.toString(numArcs)) + "\n");
        ArcLabelledNodeIterator nodeIterator = this.nodeIterator();
        int i = this.numNodes();
        while (i-- != 0) {
            int curr = nodeIterator.nextInt();
            s.append("Successors of " + curr + " (degree " + nodeIterator.outdegree() + "):");
            ArcLabelledNodeIterator.LabelledArcIterator successors = nodeIterator.successors();
            int d = nodeIterator.outdegree();
            while (d-- != 0) {
                s.append(" " + successors.nextInt() + " [" + successors.label() + "]");
            }
            s.append('\n');
        }
        return s.toString();
    }

    @Override
    public boolean equals(Object x) {
        if (!(x instanceof ArcLabelledImmutableGraph)) {
            return false;
        }
        ArcLabelledImmutableGraph g = (ArcLabelledImmutableGraph)x;
        if (g.numNodes() != this.numNodes()) {
            return false;
        }
        ArcLabelledNodeIterator nodeIterator = this.nodeIterator();
        ArcLabelledNodeIterator gNodeIterator = g.nodeIterator();
        while (nodeIterator.hasNext()) {
            nodeIterator.nextInt();
            gNodeIterator.nextInt();
            if (nodeIterator.outdegree() != gNodeIterator.outdegree()) {
                return false;
            }
            ArcLabelledNodeIterator.LabelledArcIterator arcIterator = nodeIterator.successors();
            ArcLabelledNodeIterator.LabelledArcIterator gArcIterator = gNodeIterator.successors();
            int d = nodeIterator.outdegree();
            while (d-- != 0) {
                if (arcIterator.nextInt() == gArcIterator.nextInt() && arcIterator.label().equals(gArcIterator.label())) continue;
                return false;
            }
        }
        return true;
    }
}

