/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.webgraph.test;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.XoRoShiRo128PlusRandom;
import it.unimi.dsi.webgraph.GraphClassParser;
import it.unimi.dsi.webgraph.ImmutableGraph;
import it.unimi.dsi.webgraph.LazyIntIterator;
import it.unimi.dsi.webgraph.LazyIntSkippableIterator;
import it.unimi.dsi.webgraph.NodeIterator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class SpeedTest {
    private static final int WARMUP = 3;
    private static final int REPEAT = 10;

    private SpeedTest() {
    }

    public static void main(String[] arg) throws IllegalArgumentException, SecurityException, JSAPException, IOException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InstantiationException {
        SimpleJSAP jsap = new SimpleJSAP(SpeedTest.class.getName(), "Tests the access speed of an ImmutableGraph. By default, the graph is enumerated sequentially, but you can specify a number of nodes to be accessed randomly.\n\nThis class executes 3 warmup iterations, and then averages the timings of the following 10 iterations.", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), JSAP.NO_DEFAULT, false, 'g', "graphClass", "Forces a Java class for the source graph."), new Switch("spec", 's', "spec", "The basename is a specification of the form <ImmutableGraphImplementation>(arg,arg,...)."), new FlaggedOption("seed", (StringParser)JSAP.LONG_PARSER, JSAP.NO_DEFAULT, false, 'S', "seed", "A seed for the pseudorandom number generator."), new FlaggedOption("random", (StringParser)JSAP.LONGSIZE_PARSER, JSAP.NO_DEFAULT, false, 'r', "random", "Perform a random-access test on this number of nodes instead of enumerating sequentially the whole graph."), new FlaggedOption("adjacency", (StringParser)JSAP.LONGSIZE_PARSER, JSAP.NO_DEFAULT, false, 'a', "adjacency", "Perform an adjacency test on this number of random pairs instead of enumerating sequentially the whole graph."), new Switch("first", 'f', "first", "Just enumerate the first successor of each tested node."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        boolean random = jsapResult.userSpecified("random");
        boolean adjacency = jsapResult.userSpecified("adjacency");
        if (random && adjacency) {
            throw new IllegalArgumentException("You cannot specify a random and an adjacency test at the same time");
        }
        boolean spec = jsapResult.getBoolean("spec");
        boolean first = jsapResult.userSpecified("first");
        Class graphClass = jsapResult.getClass("graphClass");
        String basename = jsapResult.getString("basename");
        if (graphClass != null && spec) {
            throw new IllegalArgumentException("Options --graph-class and --spec are incompatible.");
        }
        ProgressLogger pl = new ProgressLogger();
        long seed = jsapResult.userSpecified("seed") ? jsapResult.getLong("seed") : Util.randomSeed();
        XoRoShiRo128PlusRandom r = new XoRoShiRo128PlusRandom();
        System.err.println("Seed: " + seed);
        long totLinks = 0L;
        long cumulativeTime = 0L;
        long z = -1L;
        if (random) {
            ImmutableGraph graph = jsapResult.userSpecified("graphClass") ? (ImmutableGraph)graphClass.getMethod(ImmutableGraph.LoadMethod.STANDARD.toMethod(), CharSequence.class, ProgressLogger.class).invoke(null, basename, pl) : (spec ? (ImmutableGraph)ObjectParser.fromSpec((String)basename, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE) : ImmutableGraph.load(basename, pl));
            int n = graph.numNodes();
            long samples = jsapResult.getLong("random");
            r.setSeed(seed);
            if (first) {
                totLinks = samples;
            } else {
                long i = samples;
                while (i-- != 0L) {
                    totLinks += (long)graph.outdegree(r.nextInt(n));
                }
            }
            System.err.println(first ? "Accessing the first link on " + samples + " random nodes using ImmutableGraph.successors()..." : "Accessing links on " + samples + " random nodes using ImmutableGraph.successors()...");
            int k = 13;
            while (k-- != 0) {
                long i;
                r.setSeed(seed);
                long time = -System.nanoTime();
                if (first) {
                    i = samples;
                    while (i-- != 0L) {
                        z ^= (long)graph.successors(r.nextInt(n)).nextInt();
                    }
                } else {
                    i = samples;
                    while (i-- != 0L) {
                        LazyIntIterator links = graph.successors(r.nextInt(n));
                        while (links.nextInt() != -1) {
                        }
                    }
                }
                time += System.nanoTime();
                if (k < 10) {
                    cumulativeTime += time;
                }
                System.err.printf("Intermediate time: %3fs nodes: %d; arcs %d; nodes/s: %.3f arcs/s: %.3f ns/node: %3f, ns/link: %.3f\n", (double)time / 1.0E9, samples, totLinks, (double)samples * 1.0E9 / (double)time, (double)totLinks * 1.0E9 / (double)time, (double)time / (double)samples, (double)time / (double)totLinks);
            }
            double averageTime = (double)cumulativeTime / 10.0;
            System.out.printf("Time: %.3fs nodes: %d; arcs %d; nodes/s: %.3f arcs/s: %.3f ns/node: %3f, ns/link: %.3f\n", averageTime / 1.0E9, samples, totLinks, (double)samples * 1.0E9 / averageTime, (double)totLinks * 1.0E9 / averageTime, averageTime / (double)samples, averageTime / (double)totLinks);
        } else if (adjacency) {
            ImmutableGraph graph = jsapResult.userSpecified("graphClass") ? (ImmutableGraph)graphClass.getMethod(ImmutableGraph.LoadMethod.STANDARD.toMethod(), CharSequence.class, ProgressLogger.class).invoke(null, basename, pl) : (spec ? (ImmutableGraph)ObjectParser.fromSpec((String)basename, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE) : ImmutableGraph.load(basename, pl));
            int n = graph.numNodes();
            long samples = jsapResult.getLong("adjacency");
            r.setSeed(seed);
            System.err.println("Testing adjacency on " + samples + " random pairs...");
            int k = 13;
            while (k-- != 0) {
                r.setSeed(seed);
                long time = -System.nanoTime();
                long i = samples;
                while (i-- != 0L) {
                    int s;
                    LazyIntIterator iterator = graph.successors(r.nextInt(n));
                    int other = r.nextInt(n);
                    if (iterator instanceof LazyIntSkippableIterator) {
                        z ^= (long)((LazyIntSkippableIterator)iterator).skipTo(other);
                        continue;
                    }
                    while ((s = iterator.nextInt()) != -1 && s < other) {
                    }
                }
                time += System.nanoTime();
                if (k < 10) {
                    cumulativeTime += time;
                }
                System.err.printf("Intermediate time: %3fs nodes: %d; nodes/s: %.3f ns/node: %3f\n", (double)time / 1.0E9, samples, (double)samples * 1.0E9 / (double)time, (double)time / (double)samples);
            }
            double averageTime = (double)cumulativeTime / 10.0;
            System.out.printf("Time: %.3fs nodes: %d;nodes/s: %.3f ns/node: %3f\n", averageTime / 1.0E9, samples, (double)samples * 1.0E9 / averageTime, averageTime / (double)samples);
        } else {
            if (first) {
                throw new IllegalArgumentException("Option --first requires --random.");
            }
            ImmutableGraph graph = jsapResult.userSpecified("graphClass") ? (ImmutableGraph)graphClass.getMethod(ImmutableGraph.LoadMethod.STANDARD.toMethod(), CharSequence.class, ProgressLogger.class).invoke(null, basename, pl) : (spec ? (ImmutableGraph)ObjectParser.fromSpec((String)basename, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE) : ImmutableGraph.load(basename, pl));
            long samples = graph.numNodes();
            System.err.println("Accessing links sequentially using ImmutableGraph.successorArray()...");
            int k = 13;
            while (k-- != 0) {
                long time = -System.nanoTime();
                NodeIterator nodeIterator = graph.nodeIterator();
                totLinks = 0L;
                long i = samples;
                while (i-- != 0L) {
                    nodeIterator.nextInt();
                    totLinks += (long)nodeIterator.outdegree();
                    nodeIterator.successorArray();
                }
                time += System.nanoTime();
                if (k < 10) {
                    cumulativeTime += time;
                }
                System.err.printf("Intermediate time: %3fs nodes: %d; arcs %d; nodes/s: %.3f arcs/s: %.3f ns/node: %3f, ns/link: %.3f\n", (double)time / 1.0E9, samples, totLinks, (double)samples * 1.0E9 / (double)time, (double)totLinks * 1.0E9 / (double)time, (double)time / (double)samples, (double)time / (double)totLinks);
            }
            double averageTime = (double)cumulativeTime / 10.0;
            System.out.printf("Time: %.3fs nodes: %d; arcs %d; nodes/s: %.3f arcs/s: %.3f ns/node: %3f, ns/link: %.3f\n", averageTime / 1.0E9, samples, totLinks, (double)samples * 1.0E9 / averageTime, (double)totLinks * 1.0E9 / averageTime, averageTime / (double)samples, averageTime / (double)totLinks);
        }
        if (z == 0L) {
            System.err.println('\u0000');
        }
    }
}

