class FloatingButton extends HTMLElement {
  connectedCallback() {
    this.attachShadow({ mode: 'open' });
    this.shadowRoot.innerHTML = `
      <style>
        :host {
          position: fixed;
          bottom: 2rem;
          left: 2rem;
          z-index: 100;
        }
        .floating-btn {
          width: 60px;
          height: 60px;
          border-radius: 50%;
          background: linear-gradient(135deg, #667eea, #764ba2);
          color: white;
          display: flex;
          align-items: center;
          justify-content: center;
          box-shadow: 0 4px 15px rgba(0,0,0,0.2);
          cursor: pointer;
          transition: all 0.3s ease;
        }
        .floating-btn:hover {
          transform: translateY(-3px);
          box-shadow: 0 6px 20px rgba(0,0,0,0.25);
        }
        i {
          font-size: 1.5rem;
        }
      </style>
      <div class="floating-btn" title="تواصل معنا">
        <i data-feather="message-circle"></i>
      </div>
    `;
    
    // Add click event
    this.shadowRoot.querySelector('.floating-btn').addEventListener('click', () => {
      window.location.href = '/contact.html';
    });
  }
}

customElements.define('floating-button', FloatingButton);