class CustomSidebar extends HTMLElement {
  connectedCallback() {
    this.attachShadow({ mode: 'open' });
    this.shadowRoot.innerHTML = `
      <style>
        :host {
          display: block;
          width: 250px;
          background: #f7fafc;
          padding: 1rem;
          height: 100%;
          position: fixed;
          right: 0;
          top: 0;
          border-left: 1px solid #e5e7eb;
          z-index: 40;
        }
        h3 { 
          margin: 0 0 1rem 0;
          padding: 1rem 0;
          border-bottom: 1px solid #e5e7eb;
          font-size: 1.25rem;
          color: #374151;
        }
        ul { 
          list-style: none;
          padding: 0;
          margin: 0;
        }
        li { 
          margin: 0.5rem 0;
        }
        a { 
          display: flex;
          align-items: center;
          gap: 0.5rem;
          color: #374151;
          text-decoration: none;
          padding: 0.5rem;
          border-radius: 0.375rem;
          transition: all 0.2s;
        }
        a:hover { 
          background-color: #e0e7ff;
          color: #4f46e5;
        }
        a.active {
          background-color: #e0e7ff;
          color: #4f46e5;
          font-weight: 500;
        }
        i {
          width: 1.25rem;
          height: 1.25rem;
        }
        @media (max-width: 768px) {
          :host {
            transform: translateX(100%);
            transition: transform 0.3s ease;
          }
          :host(.open) {
            transform: translateX(0);
          }
        }
      </style>
      <div>
        <h3>القائمة الرئيسية</h3>
        <ul>
          <li><a href="index.html"><i data-feather="home"></i> الرئيسية</a></li>
          <li><a href="courses.html"><i data-feather="book"></i> الدورات</a></li>
          <li><a href="media.html"><i data-feather="video"></i> الوسائط</a></li>
          <li><a href="contact.html"><i data-feather="mail"></i> تواصل معنا</a></li>
        </ul>
        
        <h3>حسابي</h3>
        <ul>
          <li><a href="profile.html"><i data-feather="user"></i> الملف الشخصي</a></li>
          <li><a href="settings.html"><i data-feather="settings"></i> الإعدادات</a></li>
        </ul>
      </div>
    `;
  }
}

customElements.define('custom-sidebar', CustomSidebar);